/*
 * Decompiled with CFR 0.152.
 */
package com.hp.desdac.sustainability.gui;

import com.hp.desdac.powerstructure.entities.ApplicationPowerStructure;
import com.hp.desdac.sustainability.EmbeddedExergy;
import com.hp.desdac.sustainability.OperationalExergy;
import com.hp.desdac.sustainability.SustainabilityComponent;
import com.hp.desdac.sustainability.SustainabilityResults;
import com.hp.desdac.sustainability.Tco;
import com.hp.desdac.sustainability.gui.JDialogSustainabilityParameterEvaluation;
import com.hp.desdac.sustainability.gui.JDialogSustainabilityResults;
import com.local.entities.ProjectDesdac;
import com.local.gui.JFrameDesdacTool;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.modcs.tools.rbd.graphrbd.GraphViewRBD;

public class JDialogSustainabilityComponent
extends JDialog {
    private ApplicationPowerStructure applicationPowerStructure;
    private SustainabilityComponent sustainabilityComponent = new SustainabilityComponent();
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private JButton jButtonCancel;
    private JButton jButtonOK;
    private JButton jButton_Evaluate;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JTextField jTextFieldAmbientTemperature;
    private JTextField jTextFieldAvailability;
    private JTextField jTextFieldComponentTemperature;
    private JTextField jTextFieldElecticityCost;
    private JTextField jTextFieldFractionReused;
    private JTextField jTextFieldInputPower;
    private JTextField jTextFieldLifeTime;
    private JTextField jTextFieldManufacturing;

    public JDialogSustainabilityComponent(Frame parent, boolean modal, ApplicationPowerStructure applicationPowerStructure) {
        super(parent, modal);
        this.initComponents();
        this.applicationPowerStructure = applicationPowerStructure;
        if (((JFrameDesdacTool)parent).getProjectDesdac().getAvailability() != null) {
            this.jTextFieldAvailability.setText(((JFrameDesdacTool)parent).getProjectDesdac().getAvailability() + "");
        }
    }

    public SustainabilityComponent getSustainabilityComponent() {
        return this.sustainabilityComponent;
    }

    public void setSustainabilityComponent(SustainabilityComponent sustainabilityComponent) {
        this.sustainabilityComponent = sustainabilityComponent;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    private void initComponents() {
        this.jButtonCancel = new JButton();
        this.jButtonOK = new JButton();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jTextFieldManufacturing = new JTextField();
        this.jTextFieldFractionReused = new JTextField();
        this.jPanel2 = new JPanel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jTextFieldAmbientTemperature = new JTextField();
        this.jTextFieldComponentTemperature = new JTextField();
        this.jTextFieldInputPower = new JTextField();
        this.jTextFieldLifeTime = new JTextField();
        this.jLabel7 = new JLabel();
        this.jTextFieldAvailability = new JTextField();
        this.jPanel3 = new JPanel();
        this.jLabel8 = new JLabel();
        this.jTextFieldElecticityCost = new JTextField();
        this.jButton_Evaluate = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Sustainability Evaluation");
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JDialogSustainabilityComponent.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JDialogSustainabilityComponent.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Embedded Exergy Parameters"));
        this.jPanel1.setToolTipText("Embedded Exergy");
        this.jLabel1.setText("Manufacturing second-law efficiency:");
        this.jLabel2.setText("Fraction of waste reused or recovered (%): ");
        this.jTextFieldManufacturing.setText("0.5");
        this.jTextFieldFractionReused.setText("10");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2).addComponent(this.jLabel1)).addGap(18, 18, 18).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextFieldFractionReused, -1, 80, Short.MAX_VALUE).addComponent(this.jTextFieldManufacturing, -1, 80, Short.MAX_VALUE)).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addComponent(this.jTextFieldManufacturing, -2, -1, -2)).addGap(18, 18, 18).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.jTextFieldFractionReused, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Operational Exergy Parameters"));
        this.jLabel3.setText("Ambient Operating Temperature (C):");
        this.jLabel4.setText("Component Operating Temperature (C):");
        this.jLabel5.setText("System Output Power (kw):");
        this.jLabel6.setText("Total Lifetime (h):");
        this.jTextFieldAmbientTemperature.setText("30");
        this.jTextFieldComponentTemperature.setText("60");
        this.jLabel7.setText("Availability:");
        this.jTextFieldAvailability.setToolTipText("When not specified, the system will compute it.");
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel4).addComponent(this.jLabel5).addComponent(this.jLabel6).addComponent(this.jLabel3).addComponent(this.jLabel7)).addGap(26, 26, 26).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jTextFieldAvailability, -1, 95, Short.MAX_VALUE).addComponent(this.jTextFieldAmbientTemperature, GroupLayout.Alignment.LEADING, -1, 95, Short.MAX_VALUE).addComponent(this.jTextFieldComponentTemperature, GroupLayout.Alignment.LEADING, -1, 95, Short.MAX_VALUE).addComponent(this.jTextFieldInputPower, GroupLayout.Alignment.LEADING, -1, 95, Short.MAX_VALUE).addComponent(this.jTextFieldLifeTime, GroupLayout.Alignment.LEADING, -1, 95, Short.MAX_VALUE)).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel7).addComponent(this.jTextFieldAvailability, -2, -1, -2)).addGap(18, 18, 18).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.jTextFieldAmbientTemperature, -2, -1, -2)).addGap(19, 19, 19).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.jTextFieldComponentTemperature, -2, -1, -2)).addGap(18, 18, 18).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.jTextFieldInputPower, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6).addComponent(this.jTextFieldLifeTime, -2, -1, -2)).addContainerGap(24, Short.MAX_VALUE)));
        this.jPanel3.setBorder(BorderFactory.createTitledBorder("TCO Parameters"));
        this.jLabel8.setText("Electricity Cost (per KWH): ");
        this.jTextFieldElecticityCost.setText("0.11");
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel8).addGap(100, 100, 100).addComponent(this.jTextFieldElecticityCost, -1, 96, Short.MAX_VALUE).addContainerGap()));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel8).addComponent(this.jTextFieldElecticityCost, -2, -1, -2)).addContainerGap(29, Short.MAX_VALUE)));
        this.jButton_Evaluate.setText("Evaluate");
        this.jButton_Evaluate.setToolTipText("To perform the evaluation with a parameter range.");
        this.jButton_Evaluate.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JDialogSustainabilityComponent.this.jButton_EvaluateActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(78, 78, 78).addComponent(this.jButtonOK, -2, 61, -2).addGap(18, 18, 18).addComponent(this.jButtonCancel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButton_Evaluate).addContainerGap(91, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jPanel1, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel2, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel3, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -2, -1, -2).addGap(18, 18, 18).addComponent(this.jPanel2, -2, -1, -2).addGap(18, 18, 18).addComponent(this.jPanel3, -2, -1, -2).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonOK).addComponent(this.jButtonCancel).addComponent(this.jButton_Evaluate)).addContainerGap(14, Short.MAX_VALUE)));
        this.pack();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        try {
            double availability;
            double fwr = Double.parseDouble(this.jTextFieldFractionReused.getText());
            double msle = Double.parseDouble(this.jTextFieldManufacturing.getText());
            JFrameDesdacTool jFrameDesdacTool = (JFrameDesdacTool)this.getParent();
            EmbeddedExergy embeddedExergy = new EmbeddedExergy(msle, fwr, this.applicationPowerStructure);
            double embExergy = embeddedExergy.computeEmbeddedExergy();
            String result = "Exergy\n======\nEmbedded Exergy Consumption (GJ): " + embExergy;
            if (!this.jTextFieldAvailability.getText().equals("")) {
                availability = Double.parseDouble(this.jTextFieldAvailability.getText());
            } else {
                jFrameDesdacTool.translateRBD(this.applicationPowerStructure);
                availability = GraphViewRBD.app.getRBDModel().getModel().calculateAvailability(9.223372036854776E18);
            }
            double ambTemp = Double.parseDouble(this.jTextFieldAmbientTemperature.getText());
            double compTemp = Double.parseDouble(this.jTextFieldComponentTemperature.getText());
            double systemOutputPower = Double.parseDouble(this.jTextFieldInputPower.getText());
            int lifeTime = Integer.parseInt(this.jTextFieldLifeTime.getText());
            double systemEfficiency = 0.0;
            SustainabilityComponent sustainabilityComponent = new SustainabilityComponent(ambTemp, compTemp, systemOutputPower, lifeTime, systemEfficiency, availability);
            OperationalExergy operationalExergy = new OperationalExergy(sustainabilityComponent, this.applicationPowerStructure);
            double operExergy = operationalExergy.computeOperationalExergy();
            result = result + "\nOperational Exergy Consumption (GJ): " + operExergy;
            double lifeTimeExergy = operExergy + embExergy;
            result = result + "\nLifetime Exergy Consumption (GJ): " + lifeTimeExergy;
            double eletricityCost = Double.parseDouble(this.jTextFieldElecticityCost.getText());
            double in = operationalExergy.getSystemInputPower();
            double out = systemOutputPower;
            double ef = out / in;
            Tco tCO = new Tco(eletricityCost, this.applicationPowerStructure);
            double operCost = tCO.computeOperationalCost(in, lifeTime, ef);
            double iniCost = tCO.computeInitialCost();
            result = result + "\n\nTCO\n======\nInitial Cost: " + iniCost + "\nOperational Cost: " + operCost + "\nTotal Cost: " + (operCost + iniCost) + "\n\n";
            result = result + "Availability: " + availability;
            result = result + "\nSystem Efficiency: " + ef + "\n";
            ArrayList<SustainabilityResults> arraySustainabilityResults = new ArrayList<SustainabilityResults>();
            SustainabilityResults sustainabilityResults = new SustainabilityResults();
            sustainabilityResults.setLegend("Results");
            sustainabilityResults.setEmbeddedExergy(embExergy);
            sustainabilityResults.setOperationalExergy(operExergy);
            sustainabilityResults.setLifetimeExergy(lifeTimeExergy);
            sustainabilityResults.setOperationalCost(operCost);
            sustainabilityResults.setInitialCost(iniCost);
            sustainabilityResults.setTotalCost(operCost + iniCost);
            sustainabilityResults.setEfficiency(ef);
            sustainabilityResults.setAvailability(availability);
            arraySustainabilityResults.add(sustainabilityResults);
            JDialogSustainabilityResults susResults = new JDialogSustainabilityResults(null, true, result, arraySustainabilityResults);
            susResults.setLocationRelativeTo(this);
            susResults.setVisible(true);
        }
        catch (NumberFormatException e) {
            JOptionPane.showMessageDialog(null, "Incorret Number format.");
        }
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButton_EvaluateActionPerformed(ActionEvent evt) {
        try {
            double availability;
            double fwr = Double.parseDouble(this.jTextFieldFractionReused.getText());
            double msle = Double.parseDouble(this.jTextFieldManufacturing.getText());
            JFrameDesdacTool jFrameDesdacTool = (JFrameDesdacTool)this.getParent();
            ProjectDesdac projectDesdac = jFrameDesdacTool.getProjectDesdac();
            if (!this.jTextFieldAvailability.getText().equals("")) {
                availability = Double.parseDouble(this.jTextFieldAvailability.getText());
            } else {
                jFrameDesdacTool.translateRBD();
                availability = GraphViewRBD.app.getRBDModel().getModel().calculateAvailability(9.223372036854776E18);
            }
            double ambTemp = Double.parseDouble(this.jTextFieldAmbientTemperature.getText());
            double compTemp = Double.parseDouble(this.jTextFieldComponentTemperature.getText());
            double systemOutputPower = Double.parseDouble(this.jTextFieldInputPower.getText());
            int lifeTime = Integer.parseInt(this.jTextFieldLifeTime.getText());
            double eletricityCost = Double.parseDouble(this.jTextFieldElecticityCost.getText());
            JDialogSustainabilityParameterEvaluation susResults = new JDialogSustainabilityParameterEvaluation(null, true, fwr, msle, availability, ambTemp, systemOutputPower, lifeTime, eletricityCost, compTemp, jFrameDesdacTool, this.applicationPowerStructure);
            susResults.setLocationRelativeTo(this);
            susResults.setVisible(true);
        }
        catch (NumberFormatException e) {
            JOptionPane.showMessageDialog(null, "Incorret Number format.");
        }
    }
}

