/*
 * Decompiled with CFR 0.152.
 */
package com.hp.desdac.sustainability;

import com.hp.desdac.powerstructure.entities.ApplicationPowerStructure;
import com.hp.desdac.powerstructure.entities.DataCenterArc;
import com.hp.desdac.powerstructure.entities.DataCenterComponent;
import com.hp.desdac.powerstructure.gui.graphview.ComponentGraphicalElement;
import com.hp.desdac.powerstructure.gui.graphview.GraphEdXPowerDataCenter;
import com.hp.desdac.powerstructure.gui.graphview.GraphicalConnectionDataCenter;
import com.hp.desdac.powerstructure.translate.EngineDataCenterConvert;
import com.hp.desdac.powerstructure.translate.LoopDetectedException;
import com.hp.desdac.sustainability.SustainabilityComponent;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import org.modcs.tools.Util.booleanreduction.MinimizedTable;
import org.modcs.tools.Util.booleanreduction.ProductTerm;
import org.modcs.tools.rbd.blocks.Block;
import org.modcs.tools.rbd.blocks.BlockExponential;
import org.modcs.tools.rbd.blocks.BlockParallel;
import org.modcs.tools.rbd.blocks.BlockSeries;
import org.modcs.tools.rbd.blocks.RBDModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OperationalExergy
extends EngineDataCenterConvert {
    private ApplicationPowerStructure applicationPowerStructure;
    private double systemInputPower = 0.0;
    private GraphicalConnectionDataCenter graphicalConnectionDataCenter;
    private SustainabilityComponent sustainabilityComponentAllSystem;

    public OperationalExergy(SustainabilityComponent sustainabilityComponent, ApplicationPowerStructure applicationPowerStructure) {
        super(applicationPowerStructure);
        this.sustainabilityComponentAllSystem = sustainabilityComponent;
        this.applicationPowerStructure = applicationPowerStructure;
    }

    public OperationalExergy(ApplicationPowerStructure applicationPowerStructure, double systemOutputPower) {
        this(new SustainabilityComponent(), applicationPowerStructure);
        this.sustainabilityComponentAllSystem.setSystemOutputPower(systemOutputPower);
    }

    public double getSystemInputPower() {
        return this.systemInputPower;
    }

    public GraphicalConnectionDataCenter getGraphicalConnectionDataCenter() {
        return this.graphicalConnectionDataCenter;
    }

    public void setGraphicalConnectionDataCenter(GraphicalConnectionDataCenter graphicalConnectionDataCenter) {
        this.graphicalConnectionDataCenter = graphicalConnectionDataCenter;
    }

    public ApplicationPowerStructure getApplicationPowerStructure() {
        return this.applicationPowerStructure;
    }

    public void setApplicationPowerStructure(ApplicationPowerStructure applicationPowerStructure) {
        this.applicationPowerStructure = applicationPowerStructure;
    }

    public double computeOperationalExergy() {
        double in = this.computeInputPower();
        double out = this.sustainabilityComponentAllSystem.getSystemOutputPower();
        double ef = out / in;
        double operationalExergy = (this.sustainabilityComponentAllSystem.getAmbTemp() + 273.15) / (this.sustainabilityComponentAllSystem.getCompTemp() + 273.15) * (1.0 - ef) * out * this.sustainabilityComponentAllSystem.getLifeTime() * this.sustainabilityComponentAllSystem.getAvailability() * 3.6 / 1000.0;
        return operationalExergy;
    }

    public boolean allParentsFail(GraphicalConnectionDataCenter graphicalConnectionDataCenter, ComponentGraphicalElement componentGraphicalElement) {
        ArrayList<ComponentGraphicalElement> parentsComponents = this.getComponentParents(graphicalConnectionDataCenter, componentGraphicalElement);
        if (parentsComponents.isEmpty()) {
            return false;
        }
        for (int i = 0; i < parentsComponents.size(); ++i) {
            ComponentGraphicalElement parent = parentsComponents.get(i);
            if (!parent.getDataCenterComponent().isWorking()) continue;
            return false;
        }
        return true;
    }

    public void breadthFirstSearch(GraphicalConnectionDataCenter graphicalConnectionDataCenter, ComponentGraphicalElement componentGraphicalElement) {
        LinkedList<ComponentGraphicalElement> queue = new LinkedList<ComponentGraphicalElement>();
        queue.add(componentGraphicalElement);
        while (!queue.isEmpty()) {
            ComponentGraphicalElement currentComponent = (ComponentGraphicalElement)queue.remove();
            ArrayList<ComponentGraphicalElement> children = this.getComponentsChildren(graphicalConnectionDataCenter, currentComponent);
            for (int i = 0; i < children.size(); ++i) {
                ComponentGraphicalElement child = children.get(i);
                if (this.allParentsFail(graphicalConnectionDataCenter, child)) {
                    child.getDataCenterComponent().setWorking(false);
                }
                queue.add(child);
            }
        }
    }

    public void propagateFailComponents() {
        GraphEdXPowerDataCenter graphEdXDataCenter = this.applicationPowerStructure.getGraphViewDataCenter().getApp();
        this.graphicalConnectionDataCenter = GraphicalConnectionDataCenter.createGraphicalConnectionDataCenter(graphEdXDataCenter);
        ArrayList<ComponentGraphicalElement> rootsComponents = this.getRootComponents(this.graphicalConnectionDataCenter);
        for (int i = 0; i < rootsComponents.size(); ++i) {
            this.breadthFirstSearch(this.graphicalConnectionDataCenter, rootsComponents.get(i));
        }
    }

    public ArrayList<DataCenterComponent> getDataCenterComponentsWithPath() {
        GraphEdXPowerDataCenter graphEdXDataCenter = this.applicationPowerStructure.getGraphViewDataCenter().getApp();
        this.graphicalConnectionDataCenter = GraphicalConnectionDataCenter.createGraphicalConnectionDataCenter(graphEdXDataCenter);
        ArrayList<ComponentGraphicalElement> componentGraphicalElements = this.graphicalConnectionDataCenter.getComponentGraphicalElements();
        ArrayList<DataCenterComponent> dataCenterComponents = new ArrayList<DataCenterComponent>();
        for (int i = 0; i < componentGraphicalElements.size(); ++i) {
            ComponentGraphicalElement componentGraphicalElement = componentGraphicalElements.get(i);
            if (componentGraphicalElement.getDataCenterComponent().getName().startsWith("SourcePoint") || componentGraphicalElement.getDataCenterComponent().getName().startsWith("TargetPoint") || !this.thereIsPath(this.graphicalConnectionDataCenter.getArrowGraphicalElements(), componentGraphicalElement)) continue;
            dataCenterComponents.add(componentGraphicalElement.getDataCenterComponent());
        }
        return dataCenterComponents;
    }

    public RBDModel evaluateRBDModel(double outputPower) throws Exception {
        RBDModel rbdModel = new RBDModel("Teste");
        BlockSeries blockSeries = new BlockSeries("");
        rbdModel.incrementIndexOfBlocks();
        rbdModel.setModel(blockSeries);
        ArrayList<DataCenterComponent> dataCenterComponents = this.getDataCenterComponentsWithPath();
        BigInteger maxCount = BigInteger.valueOf(2L).pow(dataCenterComponents.size());
        if (dataCenterComponents.size() > 32) {
            BigInteger count = BigInteger.ZERO;
            while (count.compareTo(maxCount) < 0) {
                Block blockParallel;
                this.setComponentsStates(count, dataCenterComponents);
                this.propagateFailComponents();
                if (!this.evaluatePowerDependencies() && (blockParallel = this.getBlock(rbdModel, count, dataCenterComponents)) != null) {
                    blockSeries.addBlock(blockParallel);
                }
                count = count.add(BigInteger.ONE);
            }
        } else {
            int max = (int)Math.pow(2.0, dataCenterComponents.size());
            ArrayList<Integer> arrayMiniterms = new ArrayList<Integer>();
            for (int i = 0; i < max; ++i) {
                this.setComponentsStates(BigInteger.valueOf(i), dataCenterComponents);
                this.propagateFailComponents();
                if (this.evaluatePowerDependencies()) continue;
                arrayMiniterms.add(i);
            }
            int[] intMiniterms = new int[arrayMiniterms.size()];
            for (int i = 0; i < intMiniterms.length; ++i) {
                intMiniterms[i] = (Integer)arrayMiniterms.get(i);
            }
            MinimizedTable minimizedTable = new MinimizedTable(intMiniterms);
            Vector<ProductTerm> productTerms = minimizedTable.getMinimum();
            System.out.println(minimizedTable.toString());
            for (int i = 0; i < productTerms.size(); ++i) {
                ProductTerm productTerm = productTerms.elementAt(i);
                Block block = this.getBlock(rbdModel, BigInteger.valueOf(productTerm.getMinimizedValue()), dataCenterComponents);
                if (block == null) continue;
                blockSeries.addBlock(block);
            }
        }
        return rbdModel;
    }

    public String evaluateFail(double outputPower) throws Exception {
        String message = "";
        boolean debug = false;
        ArrayList<DataCenterComponent> dataCenterComponents = this.getDataCenterComponentsWithPath();
        BigInteger maxCount = BigInteger.valueOf(2L).pow(dataCenterComponents.size());
        if (debug || dataCenterComponents.size() > 32) {
            BigInteger count = BigInteger.ZERO;
            while (count.compareTo(maxCount) < 0) {
                this.setComponentsStates(count, dataCenterComponents);
                this.propagateFailComponents();
                if (!this.evaluatePowerDependencies()) {
                    String temp = this.printComponentsStates(count, dataCenterComponents);
                    String appendMessage = temp + "OR";
                    if (!temp.isEmpty()) {
                        message = message + appendMessage;
                    } else {
                        return "(1=1)";
                    }
                }
                count = count.add(BigInteger.ONE);
            }
        } else {
            int max = (int)Math.pow(2.0, dataCenterComponents.size());
            ArrayList<Integer> arrayMiniterms = new ArrayList<Integer>();
            for (int i = 0; i < max; ++i) {
                this.setComponentsStates(BigInteger.valueOf(i), dataCenterComponents);
                this.propagateFailComponents();
                if (this.evaluatePowerDependencies()) continue;
                arrayMiniterms.add(i);
            }
            int[] intMiniterms = new int[arrayMiniterms.size()];
            for (int i = 0; i < intMiniterms.length; ++i) {
                intMiniterms[i] = (Integer)arrayMiniterms.get(i);
            }
            MinimizedTable minimizedTable = new MinimizedTable(intMiniterms);
            Vector<ProductTerm> productTerms = minimizedTable.getMinimum();
            System.out.println(minimizedTable.toString());
            for (int i = 0; i < productTerms.size(); ++i) {
                ProductTerm productTerm = productTerms.elementAt(i);
                String temp = this.printComponentsStates(BigInteger.valueOf(productTerm.getMinimizedValue()), dataCenterComponents);
                String appendMessage = temp + "OR";
                if (temp.isEmpty()) {
                    return "(1=1)";
                }
                message = message + appendMessage;
            }
        }
        if (!message.isEmpty()) {
            message = "(" + message.substring(0, message.length() - 2) + ")";
        }
        return message;
    }

    public void setComponentsStates(BigInteger workingSet, ArrayList<DataCenterComponent> dataCenterComponents) {
        for (int i = 0; i < dataCenterComponents.size(); ++i) {
            DataCenterComponent dataCenterComponent = dataCenterComponents.get(i);
            dataCenterComponent.setWorking(workingSet.testBit(i));
        }
    }

    public BigInteger getComponentsStates(ArrayList<DataCenterComponent> dataCenterComponents) {
        BigInteger workingSet = BigInteger.ZERO;
        for (int i = 0; i < dataCenterComponents.size(); ++i) {
            if (!dataCenterComponents.get(i).isWorking()) continue;
            workingSet = workingSet.setBit(i);
        }
        return workingSet;
    }

    public String printComponentsStates(BigInteger workingComponents, ArrayList<DataCenterComponent> dataCenterComponents) {
        String result = "";
        for (int i = 0; i < dataCenterComponents.size(); ++i) {
            if (workingComponents.testBit(i)) continue;
            result = result + "(#" + dataCenterComponents.get(i).getName() + "_ON=0)";
            result = result + "AND";
        }
        if (!result.isEmpty()) {
            result = "(" + result.substring(0, result.length() - 3) + ")";
        }
        return result;
    }

    public Block getBlock(RBDModel rBDModel, BigInteger workingComponents, ArrayList<DataCenterComponent> dataCenterComponents) {
        BlockExponential currentBlock = null;
        BlockParallel blockParallel = new BlockParallel("");
        int numberBlocks = 0;
        for (int i = 0; i < dataCenterComponents.size(); ++i) {
            if (workingComponents.testBit(i)) continue;
            ++numberBlocks;
            currentBlock = this.getBlockByName(this.graphicalConnectionDataCenter, dataCenterComponents.get(i).getName(), rBDModel);
            blockParallel.addBlock(currentBlock);
        }
        if (numberBlocks == 1) {
            return currentBlock;
        }
        if (numberBlocks > 1) {
            return blockParallel;
        }
        return null;
    }

    public boolean evaluatePowerDependencies() throws Exception {
        boolean result = false;
        GraphEdXPowerDataCenter graphEdXDataCenter = this.applicationPowerStructure.getGraphViewDataCenter().getApp();
        this.graphicalConnectionDataCenter = GraphicalConnectionDataCenter.createGraphicalConnectionDataCenter(graphEdXDataCenter);
        ArrayList<ComponentGraphicalElement> leafComponents = this.getLeafComponents(this.graphicalConnectionDataCenter);
        ArrayList<ComponentGraphicalElement> graphicalElements = this.graphicalConnectionDataCenter.getComponentGraphicalElements();
        if (leafComponents.size() == 1) {
            for (int i = 0; i < graphicalElements.size(); ++i) {
                ComponentGraphicalElement componentGraphicalElement = graphicalElements.get(i);
                componentGraphicalElement.getDataCenterComponent().getSustainabilityComponent().setOutputPower(0.0);
                componentGraphicalElement.setVisited(false);
            }
            double outputPower = this.sustainabilityComponentAllSystem.getSystemOutputPower();
            leafComponents.get(0).getDataCenterComponent().getSustainabilityComponent().setOutputPower(outputPower);
            leafComponents.get(0).getDataCenterComponent().getSustainabilityComponent().setMaxPower(Double.MAX_VALUE);
            leafComponents.get(0).getDataCenterComponent().getSustainabilityComponent().setDeliEff(100.0);
            this.systemInputPower = 0.0;
            result = this.evaluatePath(this.graphicalConnectionDataCenter, leafComponents.get(0));
            ArrayList<ComponentGraphicalElement> rootGraphicalElements = this.getRootComponents(this.graphicalConnectionDataCenter);
            for (int i = 0; i < rootGraphicalElements.size(); ++i) {
                SustainabilityComponent sustainabilityComponent = rootGraphicalElements.get(i).getDataCenterComponent().getSustainabilityComponent();
                this.systemInputPower += 100.0 * sustainabilityComponent.getOutputPower() / sustainabilityComponent.getDeliEff();
            }
        } else {
            throw new Exception("You should consider only one endPoint.");
        }
        return result;
    }

    public double computeInputPower() {
        double in = 0.0;
        try {
            GraphEdXPowerDataCenter graphEdXDataCenter = this.applicationPowerStructure.getGraphViewDataCenter().getApp();
            this.graphicalConnectionDataCenter = GraphicalConnectionDataCenter.createGraphicalConnectionDataCenter(graphEdXDataCenter);
            ArrayList<ComponentGraphicalElement> leafComponents = this.getLeafComponents(this.graphicalConnectionDataCenter);
            if (leafComponents.size() > 1) {
                JOptionPane.showMessageDialog(null, "You should consider only one endPoint.");
            } else {
                in = this.createPath(this.graphicalConnectionDataCenter, leafComponents.get(0));
                for (int i = 0; i < this.graphicalConnectionDataCenter.getComponentGraphicalElements().size(); ++i) {
                    SustainabilityComponent parentComponent = this.graphicalConnectionDataCenter.getComponentGraphicalElements().get(i).getDataCenterComponent().getSustainabilityComponent();
                    parentComponent.setInputPower(0.0);
                    parentComponent.setOutputPower(0.0);
                }
            }
            return in;
        }
        catch (LoopDetectedException ex) {
            Logger.getLogger(OperationalExergy.class.getName()).log(Level.SEVERE, null, ex);
            return in;
        }
    }

    private double createPath(GraphicalConnectionDataCenter graphicalConnectionDataCenter, ComponentGraphicalElement componentGraphicalElement) throws LoopDetectedException {
        ArrayList<ComponentGraphicalElement> parentsComponents = this.getComponentParents(graphicalConnectionDataCenter, componentGraphicalElement);
        SustainabilityComponent currentComponent = componentGraphicalElement.getDataCenterComponent().getSustainabilityComponent();
        if (currentComponent.getOutputPower() == 0.0) {
            currentComponent.setOutputPower(this.sustainabilityComponentAllSystem.getSystemOutputPower());
        }
        ArrayList<DataCenterArc> weights = this.getArcsFromParents(graphicalConnectionDataCenter, componentGraphicalElement);
        if (parentsComponents.isEmpty()) {
            double input;
            double realPower = 0.0;
            realPower = input = currentComponent.getOutputPower();
            this.systemInputPower += realPower;
            return this.systemInputPower;
        }
        if (parentsComponents.size() == 1) {
            SustainabilityComponent parentComponent = parentsComponents.get(0).getDataCenterComponent().getSustainabilityComponent();
            double realPower = 0.0;
            double weight = 0.0;
            double input = currentComponent.getOutputPower();
            weight = weights.get(0).getWeight();
            realPower = input * weight;
            parentComponent.setInputPower(realPower);
            parentComponent.setOutputPower(realPower / parentComponent.getDeliEff() * 100.0);
            this.createPath(graphicalConnectionDataCenter, parentsComponents.get(0));
            return this.systemInputPower;
        }
        if (parentsComponents.size() >= 1) {
            for (int i = 0; i < parentsComponents.size(); ++i) {
                SustainabilityComponent parentComponent = parentsComponents.get(i).getDataCenterComponent().getSustainabilityComponent();
                double realPower = 0.0;
                double weight = 0.0;
                double input = currentComponent.getOutputPower();
                weight = weights.get(i).getWeight();
                realPower = input * weight;
                parentComponent.setInputPower(realPower);
                parentComponent.setOutputPower(realPower / parentComponent.getDeliEff() * 100.0);
                this.createPath(graphicalConnectionDataCenter, parentsComponents.get(i));
            }
        }
        return this.systemInputPower;
    }

    private boolean evaluatePath(GraphicalConnectionDataCenter graphicalConnectionDataCenter, ComponentGraphicalElement componentGraphicalElement) {
        boolean existComponentFailed = false;
        boolean foundFinalComponent = false;
        LinkedList<ComponentGraphicalElement> queue = new LinkedList<ComponentGraphicalElement>();
        queue.add(componentGraphicalElement);
        while (!queue.isEmpty()) {
            SustainabilityComponent sustainabilityComponent;
            int i;
            ComponentGraphicalElement currentGraphicalElement = (ComponentGraphicalElement)queue.remove();
            ArrayList<ComponentGraphicalElement> parents = this.getComponentParents(graphicalConnectionDataCenter, currentGraphicalElement);
            SustainabilityComponent currentComponent = currentGraphicalElement.getDataCenterComponent().getSustainabilityComponent();
            if (currentComponent.getOutputPower() > currentComponent.getMaxPower()) {
                existComponentFailed = true;
            }
            if (this.isRoot(graphicalConnectionDataCenter, currentGraphicalElement)) {
                foundFinalComponent = true;
            }
            double admitanceSum = 0.0;
            ArrayList<DataCenterArc> weights = this.getArcsFromParents(graphicalConnectionDataCenter, currentGraphicalElement);
            for (i = 0; i < parents.size(); ++i) {
                if (!parents.get(i).getDataCenterComponent().isWorking()) continue;
                sustainabilityComponent = parents.get(i).getDataCenterComponent().getSustainabilityComponent();
                admitanceSum += sustainabilityComponent.getMaxPower() * weights.get(i).getWeight();
            }
            for (i = 0; i < parents.size(); ++i) {
                if (!parents.get(i).getDataCenterComponent().isWorking()) continue;
                sustainabilityComponent = parents.get(i).getDataCenterComponent().getSustainabilityComponent();
                double admitanceFactor = sustainabilityComponent.getMaxPower() * weights.get(i).getWeight() / admitanceSum;
                double parentPowerFactor = 100.0 * currentComponent.getOutputPower() / currentComponent.getDeliEff();
                sustainabilityComponent.setOutputPower(sustainabilityComponent.getOutputPower() + (parentPowerFactor *= admitanceFactor));
                if (queue.contains(parents.get(i))) continue;
                queue.add(parents.get(i));
            }
        }
        return !existComponentFailed && foundFinalComponent;
    }
}

