/*
 * Decompiled with CFR 0.152.
 */
package com.hp.desdac.sustainability;

import com.hp.desdac.powerstructure.entities.ApplicationPowerStructure;
import com.hp.desdac.powerstructure.entities.DataCenterComponent;
import com.hp.desdac.powerstructure.gui.graphview.ComponentGraphicalElement;
import com.hp.desdac.powerstructure.gui.graphview.GraphEdXPowerDataCenter;
import com.hp.desdac.powerstructure.gui.graphview.GraphicalConnectionDataCenter;
import com.hp.desdac.sustainability.SustainabilityComponent;
import java.util.ArrayList;

public class EmbeddedExergy
extends SustainabilityComponent {
    private ApplicationPowerStructure applicationPowerStructure;

    public EmbeddedExergy(double MSLE, double FWR, ApplicationPowerStructure applicationPowerStructure) {
        super(MSLE, FWR);
        this.applicationPowerStructure = applicationPowerStructure;
    }

    public EmbeddedExergy(double maxPower, double MSLE, double FWR, double ambTemp, double compTemp, int outputPower, int lifeTime, double deliEff, double availability, ApplicationPowerStructure applicationPowerStructure) {
        super(maxPower, MSLE, FWR, ambTemp, compTemp, outputPower, lifeTime, deliEff, deliEff, availability, availability);
        this.applicationPowerStructure = applicationPowerStructure;
    }

    public double computeEmbeddedExergy() {
        double embeddedExergy = this.SumEmbeddedEnergy() * (this.getMSLE() + (1.0 - this.getMSLE()) * (1.0 - this.getFWR() / 100.0));
        return embeddedExergy;
    }

    public double SumEmbeddedEnergy() {
        GraphicalConnectionDataCenter graphicalConnectionDataCenter = new GraphicalConnectionDataCenter();
        GraphEdXPowerDataCenter graphEdXDataCenter = this.applicationPowerStructure.getGraphViewDataCenter().getApp();
        graphicalConnectionDataCenter = this.allElements(graphEdXDataCenter);
        ArrayList<ComponentGraphicalElement> elements = graphicalConnectionDataCenter.getComponentGraphicalElements();
        double sum = 0.0;
        for (int i = 0; i < elements.size(); ++i) {
            ComponentGraphicalElement defaultElement;
            Object object = elements.get(i);
            if (object == null || !(object instanceof ComponentGraphicalElement) || !((object = (defaultElement = object).getDataCenterComponent()) instanceof DataCenterComponent)) continue;
            DataCenterComponent dataCenterComponent = (DataCenterComponent)object;
            sum += dataCenterComponent.getSustainabilityComponent().getEmbeddedEnergy();
        }
        return sum;
    }
}

