/*
 * Decompiled with CFR 0.152.
 */
package com.hp.desdac.powerstructure.gui;

import com.hp.desdac.powerstructure.entities.DataCenterComponent;
import com.hp.desdac.sustainability.SustainabilityComponent;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.FilteredImageSource;
import java.awt.image.ReplicateScaleFilter;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.filechooser.FileFilter;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.beansbinding.Property;
import org.modcs.tools.Util.Util;

public class JPanelEditComponent
extends JPanel {
    private DataCenterComponent dataCenterComponent;
    public static final String PROP_DATACENTERCOMPONENT = "dataCenterComponent";
    private ImageIcon image;
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private JButton jButton1;
    private JCheckBox jCheckBox1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabelFigure;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JTextField jTextField1;
    private JTextField jTextField2;
    private JTextField jTextField3;
    private JTextField jTextField4;
    private JTextField jTextFieldEfficiency;
    private JTextField jTextFieldEmbeddedEnergy;
    private JTextField jTextFieldPower;
    private JTextField jTextFieldProducerPrice;
    private BindingGroup bindingGroup;

    public DataCenterComponent getDataCenterComponent() {
        return this.dataCenterComponent;
    }

    public ImageIcon getImageIcon() {
        return this.image;
    }

    public void setDataCenterComponent(DataCenterComponent dataCenterComponent) {
        DataCenterComponent oldDataCenterComponent = this.dataCenterComponent;
        this.dataCenterComponent = dataCenterComponent;
        this.propertyChangeSupport.firePropertyChange(PROP_DATACENTERCOMPONENT, oldDataCenterComponent, dataCenterComponent);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public JPanelEditComponent() {
        this.initComponents();
    }

    public void updateParametersSustainability(SustainabilityComponent susComponent) {
        this.jTextFieldEfficiency.setText(susComponent.getDeliEff() + "");
        this.jTextFieldEmbeddedEnergy.setText(susComponent.getEmbeddedEnergy() + "");
        this.jTextFieldProducerPrice.setText(susComponent.getProducerPrice() + "");
        this.jTextFieldPower.setText(susComponent.getMaxPower() + "");
    }

    public void loadParametersSustainability() {
        SustainabilityComponent susComponent = this.getDataCenterComponent().getSustainabilityComponent();
        try {
            susComponent.setDeliEff(Double.parseDouble(this.jTextFieldEfficiency.getText()));
            susComponent.setEmbeddedEnergy(Double.parseDouble(this.jTextFieldEmbeddedEnergy.getText()));
            susComponent.setProducerPrice(Double.parseDouble(this.jTextFieldProducerPrice.getText()));
            susComponent.setMaxPower(Double.parseDouble(this.jTextFieldPower.getText()));
        }
        catch (NumberFormatException e) {
            JOptionPane.showMessageDialog(null, "Incorret Number format.");
        }
    }

    public void showImageSelectedComponent() {
        if (this.dataCenterComponent != null) {
            ImageIcon icon = null;
            icon = this.dataCenterComponent.getPath() != null && !this.dataCenterComponent.getPath().equals("") ? new ImageIcon(this.getClass().getResource(this.dataCenterComponent.getPath())) : new ImageIcon(this.getClass().getResource("/org/modcs/tools/gui/icons/Component.png"));
            this.jLabelFigure.setIcon(Util.resizeImage(icon, 130));
        }
    }

    public JPanelEditComponent(DataCenterComponent dataCenterComponent) {
        this();
        this.setDataCenterComponent(dataCenterComponent);
        this.showImageSelectedComponent();
        this.updateParametersSustainability(dataCenterComponent.getSustainabilityComponent());
    }

    private void initComponents() {
        this.bindingGroup = new BindingGroup();
        this.jPanel1 = new JPanel();
        this.jLabelFigure = new JLabel();
        this.jPanel2 = new JPanel();
        this.jTextField2 = new JTextField();
        this.jTextField3 = new JTextField();
        this.jLabel3 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jButton1 = new JButton();
        this.jTextField4 = new JTextField();
        this.jTextField1 = new JTextField();
        this.jLabel1 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jPanel3 = new JPanel();
        this.jTextFieldProducerPrice = new JTextField();
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jTextFieldEmbeddedEnergy = new JTextField();
        this.jLabel7 = new JLabel();
        this.jTextFieldEfficiency = new JTextField();
        this.jLabel8 = new JLabel();
        this.jTextFieldPower = new JTextField();
        this.jCheckBox1 = new JCheckBox();
        this.jPanel1.setBackground(new Color(255, 255, 255));
        this.jPanel1.setBorder(BorderFactory.createEtchedBorder());
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGap(160, 160, 160).addComponent(this.jLabelFigure, -1, 135, Short.MAX_VALUE).addGap(50, 50, 50)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGap(84, 84, 84).addComponent(this.jLabelFigure, -1, 129, Short.MAX_VALUE).addGap(37, 37, 37)));
        AutoBinding binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${dataCenterComponent.mttr}"), (Object)this.jTextField2, (Property)BeanProperty.create((String)"text_ON_FOCUS_LOST"));
        this.bindingGroup.addBinding((Binding)binding);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${dataCenterComponent.mttf}"), (Object)this.jTextField3, (Property)BeanProperty.create((String)"text_ON_FOCUS_LOST"));
        this.bindingGroup.addBinding((Binding)binding);
        this.jLabel3.setText("MTTF:");
        this.jLabel2.setText("MTTR:");
        this.jButton1.setText("Browse");
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JPanelEditComponent.this.jButton1ActionPerformed(evt);
            }
        });
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${dataCenterComponent.type}"), (Object)this.jTextField4, (Property)BeanProperty.create((String)"text_ON_FOCUS_LOST"));
        this.bindingGroup.addBinding((Binding)binding);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${dataCenterComponent.path}"), (Object)this.jTextField1, (Property)BeanProperty.create((String)"text_ON_FOCUS_LOST"));
        this.bindingGroup.addBinding((Binding)binding);
        this.jLabel1.setText("Picture:");
        this.jLabel4.setText("Type:");
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addComponent(this.jLabel4)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jTextField1, -1, 201, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton1)).addComponent(this.jTextField4, -1, 274, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2).addComponent(this.jLabel3)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextField3, -1, 273, Short.MAX_VALUE).addComponent(this.jTextField2, -1, 273, Short.MAX_VALUE)).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.jTextField2, -2, -1, -2)).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextField4, -2, -1, -2).addComponent(this.jLabel4)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextField1, -2, -1, -2).addComponent(this.jButton1).addComponent(this.jTextField3, -2, -1, -2).addComponent(this.jLabel3)).addComponent(this.jLabel1)))).addGap(40, 40, 40)));
        this.jPanel3.setBorder(BorderFactory.createTitledBorder("Sustainability Parameters"));
        this.jLabel5.setText("Market Price:");
        this.jLabel6.setText("Embedded Energy (GJ):");
        this.jLabel7.setText("Efficiency (%):");
        this.jLabel8.setText("Max. Power (kW):");
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel7).addComponent(this.jLabel8).addComponent(this.jLabel6).addComponent(this.jLabel5)).addGap(18, 18, 18).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextFieldProducerPrice, -1, 99, Short.MAX_VALUE).addComponent(this.jTextFieldEmbeddedEnergy, GroupLayout.Alignment.TRAILING, -1, 99, Short.MAX_VALUE).addComponent(this.jTextFieldEfficiency, -1, 99, Short.MAX_VALUE).addComponent(this.jTextFieldPower, -1, 99, Short.MAX_VALUE)).addContainerGap()));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel8).addComponent(this.jTextFieldPower, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel7).addComponent(this.jTextFieldEfficiency, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel6).addComponent(this.jTextFieldEmbeddedEnergy, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.jTextFieldProducerPrice, -2, -1, -2)).addContainerGap(44, Short.MAX_VALUE)));
        this.jCheckBox1.setText("Is working?");
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${dataCenterComponent.working}"), (Object)this.jCheckBox1, (Property)BeanProperty.create((String)"selected"));
        this.bindingGroup.addBinding((Binding)binding);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jPanel2, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jPanel1, -2, -1, -2).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBox1).addComponent(this.jPanel3, -2, -1, -2)))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel2, -2, 78, -2).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -2, -1, -2).addGroup(layout.createSequentialGroup().addComponent(this.jPanel3, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jCheckBox1))).addContainerGap(-1, Short.MAX_VALUE)));
        this.bindingGroup.bind();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        JFileChooser fc = new JFileChooser(System.getProperty("user.dir"));
        fc.setFileSelectionMode(0);
        fc.setDialogTitle("Choose Photo");
        FileFilter fileFilter = new FileFilter(){

            public boolean accept(File f) {
                if (f == null) {
                    return false;
                }
                if (f.getName() == null) {
                    return false;
                }
                if (f.getName().endsWith(".jpg")) {
                    return true;
                }
                return f.isDirectory();
            }

            public String getDescription() {
                return "jpg files (.jpg)";
            }
        };
        fc.setFileFilter(fileFilter);
        fc.showOpenDialog(this);
        try {
            if (fc.getSelectedFile() == null) {
                return;
            }
            this.jTextField1.setText(fc.getSelectedFile().getPath());
            BufferedImage imagem = ImageIO.read(fc.getSelectedFile());
            ReplicateScaleFilter replicate = new ReplicateScaleFilter(220, 220);
            FilteredImageSource prod = new FilteredImageSource(imagem.getSource(), replicate);
            this.image = new ImageIcon(this.createImage(prod));
            this.jLabelFigure.setIcon(this.image);
            replicate = new ReplicateScaleFilter(70, 70);
            prod = new FilteredImageSource(imagem.getSource(), replicate);
            this.image = new ImageIcon(this.createImage(prod));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

