/*
 * Decompiled with CFR 0.152.
 */
package com.hp.desdac.powerstructure.entities;

import com.hp.desdac.powerstructure.entities.DataCenterComponent;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PowerComponentSet {
    private ArrayList<DataCenterComponent> components;
    private String fileName;

    public PowerComponentSet(String fileName) {
        this.fileName = fileName;
        Object result = null;
        XStream xs = new XStream((HierarchicalStreamDriver)new DomDriver());
        try {
            FileInputStream fis = new FileInputStream(fileName);
            result = xs.fromXML((InputStream)fis);
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
        }
        this.components = (ArrayList)result;
    }

    public static void createPowerDataCenterComponents() {
        ArrayList<DataCenterComponent> components = new ArrayList<DataCenterComponent>();
        components.add(new DataCenterComponent("UPS", "/gifs/UPS.jpg", 250000.0, 8.0));
        components.add(new DataCenterComponent("SDTransformer", "/gifs/Transformer.jpg", 1412908.33, 156.00624));
        components.add(new DataCenterComponent("CircuitBreaker", "/gifs/Circuitbreaker.jpg", 2502878.31, 2.199978));
        components.add(new DataCenterComponent("Termination", "/gifs/Termination.jpg", 6.8975031E7, 3.7999696));
        components.add(new DataCenterComponent("StaticTransferSwitch", "/gifs/sts.png", 240384.615, 5.99880024));
        components.add(new DataCenterComponent("Battery", "/gifs/Battery.png", 0.0, 0.0));
        components.add(new DataCenterComponent("Capacitor", "/gifs/Capacitor.png", 0.0, 0.0));
        components.add(new DataCenterComponent("Chassis Ground", "/gifs/Chassis Ground.png", 0.0, 0.0));
        components.add(new DataCenterComponent("Circuit Breaker", "/gifs/Circuit Breaker.png", 0.0, 0.0));
        components.add(new DataCenterComponent("Coaxial Cable", "/gifs/Coaxial Cable.png", 0.0, 0.0));
        components.add(new DataCenterComponent("Connector", "/gifs/Connector.png", 0.0, 0.0));
        components.add(new DataCenterComponent("Diode", "/gifs/Diode.png", 0.0, 0.0));
        components.add(new DataCenterComponent("Fuse", "/gifs/Fuse.png", 0.0, 0.0));
        components.add(new DataCenterComponent("Ground Connection", "/gifs/Ground Connection.png", 0.0, 0.0));
        components.add(new DataCenterComponent("Loudspeaker", "/gifs/Loudspeaker.png", 0.0, 0.0));
        components.add(new DataCenterComponent("NPN Transistor", "/gifs/NPN Transistor.png", 0.0, 0.0));
        components.add(new DataCenterComponent("PNP Transistor", "/gifs/PNP Transistor.png", 0.0, 0.0));
        components.add(new DataCenterComponent("Potentiometer", "/gifs/Potentiometer.png", 0.0, 0.0));
        components.add(new DataCenterComponent("Resistor", "/gifs/Resistor.png", 0.0, 0.0));
        components.add(new DataCenterComponent("Shielded Wire", "/gifs/Shielded Wire.png", 0.0, 0.0));
        components.add(new DataCenterComponent("Tachometer", "/gifs/Tachometer.png", 0.0, 0.0));
        components.add(new DataCenterComponent("Tiepoint", "/gifs/Tiepoint.png", 0.0, 0.0));
        components.add(new DataCenterComponent("Transformer", "/gifs/Shielded Wire.png", 0.0, 0.0));
        components.add(new DataCenterComponent("Triac", "/gifs/Triac.png", 0.0, 0.0));
        components.add(new DataCenterComponent("Zener Diode", "/gifs/Zener Diode.png", 0.0, 0.0));
        components.add(new DataCenterComponent("Component", "/gifs/Component.png", 0.0, 0.0));
        XStream xstream = new XStream();
        try {
            FileOutputStream fs = new FileOutputStream(SingletonLogHolder.powerFileName);
            xstream.toXML(components, (OutputStream)fs);
        }
        catch (FileNotFoundException e1) {
            e1.printStackTrace();
        }
    }

    public static void createCoolingDataCenterComponents() {
        ArrayList<DataCenterComponent> components = new ArrayList<DataCenterComponent>();
        components.add(new DataCenterComponent("Chiller", "/gifs/Component.png", 18000.0, 48.0));
        components.add(new DataCenterComponent("Cooling Tower ", "/gifs/Component.png", 24816.0, 48.0));
        components.add(new DataCenterComponent("CRAC", "/gifs/Component.png", 37059.0, 8.0));
        components.add(new DataCenterComponent("Pump", "/gifs/Component.png", 31000.0, 8.0));
        components.add(new DataCenterComponent("Component", "/gifs/Component.png", 0.0, 0.0));
        XStream xstream = new XStream();
        try {
            FileOutputStream fs = new FileOutputStream(SingletonLogHolder.coolingFileName);
            xstream.toXML(components, (OutputStream)fs);
        }
        catch (FileNotFoundException e1) {
            e1.printStackTrace();
        }
    }

    public static PowerComponentSet getInstancePowerDataCenter() {
        return SingletonLogHolder.instancePower;
    }

    public static PowerComponentSet getInstanceCoolingDataCenter() {
        return SingletonLogHolder.instanceCooling;
    }

    public DataCenterComponent getComponent(String name) {
        for (DataCenterComponent dataCenterComponent : this.components) {
            if (!dataCenterComponent.getType().equals(name)) continue;
            return dataCenterComponent;
        }
        return null;
    }

    public ArrayList<DataCenterComponent> getDataCenterComponents() {
        return this.components;
    }

    public static class SingletonLogHolder {
        private static String powerFileName = "PowerComponents.xml";
        private static String coolingFileName = "CoolingComponents.xml";
        private static PowerComponentSet instancePower = new PowerComponentSet(powerFileName);
        private static PowerComponentSet instanceCooling = new PowerComponentSet(coolingFileName);
    }
}

