/*
 * Decompiled with CFR 0.152.
 */
package br.ufpe.cin.emergo.views;

import br.ufpe.cin.emergo.handlers.SelectLinesHandler;
import br.ufpe.cin.emergo.views.LineOfCode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.part.ViewPart;

public class MarkedLinesView
extends ViewPart {
    public static final String ID = "br.ufpe.cin.emergo.views.MarkedLinesView";
    private TreeViewer viewer;
    private List<LineOfCode> baseLines;
    Action deleteItemAction;
    Action deleteAllAction;

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        this.viewer = new TreeViewer(parent, 65536);
        if (this.baseLines == null) {
            this.baseLines = new ArrayList<LineOfCode>();
        }
        this.viewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public boolean hasChildren(Object element) {
                return false;
            }

            public Object getParent(Object element) {
                return null;
            }

            public Object[] getElements(Object inputElement) {
                return ((ArrayList)inputElement).toArray();
            }

            public Object[] getChildren(Object parentElement) {
                return null;
            }
        });
        this.createActions();
        this.createContextMenu();
    }

    private void createContextMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                this.fillContextMenu(mgr);
            }

            private void fillContextMenu(IMenuManager mgr) {
                mgr.add((IAction)MarkedLinesView.this.deleteItemAction);
                mgr.add((IContributionItem)new Separator());
                mgr.add((IAction)MarkedLinesView.this.deleteAllAction);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    public void createActions() {
        this.deleteItemAction = new Action("Delete"){

            public void run() {
                ISelection selection = MarkedLinesView.this.viewer.getSelection();
                String auxSelectionText = selection.toString().substring(1);
                auxSelectionText = auxSelectionText.substring(0, auxSelectionText.length() - 1);
                String[] strings = auxSelectionText.split(";");
                String lineText = "";
                boolean begin = false;
                int j = 0;
                while (j < strings[0].length()) {
                    if (begin) {
                        lineText = String.valueOf(lineText) + strings[0].charAt(j);
                    }
                    if (strings[0].charAt(j) == '(') {
                        begin = true;
                    }
                    ++j;
                }
                lineText = String.valueOf(lineText) + ";";
                SelectLinesHandler.deleteMarkers(auxSelectionText);
                Object[] baseLinesClone = MarkedLinesView.this.baseLines.toArray();
                int i = 0;
                while (i < baseLinesClone.length) {
                    if (((LineOfCode)((Object)baseLinesClone[i])).getSelection().trim().equals(lineText)) {
                        MarkedLinesView.this.baseLines.remove(i);
                    }
                    ++i;
                }
                MarkedLinesView.this.update(new ArrayList<LineOfCode>());
            }
        };
        this.deleteAllAction = new Action("Delete All"){

            public void run() {
                MarkedLinesView.this.baseLines = new ArrayList();
                MarkedLinesView.this.update(new ArrayList<LineOfCode>());
                SelectLinesHandler.deleteAllMarkers();
            }
        };
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                System.out.println("UPDATE ACTION ELEMENT!!");
            }
        });
    }

    public void setFocus() {
    }

    public void update(List<LineOfCode> linesToInser) {
        for (LineOfCode lineOfCode : linesToInser) {
            boolean insert = true;
            for (LineOfCode baseLine : this.baseLines) {
                if (!lineOfCode.equals(baseLine)) continue;
                insert = false;
            }
            if (!insert) continue;
            this.baseLines.add(lineOfCode);
        }
        Collections.sort(this.baseLines, new LineComparator());
        this.viewer.setInput(this.baseLines);
        this.viewer.refresh();
    }

    private class LineComparator
    implements Comparator<LineOfCode> {
        private LineComparator() {
        }

        @Override
        public int compare(LineOfCode arg0, LineOfCode arg1) {
            return arg0.getLine() - arg1.getLine();
        }
    }
}

