/*
 * Decompiled with CFR 0.152.
 */
package br.ufpe.cin.emergo.views;

import br.ufpe.cin.emergo.core.ConfigSet;
import br.ufpe.cin.emergo.graph.DependencyNode;
import br.ufpe.cin.emergo.graph.ValueContainerEdge;
import br.ufpe.cin.emergo.markers.EmergoMarker;
import br.ufpe.cin.emergo.markers.FeatureDependency;
import br.ufpe.cin.emergo.util.ResourceUtil;
import br.ufpe.cin.emergo.views.MarkerGrouping;
import br.ufpe.cin.emergo.views.TreeContentProvider;
import br.ufpe.cin.emergo.views.TreeLabelProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.views.markers.MarkerField;
import org.jgrapht.DirectedGraph;
import org.jgrapht.GraphPath;
import org.jgrapht.alg.KShortestPaths;

public class EmergoView
extends ViewPart {
    public static final String ID = "br.ufpe.cin.emergo.views.EmergoView";
    private TreeViewer viewer;
    private static final int MAX_PATHS = 16;
    private List<IMarker> markerList;
    public static final String EMERGO_MARKER_ID = "Emergo.emergomarker";
    private static final String MARKER_FIELD = "MARKER_FIELD";
    TreeViewerColumn tc;
    TreeViewerColumn tc2;
    TreeViewerColumn tc3;
    TreeViewerColumn tc4;
    TreeViewerColumn tc5;
    private static String textColumnOne = "Description";
    private static String textColumnTwo = "Configuration";
    private static String textColumnThree = "Location";
    private static String textColumnFour = "Feature";
    private static String textColumnFive = "Resource";
    private static String sortingType = "org.eclipse.core.resources.taskmarker";
    private int auxiliary = 0;
    Action addItemAction;
    Action deleteItemAction;
    Action selectAllAction;

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        this.viewer = new TreeViewer(parent, 65536);
        this.viewer.getTree().setLinesVisible(true);
        this.viewer.setSelection((ISelection)new TreeSelection());
        this.viewer.getTree().addListener(3, new Listener(){

            public void handleEvent(Event event) {
                Object data;
                Point point = new Point(event.x, event.y);
                TreeItem clickedItem = EmergoView.this.viewer.getTree().getItem(point);
                if (clickedItem != null && event.button == 1 && event.count == 2 && (data = clickedItem.getData()) instanceof IMarker) {
                    IMarker marker = (IMarker)data;
                    try {
                        IDE.openEditor((IWorkbenchPage)EmergoView.this.getSite().getPage(), (IMarker)marker);
                    }
                    catch (PartInitException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
        TableLayout layout = new TableLayout();
        this.tc = new TreeViewerColumn(this.viewer, 65536);
        this.tc.getColumn().addSelectionListener(this.getHeaderListener());
        this.tc2 = new TreeViewerColumn(this.viewer, 0);
        this.tc2.getColumn().addSelectionListener(this.getHeaderListener());
        this.tc3 = new TreeViewerColumn(this.viewer, 0);
        this.tc3.getColumn().addSelectionListener(this.getHeaderListener());
        this.tc4 = new TreeViewerColumn(this.viewer, 0);
        this.tc4.getColumn().addSelectionListener(this.getHeaderListener());
        this.tc5 = new TreeViewerColumn(this.viewer, 0);
        this.tc5.getColumn().addSelectionListener(this.getHeaderListener());
        this.tc.getColumn().setText(textColumnOne);
        this.tc2.getColumn().setText(textColumnTwo);
        this.tc3.getColumn().setText(textColumnThree);
        this.tc4.getColumn().setText(textColumnFour);
        this.tc5.getColumn().setText(textColumnFive);
        this.tc.getColumn().setToolTipText("Tooltip one");
        this.tc2.getColumn().setToolTipText("Tooltip two");
        this.tc3.getColumn().setToolTipText("Tooltip three");
        this.tc4.getColumn().setToolTipText("Tooltip four");
        this.tc4.getColumn().setToolTipText("Tooltip five");
        Tree tree = this.viewer.getTree();
        tree.setLinesVisible(true);
        tree.setHeaderVisible(true);
        tree.layout(true);
        layout.addColumnData((ColumnLayoutData)new ColumnPixelData(100, true));
        layout.addColumnData((ColumnLayoutData)new ColumnPixelData(100, true));
        layout.addColumnData((ColumnLayoutData)new ColumnPixelData(100, true));
        layout.addColumnData((ColumnLayoutData)new ColumnPixelData(100, true));
        layout.addColumnData((ColumnLayoutData)new ColumnPixelData(100, true));
        this.viewer.setLabelProvider((IBaseLabelProvider)new TreeLabelProvider());
        this.viewer.getTree().setLayout((Layout)layout);
        this.createContextMenu();
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
    }

    private void createContextMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.createAction();
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    public void setFocus() {
    }

    public void updateTree() {
        try {
            IMarker[] markers = ResourcesPlugin.getWorkspace().getRoot().findMarkers(EMERGO_MARKER_ID, false, 2);
            this.markerList = new ArrayList<IMarker>();
            List<MarkerGrouping> goupins = this.generateMarkerList(markers);
            this.viewer.refresh();
            this.viewer.setContentProvider((IContentProvider)new TreeContentProvider());
            this.viewer.setInput(goupins);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    private List<MarkerGrouping> generateMarkerList(IMarker[] markers) throws CoreException {
        ArrayList<MarkerGrouping> goupins = new ArrayList<MarkerGrouping>();
        String markerType = sortingType;
        int i = 0;
        while (i < markers.length) {
            boolean wasAdded = false;
            int j = 0;
            while (j < goupins.size()) {
                if (markers[i].getAttribute(markerType).toString().equals(((MarkerGrouping)goupins.get(j)).getName())) {
                    ((MarkerGrouping)goupins.get(j)).addChildren(markers[i]);
                    wasAdded = true;
                }
                ++j;
            }
            if (!wasAdded) {
                MarkerGrouping mkg = new MarkerGrouping(markers[i].getAttribute(markerType).toString());
                mkg.addChildren(markers[i]);
                goupins.add(mkg);
            }
            this.markerList.add(markers[i]);
            ++i;
        }
        Collections.sort(goupins, new MarkerGroupingComparable());
        return goupins;
    }

    public void clearView() throws CoreException {
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        workspaceRoot.deleteMarkers(EMERGO_MARKER_ID, true, 2);
    }

    public void adaptTo(DirectedGraph<DependencyNode, ValueContainerEdge<ConfigSet>> dependencyGraph, boolean delete) {
        if (delete) {
            try {
                this.clearView();
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        if (dependencyGraph.vertexSet().size() < 2) {
            return;
        }
        HashSet<FeatureDependency> featureDependencySet = new HashSet<FeatureDependency>();
        Set vertexSet = dependencyGraph.vertexSet();
        for (DependencyNode srcNode : vertexSet) {
            if (!srcNode.isInSelection()) continue;
            KShortestPaths shortestPaths = new KShortestPaths(dependencyGraph, (Object)srcNode, 16);
            Set vertexSet2 = dependencyGraph.vertexSet();
            for (DependencyNode tgtNode : vertexSet2) {
                List paths;
                if (tgtNode == srcNode || (paths = shortestPaths.getPaths((Object)tgtNode)) == null) continue;
                for (GraphPath path : paths) {
                    IMarker createdMarker;
                    ConfigSet configAccumulator = null;
                    List edgeList = path.getEdgeList();
                    for (ValueContainerEdge edge : edgeList) {
                        ConfigSet value = (ConfigSet)edge.getValue();
                        configAccumulator = configAccumulator == null ? value : configAccumulator.and(value);
                    }
                    int startLine = srcNode.getPosition().getStartLine() - 1;
                    String message = null;
                    try {
                        IDocument document = this.getDocument(srcNode.getPosition().getFilePath());
                        message = document.get(document.getLineOffset(startLine), document.getLineLength(startLine)).toString().trim();
                        message = document.get(document.getLineOffset(startLine), document.getLineLength(startLine)).toString().trim();
                    }
                    catch (BadLocationException e) {
                        e.printStackTrace();
                        message = "Unknown";
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                        message = "Unknown";
                    }
                    FeatureDependency auxFeature = new FeatureDependency().setConfiguration(configAccumulator).setFile(ResourceUtil.getIFile(tgtNode.getPosition().getFilePath())).setFeature(tgtNode.getConfigSet().toString()).setLineNumber(tgtNode.getPosition().getStartLine()).setMessage(message);
                    if (!featureDependencySet.add(auxFeature) || (createdMarker = EmergoMarker.createMarker(auxFeature)) != null) continue;
                    featureDependencySet.remove(auxFeature);
                }
            }
        }
        this.updateTree();
    }

    private IDocument getDocument(String filename) throws CoreException {
        IFile file = ResourceUtil.getIFile(filename);
        ITextFileBufferManager.DEFAULT.connect(file.getFullPath(), LocationKind.IFILE, null);
        return FileBuffers.getTextFileBufferManager().getTextFileBuffer(file.getFullPath(), LocationKind.IFILE).getDocument();
    }

    private SelectionListener getHeaderListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TreeColumn column = (TreeColumn)e.widget;
                MarkerField field = (MarkerField)column.getData(EmergoView.MARKER_FIELD);
                EmergoView.this.setPrimarySortField(field, column);
            }
        };
    }

    private void setPrimarySortField(MarkerField field, TreeColumn column) {
        Comparator<IMarker> comparable = null;
        if (column.getText().equals(textColumnOne)) {
            comparable = new MarkerMessageComparable();
        } else if (column.getText().equals(textColumnTwo)) {
            comparable = new MarkerLineComparable();
        }
        if (column.getText().equals(textColumnThree)) {
            comparable = new MarkerTextComparable();
        }
        if (column.getText().equals(textColumnFour)) {
            comparable = new MarkerTextComparable();
        }
        if (this.auxiliary == 0) {
            Collections.sort(this.markerList, comparable);
        } else {
            Collections.sort(this.markerList, comparable);
            Collections.reverse(this.markerList);
        }
        this.updateDirectionIndicator(column, field);
        this.reOriginateTree();
    }

    private void reOriginateTree() {
        IMarker[] markers = new IMarker[this.markerList.size()];
        markers = this.markerList.toArray(markers);
        List<MarkerGrouping> goupins = null;
        try {
            this.markerList = new ArrayList<IMarker>();
            goupins = this.generateMarkerList(markers);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        Object[] expanded = this.viewer.getExpandedElements();
        TreePath[] paths = this.viewer.getExpandedTreePaths();
        this.viewer.setInput(goupins);
        this.viewer.setExpandedElements(expanded);
        this.viewer.setExpandedTreePaths(paths);
    }

    void updateDirectionIndicator(TreeColumn column, MarkerField field) {
        this.viewer.getTree().setSortColumn(column);
        if (this.auxiliary == 0) {
            this.viewer.getTree().setSortDirection(128);
            this.auxiliary = 1;
        } else {
            this.viewer.getTree().setSortDirection(1024);
            this.auxiliary = 0;
        }
    }

    public void createAction() {
        this.getViewSite().getActionBars().getMenuManager().add((IAction)this.getSortAction(0));
        this.getViewSite().getActionBars().getMenuManager().add((IAction)this.getSortAction(1));
        this.getViewSite().getActionBars().getMenuManager().add((IAction)this.getSortAction(2));
        this.getViewSite().getActionBars().getMenuManager().add((IContributionItem)new Separator());
    }

    public Action getSortAction(int type) {
        Action sortAction = null;
        switch (type) {
            case 0: {
                sortAction = new Action(){

                    public void run() {
                        sortingType = "message";
                        EmergoView.this.reOriginateTree();
                    }
                };
                sortAction.setText("Group by Description");
                break;
            }
            case 1: {
                sortAction = new Action(){

                    public void run() {
                        sortingType = "org.eclipse.core.resources.textmarker";
                        EmergoView.this.reOriginateTree();
                    }
                };
                sortAction.setText("Group by Configuration");
                break;
            }
            case 2: {
                sortAction = new Action(){

                    public void run() {
                        sortingType = "org.eclipse.core.resources.taskmarker";
                        EmergoView.this.reOriginateTree();
                    }
                };
                sortAction.setText("Group by Feature");
            }
        }
        return sortAction;
    }

    private class MarkerGroupingComparable
    implements Comparator<MarkerGrouping> {
        private MarkerGroupingComparable() {
        }

        @Override
        public int compare(MarkerGrouping arg0, MarkerGrouping arg1) {
            return arg0.getName().compareTo(arg1.getName());
        }
    }

    private class MarkerLineComparable
    implements Comparator<IMarker> {
        private MarkerLineComparable() {
        }

        @Override
        public int compare(IMarker arg0, IMarker arg1) {
            try {
                int line0 = Integer.valueOf(arg0.getAttribute("lineNumber").toString());
                int line1 = Integer.valueOf(arg1.getAttribute("lineNumber").toString());
                return line0 - line1;
            }
            catch (CoreException e) {
                e.printStackTrace();
                return 0;
            }
        }
    }

    private class MarkerMessageComparable
    implements Comparator<IMarker> {
        private MarkerMessageComparable() {
        }

        @Override
        public int compare(IMarker arg0, IMarker arg1) {
            try {
                String line0 = arg0.getAttribute("message").toString();
                String line1 = arg1.getAttribute("message").toString();
                return line0.compareTo(line1);
            }
            catch (CoreException e) {
                e.printStackTrace();
                return 0;
            }
        }
    }

    private class MarkerTextComparable
    implements Comparator<IMarker> {
        private MarkerTextComparable() {
        }

        @Override
        public int compare(IMarker arg0, IMarker arg1) {
            try {
                String line0 = arg0.getAttribute("org.eclipse.core.resources.textmarker").toString();
                String line1 = arg1.getAttribute("org.eclipse.core.resources.textmarker").toString();
                return line0.compareTo(line1);
            }
            catch (CoreException e) {
                e.printStackTrace();
                return 0;
            }
        }
    }
}

