/*
 * Decompiled with CFR 0.152.
 */
package br.ufpe.cin.emergo.views;

import br.ufpe.cin.emergo.core.ConfigSet;
import br.ufpe.cin.emergo.core.SelectionPosition;
import br.ufpe.cin.emergo.graph.DependencyNode;
import br.ufpe.cin.emergo.graph.ValueContainerEdge;
import br.ufpe.cin.emergo.markers.EmergoMarker;
import br.ufpe.cin.emergo.markers.FeatureDependency;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.views.markers.MarkerSupportView;
import org.jgrapht.DirectedGraph;
import org.jgrapht.GraphPath;
import org.jgrapht.alg.KShortestPaths;

public class EmergoResultsView
extends MarkerSupportView {
    public static final String ID = "br.ufpe.cin.emergo.view.EmergoResultsView";
    private static final int MAX_PATHS = 16;
    private static List<IFile> selectedFiles = new ArrayList<IFile>();

    public EmergoResultsView() {
        super("emergoResultsSupport");
    }

    public static void adaptTo(DirectedGraph<DependencyNode, ValueContainerEdge<ConfigSet>> dependencyGraph, ITextEditor editor, SelectionPosition spos, IFile textSelectionFile) {
        Iterator<IFile> iterator = selectedFiles.iterator();
        while (iterator.hasNext()) {
            iterator.next();
        }
        selectedFiles.add(textSelectionFile);
        if (dependencyGraph.vertexSet().size() < 2) {
            return;
        }
        Set vertexSet = dependencyGraph.vertexSet();
        IDocument document = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
        for (DependencyNode srcNode : vertexSet) {
            if (!srcNode.isInSelection()) continue;
            KShortestPaths shortestPaths = new KShortestPaths(dependencyGraph, (Object)srcNode, 16);
            Set vertexSet2 = dependencyGraph.vertexSet();
            for (DependencyNode tgtNode : vertexSet2) {
                List paths;
                if (tgtNode == srcNode || (paths = shortestPaths.getPaths((Object)tgtNode)) == null) continue;
                for (GraphPath path : paths) {
                    ConfigSet configAccumulator = null;
                    List edgeList = path.getEdgeList();
                    for (ValueContainerEdge edge : edgeList) {
                        ConfigSet value = (ConfigSet)edge.getValue();
                        configAccumulator = configAccumulator == null ? value : configAccumulator.and(value);
                    }
                    int startLine = srcNode.getPosition().getStartLine() - 1;
                    String message = null;
                    try {
                        message = document.get(document.getLineOffset(startLine), document.getLineLength(startLine)).toString().trim();
                    }
                    catch (BadLocationException badLocationException) {
                        message = "Unknown";
                    }
                    FeatureDependency auxFeature = new FeatureDependency().setConfiguration(configAccumulator).setFile(textSelectionFile).setFeature(tgtNode.getConfigSet().toString()).setLineNumber(tgtNode.getPosition().getStartLine()).setMessage(message);
                    EmergoMarker.createMarker(auxFeature);
                }
            }
        }
    }
}

