/*
 * Decompiled with CFR 0.152.
 */
package br.ufpe.cin.emergo.views;

import br.ufpe.cin.emergo.core.ConfigSet;
import br.ufpe.cin.emergo.graph.DependencyNode;
import br.ufpe.cin.emergo.graph.DependencyNodeWrapper;
import br.ufpe.cin.emergo.graph.ValueContainerEdge;
import br.ufpe.cin.emergo.util.ResourceUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.zest.core.widgets.Graph;
import org.eclipse.zest.core.widgets.GraphConnection;
import org.eclipse.zest.core.widgets.GraphNode;
import org.eclipse.zest.core.widgets.IContainer;
import org.eclipse.zest.layouts.LayoutAlgorithm;
import org.eclipse.zest.layouts.algorithms.RadialLayoutAlgorithm;
import org.jgrapht.DirectedGraph;

public class EmergoGraphView
extends ViewPart {
    public static final String ID = "br.ufpe.cin.emergo.view.GraphView";
    private Graph graph;
    private Composite parent;

    public void createPartControl(Composite parent) {
        this.parent = parent;
        this.graph = new Graph(parent, 0);
        this.graph.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Object selectionObj;
                Graph source = (Graph)event.getSource();
                List selection = source.getSelection();
                if (!selection.isEmpty() && (selectionObj = selection.get(0)) instanceof GraphNode) {
                    GraphNode selectedNode = (GraphNode)selectionObj;
                    DependencyNodeWrapper nodeWrapper = (DependencyNodeWrapper)selectedNode.getData();
                    IFile file = ResourceUtil.getIFile(nodeWrapper.getPosition().getFilePath());
                    IWorkbenchPage page = EmergoGraphView.this.getSite().getPage();
                    try {
                        IMarker marker = file.createMarker("org.eclipse.core.resources.textmarker");
                        marker.setAttribute("lineNumber", nodeWrapper.getPosition().getStartLine());
                        IDE.openEditor((IWorkbenchPage)page, (IMarker)marker);
                        marker.delete();
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
    }

    private IDocument getDocument(String filename) throws CoreException {
        IFile file = ResourceUtil.getIFile(filename);
        ITextFileBufferManager.DEFAULT.connect(file.getFullPath(), LocationKind.IFILE, null);
        return FileBuffers.getTextFileBufferManager().getTextFileBuffer(file.getFullPath(), LocationKind.IFILE).getDocument();
    }

    public void adaptTo(DirectedGraph<DependencyNode, ValueContainerEdge<ConfigSet>> dependencyGraph) {
        this.clearGraph();
        Display display = this.parent.getDisplay();
        this.graph.setLayoutAlgorithm((LayoutAlgorithm)new RadialLayoutAlgorithm(1), true);
        HashMap<DependencyNode, GraphNode> objectNodeMapping = new HashMap<DependencyNode, GraphNode>();
        Set edgeSet = dependencyGraph.edgeSet();
        for (ValueContainerEdge valueContainerEdge : edgeSet) {
            IDocument document;
            String nodeLabel;
            int startLine;
            DependencyNode edgeSrc = (DependencyNode)dependencyGraph.getEdgeSource((Object)valueContainerEdge);
            DependencyNode edgeTgt = (DependencyNode)dependencyGraph.getEdgeTarget((Object)valueContainerEdge);
            GraphNode src = (GraphNode)objectNodeMapping.get(edgeSrc);
            GraphNode tgt = (GraphNode)objectNodeMapping.get(edgeTgt);
            if (edgeSrc.equals(edgeTgt)) continue;
            if (src == null) {
                startLine = edgeSrc.getPosition().getStartLine() - 1;
                nodeLabel = null;
                try {
                    document = this.getDocument(edgeSrc.getPosition().getFilePath());
                    nodeLabel = document.get(document.getLineOffset(startLine), document.getLineLength(startLine)).toString().trim();
                }
                catch (BadLocationException e) {
                    e.printStackTrace();
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
                if (nodeLabel == null) {
                    nodeLabel = "" + startLine;
                }
                src = new GraphNode((IContainer)this.graph, 0, nodeLabel, (Object)edgeSrc);
                objectNodeMapping.put(edgeSrc, src);
                if (edgeSrc.isInSelection()) {
                    src.setBorderWidth(2);
                    src.setBackgroundColor(display.getSystemColor(29));
                }
            }
            if (tgt == null) {
                startLine = edgeTgt.getPosition().getStartLine() - 1;
                nodeLabel = null;
                try {
                    document = this.getDocument(edgeTgt.getPosition().getFilePath());
                    nodeLabel = document.get(document.getLineOffset(startLine), document.getLineLength(startLine)).toString().trim();
                }
                catch (BadLocationException e) {
                    e.printStackTrace();
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
                if (nodeLabel == null) {
                    nodeLabel = "" + startLine;
                }
                tgt = new GraphNode((IContainer)this.graph, 0, nodeLabel, (Object)edgeTgt);
                objectNodeMapping.put(edgeTgt, tgt);
                if (edgeTgt.isInSelection()) {
                    tgt.setBorderWidth(2);
                    tgt.setBackgroundColor(display.getSystemColor(29));
                }
            }
            GraphConnection graphConnection = new GraphConnection(this.graph, 2, src, tgt);
            graphConnection.setFont(new Font((Device)display, new FontData("Courrier", 8, 1)));
            graphConnection.setText(((ConfigSet)valueContainerEdge.getValue()).toString());
        }
    }

    private void clearGraph() {
        assert (this.graph != null);
        Object[] objects = this.graph.getConnections().toArray();
        int x = 0;
        while (x < objects.length) {
            ((GraphConnection)objects[x]).dispose();
            ++x;
        }
        objects = this.graph.getNodes().toArray();
        x = 0;
        while (x < objects.length) {
            ((GraphNode)objects[x]).dispose();
            ++x;
        }
    }

    public void setFocus() {
    }
}

