/*
 * Decompiled with CFR 0.152.
 */
package br.ufpe.cin.emergo.util;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import org.jgrapht.DirectedGraph;
import org.jgrapht.Graph;
import org.jgrapht.ext.DOTExporter;
import org.jgrapht.ext.EdgeNameProvider;
import org.jgrapht.ext.StringNameProvider;
import org.jgrapht.ext.VertexNameProvider;

public class DebugUtil {
    private static String EMERGO_DIR = ".emergo";

    private DebugUtil() {
    }

    public static File writeStringToFile(String str, String fileName) {
        return DebugUtil.writeStringToFile(str, new File(String.valueOf(System.getProperty("user.home")) + File.separator + EMERGO_DIR + File.separator + fileName));
    }

    public static File writeStringToFile(String str, File file) {
        if (str == null) {
            throw new IllegalArgumentException("String cannot be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("File cannot be null");
        }
        file.getParentFile().mkdirs();
        try {
            FileWriter writer = new FileWriter(file);
            writer.write(str);
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return file;
    }

    public static File exportToDotFile(DirectedGraph graph, String fileName) {
        if (graph == null) {
            throw new IllegalArgumentException("The graph cannot be null");
        }
        if (fileName == null) {
            throw new IllegalArgumentException("The file name cannot be null");
        }
        return DebugUtil.exportToDotFile(graph, new File(String.valueOf(System.getProperty("user.home")) + File.separator + EMERGO_DIR + File.separator + fileName));
    }

    public static File exportToDotFile(DirectedGraph graph, File file) {
        file.getParentFile().mkdirs();
        DOTExporter exporter = new DOTExporter((VertexNameProvider)new StringNameProvider<Object>(){

            public String getVertexName(Object vertex) {
                return "\"" + vertex.toString() + "\"";
            }
        }, null, (EdgeNameProvider)new EdgeNameProvider<Object>(){

            public String getEdgeName(Object edge) {
                return edge.toString();
            }
        });
        try {
            FileWriter writer = new FileWriter(file);
            exporter.export((Writer)writer, (Graph)graph);
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return file;
    }
}

