/*
 * Decompiled with CFR 0.152.
 */
package br.ufpe.cin.emergo.properties;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PropertyDialogAction;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.ViewPart;

public class PropertyManagerView
extends ViewPart {
    private TreeViewer viewer;
    private TreeParent invisibleRoot;

    public void initialize() {
        TreeParent root = new TreeParent("WorkSpace Property Files");
        try {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IProject[] projects = workspace.getRoot().getProjects();
            int i = 0;
            while (i < projects.length) {
                IResource[] folderResources = projects[i].members();
                int j = 0;
                while (j < folderResources.length) {
                    IFolder resource;
                    if (folderResources[j] instanceof IFolder && (resource = (IFolder)folderResources[j]).getName().equalsIgnoreCase("Property Files")) {
                        IResource[] fileResources = resource.members();
                        int k = 0;
                        while (k < fileResources.length) {
                            if (fileResources[k] instanceof IFile && fileResources[k].getName().endsWith(".properties")) {
                                TreeObject obj = new TreeObject(fileResources[k].getName());
                                obj.setResouce(fileResources[k]);
                                root.addChild(obj);
                            }
                            ++k;
                        }
                    }
                    ++j;
                }
                ++i;
            }
        }
        catch (Exception e) {
            System.err.println("exception");
            e.printStackTrace();
        }
        this.invisibleRoot = new TreeParent("");
        this.invisibleRoot.addChild(root);
    }

    public void createPartControl(Composite parent) {
        this.viewer = new TreeViewer(parent, 770);
        this.viewer.setContentProvider((IContentProvider)new ViewContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider());
        this.viewer.setInput((Object)this.getViewSite());
        this.hookContextMenu();
        this.hookDoubleCLickAction();
    }

    private void hookDoubleCLickAction() {
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ISelection selection = event.getSelection();
                Object obj = ((IStructuredSelection)selection).getFirstElement();
                if (!(obj instanceof TreeObject)) {
                    return;
                }
                TreeObject tempObj = (TreeObject)obj;
                IFile ifile = ResourcesPlugin.getWorkspace().getRoot().getFile(tempObj.getResouce().getFullPath());
                IWorkbenchPage dpage = PropertyManagerView.this.getViewSite().getWorkbenchWindow().getActivePage();
                if (dpage != null) {
                    try {
                        IDE.openEditor((IWorkbenchPage)dpage, (IFile)ifile, (boolean)true);
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        Action refresh = new Action(){

            public void run() {
                PropertyManagerView.this.initialize();
                PropertyManagerView.this.viewer.refresh();
            }
        };
        refresh.setText("Refresh");
        menuMgr.add((IAction)refresh);
        menuMgr.add((IContributionItem)new Separator());
        menuMgr.add((IAction)new PropertyDialogAction((IShellProvider)this.getSite(), (ISelectionProvider)this.viewer));
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    class TreeObject
    implements IAdaptable {
        private String name;
        private TreeParent parent;
        private IResource resouce;

        public TreeObject(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setParent(TreeParent parent) {
            this.parent = parent;
        }

        public TreeParent getParent() {
            return this.parent;
        }

        public String toString() {
            return this.getName();
        }

        public Object getAdapter(Class key) {
            return null;
        }

        protected IResource getResouce() {
            return this.resouce;
        }

        protected void setResouce(IResource resouce) {
            this.resouce = resouce;
        }
    }

    class TreeParent
    extends TreeObject {
        private ArrayList children;

        public TreeParent(String name) {
            super(name);
            this.children = new ArrayList();
        }

        public void addChild(TreeObject child) {
            this.children.add(child);
            child.setParent(this);
        }

        public void removeChild(TreeObject child) {
            this.children.remove(child);
            child.setParent(null);
        }

        public TreeObject[] getChildren() {
            return this.children.toArray(new TreeObject[this.children.size()]);
        }

        public boolean hasChildren() {
            return this.children.size() > 0;
        }
    }

    class ViewContentProvider
    implements ITreeContentProvider {
        ViewContentProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object parent) {
            if (parent.equals(PropertyManagerView.this.getViewSite())) {
                if (PropertyManagerView.this.invisibleRoot == null) {
                    PropertyManagerView.this.initialize();
                }
                return this.getChildren(PropertyManagerView.this.invisibleRoot);
            }
            return this.getChildren(parent);
        }

        public Object getParent(Object child) {
            if (child instanceof TreeObject) {
                return ((TreeObject)child).getParent();
            }
            return null;
        }

        public Object[] getChildren(Object parent) {
            if (parent instanceof TreeParent) {
                return ((TreeParent)parent).getChildren();
            }
            return new Object[0];
        }

        public boolean hasChildren(Object parent) {
            if (parent instanceof TreeParent) {
                return ((TreeParent)parent).hasChildren();
            }
            return false;
        }
    }

    class ViewLabelProvider
    extends LabelProvider {
        ViewLabelProvider() {
        }

        public String getText(Object obj) {
            return obj.toString();
        }

        public Image getImage(Object obj) {
            String imageKey = "IMG_OBJ_ELEMENTS";
            if (obj instanceof TreeParent) {
                imageKey = "IMG_OBJ_FOLDER";
            }
            return PlatformUI.getWorkbench().getSharedImages().getImage(imageKey);
        }
    }
}

