/*
 * Decompiled with CFR 0.152.
 */
package br.ufpe.cin.emergo.listeners;

import br.ufpe.cin.emergo.core.DependencyFinder;
import br.ufpe.cin.emergo.core.EmergoException;
import br.ufpe.cin.emergo.core.JWCompilerDependencyFinder;
import br.ufpe.cin.emergo.core.SelectionPosition;
import br.ufpe.cin.emergo.editor.IfDefJavaEditor;
import br.ufpe.cin.emergo.properties.SystemProperties;
import br.ufpe.cin.emergo.util.EmergoConstants;
import dk.au.cs.java.compiler.Flags;
import dk.au.cs.java.compiler.Main;
import dk.au.cs.java.compiler.ifdef.IfDefUtil;
import dk.au.cs.java.compiler.ifdef.IfDefVarSet;
import dk.au.cs.java.compiler.ifdef.SharedSimultaneousAnalysis;
import dk.au.cs.java.compiler.node.AProgram;
import dk.au.cs.java.compiler.node.PIfdefExp;
import dk.au.cs.java.compiler.type.environment.ClassEnvironment;
import dk.brics.util.file.WildcardExpander;
import java.io.File;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.Range;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.ITextEditor;

public class Selection
implements ISelectionListener {
    IfDefJavaEditor ifDefJavaEditor;
    ISelection selection;
    IPath location;
    IJavaProject javaProject;
    private static AProgram rootNode;
    ArrayList<String> choosenFeatures;

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        this.selection = selection;
        if (part instanceof IfDefJavaEditor && selection instanceof TextSelection && ((TextSelection)selection).getEndLine() == 0 && ((TextSelection)selection).getStartLine() == 0) {
            IJavaProject javaProject;
            IDocument d = ((IfDefJavaEditor)part).getDocument();
            ITextEditor te = (ITextEditor)part;
            IFile textSelectionFile2 = (IFile)te.getEditorInput().getAdapter(IFile.class);
            textSelectionFile2.getFullPath();
            textSelectionFile2.getRawLocation().toFile();
            this.location = textSelectionFile2.getRawLocation();
            IProject project = textSelectionFile2.getProject();
            this.javaProject = javaProject = JavaCore.create((IProject)project);
            try {
                String allFeatures = javaProject.getResource().getPersistentProperty(SystemProperties.CHOOSEN_FEATURES);
                String[] auxChoosen = allFeatures.split(";");
                this.choosenFeatures = new ArrayList();
                int i = 0;
                while (i < auxChoosen.length) {
                    this.choosenFeatures.add(auxChoosen[i].trim());
                    ++i;
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            try {
                this.auxiliarHidding(textSelectionFile2, part, d, selection);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        }
    }

    private void auxiliarHidding(IFile file, IWorkbenchPart editor, IDocument d, ISelection selection) throws CoreException, BadLocationException {
        Iterator iterator;
        try {
            this.doNeccessaryJob();
        }
        catch (EmergoException e) {
            e.printStackTrace();
        }
        Map<PIfdefExp, Collection<Range<Integer>>> test = DependencyFinder.getIfDefLineMapping(file.getRawLocation().toFile(), rootNode);
        Set<Map.Entry<PIfdefExp, Collection<Range<Integer>>>> testSet = test.entrySet();
        HashMap ifDefLineMapping = new HashMap();
        for (Map.Entry<PIfdefExp, Collection<Range<Integer>>> entry : testSet) {
            Collection<Range<Integer>> collection = entry.getValue();
            iterator = collection.iterator();
            Range range = (Range)iterator.next();
            ArrayList<Integer> aux = new ArrayList<Integer>();
            aux.add((Integer)range.getMinimum());
            aux.add((Integer)range.getMaximum());
            if (this.choosenFeatures.contains(entry.getKey().toString().trim())) continue;
            ifDefLineMapping.put(entry.getKey(), aux);
        }
        Set configSets = ifDefLineMapping.entrySet();
        int lastSourceLineNumber = 0;
        for (Map.Entry entry : configSets) {
            ArrayDeque<Integer> sourceLineNumbers = new ArrayDeque<Integer>((Collection)entry.getValue());
            Integer first = (Integer)sourceLineNumbers.removeFirst();
            lastSourceLineNumber = (Integer)sourceLineNumbers.getLast();
            sourceLineNumbers.addLast(++lastSourceLineNumber);
            sourceLineNumbers.removeFirst();
            sourceLineNumbers.addFirst(first);
            entry.setValue(sourceLineNumbers);
        }
        ConcurrentHashMap<PIfdefExp, Collection<Integer>> concurrentHashMap = new ConcurrentHashMap<PIfdefExp, Collection<Integer>>();
        concurrentHashMap.putAll(ifDefLineMapping);
        iterator = concurrentHashMap.keySet().iterator();
        while (iterator.hasNext()) {
            iterator.next();
        }
        if (concurrentHashMap.size() == 0) {
            System.out.println("no computation");
        }
        List<Position> positions = this.createPositions(d, concurrentHashMap);
        ArrayList<Position> positionsEmpty = new ArrayList<Position>();
        if (editor instanceof IfDefJavaEditor) {
            ((IfDefJavaEditor)editor).expandAllAnnotations(d.getLength());
            ((IfDefJavaEditor)editor).removeAllAnnotations();
            ((IfDefJavaEditor)editor).updateFoldingStructure(positionsEmpty);
            ((IfDefJavaEditor)editor).updateFoldingStructure(positions);
        }
    }

    private List<Position> createPositions(IDocument d, Map<PIfdefExp, Collection<Integer>> featuresLineNumbers) throws BadLocationException {
        ArrayList<Position> positions = new ArrayList<Position>();
        Iterator<Integer> iteratorInteger = null;
        int line = 0;
        int previousLine = 0;
        int length = 0;
        int offset = 0;
        boolean newAnnotation = false;
        boolean first = true;
        Iterator<PIfdefExp> featureNames = featuresLineNumbers.keySet().iterator();
        while (featureNames.hasNext()) {
            line = 0;
            previousLine = 0;
            length = 0;
            offset = 0;
            first = true;
            PIfdefExp featureName = featureNames.next();
            Collection<Integer> lines = featuresLineNumbers.get(featureName);
            if (lines.size() <= 1) continue;
            iteratorInteger = lines.iterator();
            while (iteratorInteger.hasNext()) {
                if (newAnnotation) {
                    try {
                        offset = d.getLineOffset(line);
                        length = d.getLineLength(line);
                    }
                    catch (BadLocationException badLocationException) {
                        length = 0;
                        offset = d.getLineOffset(line);
                    }
                    newAnnotation = false;
                } else {
                    line = iteratorInteger.next() - 1;
                    if (first) {
                        try {
                            offset = d.getLineOffset(line);
                            length = d.getLineLength(line);
                        }
                        catch (BadLocationException badLocationException) {
                            length = 0;
                            offset = d.getLineOffset(line);
                        }
                        first = false;
                    }
                }
                length += d.getLineLength(line);
                if (previousLine > 0 && line > previousLine + 1) {
                    length = 0;
                    int i = previousLine;
                    while (i <= line - 1) {
                        length += d.getLineLength(i);
                        ++i;
                    }
                    previousLine = line;
                    newAnnotation = true;
                    positions.add(new Position(offset, length));
                    break;
                }
                previousLine = line;
            }
            Position p = new Position(offset, length);
            if (positions.contains(p)) continue;
            positions.add(new Position(offset, length));
        }
        return positions;
    }

    private void doNeccessaryJob() throws JavaModelException, EmergoException {
        SelectionPosition selectionPosition = new SelectionPosition(200, 4, 1, 2, 3, 4, this.location.toString());
        Main.resetCompiler();
        File selectionFile = new File(selectionPosition.getFilePath());
        if (!selectionFile.exists()) {
            throw new EmergoException("File " + selectionPosition.getFilePath() + " not found.");
        }
        String rawLocation = this.location.toOSString();
        String rawProjLocation = this.javaProject.getPath().toOSString();
        int i = 0;
        while (i + rawProjLocation.length() < rawLocation.length()) {
            if (rawLocation.subSequence(i, i + rawProjLocation.length()).equals(rawProjLocation)) {
                rawLocation = rawLocation.substring(0, i + rawProjLocation.length());
            }
            ++i;
        }
        String rootpath = rawLocation;
        File ifdefSpecFile = new File(String.valueOf(rootpath) + File.separator + EmergoConstants.FEATURE_MODEL_FILE_NAME);
        if (!ifdefSpecFile.exists()) {
            throw new RuntimeException("The " + EmergoConstants.FEATURE_MODEL_FILE_NAME + " of the project was not found at " + rootpath);
        }
        ArrayList<File> files = new ArrayList<File>();
        IClasspathEntry[] resolvedClasspath = this.javaProject.getResolvedClasspath(true);
        ArrayList<File> classpath = new ArrayList<File>();
        IClasspathEntry[] iClasspathEntryArray = resolvedClasspath;
        int n = resolvedClasspath.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry cpEntry = iClasspathEntryArray[n2];
            switch (cpEntry.getEntryKind()) {
                case 5: {
                    classpath.add(cpEntry.getPath().makeAbsolute().toFile());
                    break;
                }
                case 3: {
                    classpath.add(ResourcesPlugin.getWorkspace().getRoot().getFolder(cpEntry.getPath()).getLocation().toFile());
                }
            }
            ++n2;
        }
        for (File file : classpath) {
            if (file.isDirectory()) {
                String filepath = String.valueOf(file.getPath()) + File.separator + "**" + File.separator + "*.java";
                List expandWildcards = WildcardExpander.expandWildcards((String)filepath);
                files.addAll(expandWildcards);
                continue;
            }
            if (!file.isFile()) continue;
            file.exists();
        }
        ClassEnvironment.init((String)System.getenv("CLASSPATH"), (boolean)true);
        EnumSet flags = Main.FLAGS;
        flags.add(Flags.IFDEF);
        SharedSimultaneousAnalysis.useSharedSetStrategy((boolean)true);
        IfDefUtil.parseIfDefSpecification((File)ifdefSpecFile);
        IfDefVarSet.getIfDefBDDFactory();
        rootNode = JWCompilerDependencyFinder.parseProgram(files);
    }
}

