/*
 * Decompiled with CFR 0.152.
 */
package br.ufpe.cin.emergo.handlers;

import br.ufpe.cin.emergo.core.ConfigSet;
import br.ufpe.cin.emergo.core.DependencyFinder;
import br.ufpe.cin.emergo.core.DependencyFinderID;
import br.ufpe.cin.emergo.core.EmergoException;
import br.ufpe.cin.emergo.core.SelectionPosition;
import br.ufpe.cin.emergo.graph.DependencyNode;
import br.ufpe.cin.emergo.graph.ValueContainerEdge;
import br.ufpe.cin.emergo.handlers.GenerateEmergentInterfaceHandler;
import br.ufpe.cin.emergo.properties.SystemProperties;
import br.ufpe.cin.emergo.util.ResourceUtil;
import br.ufpe.cin.emergo.views.LineOfCode;
import br.ufpe.cin.emergo.views.MarkedLinesView;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.internal.ide.dialogs.InternalErrorDialog;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.jgrapht.DirectedGraph;

public class SelectLinesHandler
extends AbstractHandler {
    public static String chooseID = "br.ufpe.cin.emergo.command.chooseLines";
    public static String generateFromID = "br.ufpe.cin.emergo.command.generateForLines";
    static List<LineOfCode> linesOffset;
    static Map<Object, Object> lineOptions;
    static boolean interprocedural;

    static {
        interprocedural = true;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        return this.emergoHandlerMethod(event);
    }

    private Object emergoHandlerMethod(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelectionChecked((ExecutionEvent)event);
        Shell shell = HandlerUtil.getActiveShellChecked((ExecutionEvent)event);
        try {
            IProject project;
            IJavaProject javaProject;
            if (lineOptions == null) {
                lineOptions = new HashMap<Object, Object>();
            }
            if (linesOffset == null) {
                linesOffset = new ArrayList<LineOfCode>();
            }
            HashMap<Object, Object> options = new HashMap<Object, Object>();
            if (!(selection instanceof ITextSelection)) {
                throw new ExecutionException("Not a textual selection");
            }
            ITextEditor editor = (ITextEditor)HandlerUtil.getActiveEditorChecked((ExecutionEvent)event);
            IFile textSelectionFile = (IFile)editor.getEditorInput().getAdapter(IFile.class);
            IDocumentProvider provider = editor.getDocumentProvider();
            IDocument document = provider.getDocument((Object)editor.getEditorInput());
            ITextSelection textSelection = (ITextSelection)editor.getSite().getSelectionProvider().getSelection();
            if (textSelection.getLength() == -1) {
                new MessageDialog(shell, "Emergo Message", ResourceUtil.getEmergoIcon(), "The selection is invalid.", 4, new String[]{"Ok"}, 0).open();
            }
            interprocedural = (javaProject = JavaCore.create((IProject)(project = textSelectionFile.getProject()))).getResource().getPersistentProperty(SystemProperties.INTERPROCEDURAL_PROPKEY) != null ? javaProject.getResource().getPersistentProperty(SystemProperties.INTERPROCEDURAL_PROPKEY).toString().equals("true") : false;
            options.put("rootpath", javaProject.getResource().getLocation().toFile().getAbsolutePath());
            IClasspathEntry[] resolvedClasspath = javaProject.getResolvedClasspath(true);
            ArrayList<File> classpath = new ArrayList<File>();
            IClasspathEntry[] iClasspathEntryArray = resolvedClasspath;
            int n = resolvedClasspath.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry cpEntry = iClasspathEntryArray[n2];
                switch (cpEntry.getEntryKind()) {
                    case 5: {
                        classpath.add(cpEntry.getPath().makeAbsolute().toFile());
                        break;
                    }
                    case 3: {
                        classpath.add(ResourcesPlugin.getWorkspace().getRoot().getFolder(cpEntry.getPath()).getLocation().toFile());
                        break;
                    }
                    case 1: {
                        IPath ipath = this.makePathAbsolute(cpEntry.getPath());
                        classpath.add(ipath.toFile());
                    }
                }
                ++n2;
            }
            if (event.getCommand().getId().equals(chooseID)) {
                options.put("classpath", classpath);
                lineOptions = options;
                if (linesOffset == null) {
                    linesOffset = new ArrayList<LineOfCode>();
                }
                LineOfCode lineArguments = new LineOfCode(textSelection, textSelectionFile);
                linesOffset.add(lineArguments);
                IViewPart markedLinesView = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getActivePage().findView("br.ufpe.cin.emergo.views.MarkedLinesView");
                ((MarkedLinesView)markedLinesView).update(linesOffset);
            }
            List<DirectedGraph<DependencyNode, ValueContainerEdge<ConfigSet>>> dependencyGraphs = null;
            if (event.getCommand().getId().equals(generateFromID)) {
                dependencyGraphs = SelectLinesHandler.getDependencyGraphs(event, options, editor, document);
                for (DirectedGraph<DependencyNode, ValueContainerEdge<ConfigSet>> dGraph : dependencyGraphs) {
                    if (dGraph != null && dGraph.vertexSet().size() >= 2) continue;
                    new MessageDialog(shell, "Emergo Message", ResourceUtil.getEmergoIcon(), "No dependencies found!", 2, new String[]{"Ok"}, 0).open();
                }
            }
        }
        catch (Throwable e) {
            String message = e.getMessage() == null ? "No message specified" : e.getMessage();
            InternalErrorDialog internalErrorDialog = new InternalErrorDialog(shell, "An error has occurred", ResourceUtil.getEmergoIcon(), message, e, 1, new String[]{"Ok", "Details"}, 0);
            internalErrorDialog.setDetailButton(1);
            internalErrorDialog.open();
            e.printStackTrace();
        }
        return null;
    }

    public static List<DirectedGraph<DependencyNode, ValueContainerEdge<ConfigSet>>> getDependencyGraphs(ExecutionEvent event, Map<Object, Object> options, ITextEditor editor, IDocument document) throws EmergoException {
        ArrayList<DirectedGraph<DependencyNode, ValueContainerEdge<ConfigSet>>> dependencyGraphs = new ArrayList<DirectedGraph<DependencyNode, ValueContainerEdge<ConfigSet>>>();
        int i = 0;
        while (i < linesOffset.size()) {
            ITextSelection textSelection = linesOffset.get(i).getTextSelection();
            String selectionFileString = linesOffset.get(i).getTextSelectionFile().getLocation().toOSString();
            SelectionPosition selectionPosition = SelectionPosition.builder().length(textSelection.getLength()).offSet(textSelection.getOffset()).startLine(textSelection.getStartLine()).startColumn(GenerateEmergentInterfaceHandler.calculateColumnFromOffset(document, textSelection.getOffset())).endLine(textSelection.getEndLine()).endColumn(GenerateEmergentInterfaceHandler.calculateColumnFromOffset(document, textSelection.getOffset() + textSelection.getLength())).filePath(selectionFileString).build();
            DirectedGraph<DependencyNode, ValueContainerEdge<ConfigSet>> dependencyGraph = DependencyFinder.findFromSelection(DependencyFinderID.JWCOMPILER, selectionPosition, lineOptions, interprocedural);
            dependencyGraphs.add(dependencyGraph);
            SelectLinesHandler.updateViews(event, editor, linesOffset.get(i).getTextSelectionFile(), dependencyGraph);
            ++i;
        }
        return dependencyGraphs;
    }

    private static void updateViews(ExecutionEvent event, ITextEditor editor, IFile textSelectionFile, DirectedGraph<DependencyNode, ValueContainerEdge<ConfigSet>> dependencyGraph) {
        HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getActivePage().findView("br.ufpe.cin.emergo.views.EmergoView");
        IViewPart markedLinesView = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getActivePage().findView("br.ufpe.cin.emergo.views.MarkedLinesView");
        ((MarkedLinesView)markedLinesView).update(linesOffset);
    }

    public Map getLines() {
        return this.getLines();
    }

    public static void deleteAllMarkers() {
        lineOptions = new HashMap<Object, Object>();
        linesOffset = new ArrayList<LineOfCode>();
    }

    public static void deleteMarkers(String message) {
        int removePosition = 0;
        boolean found = false;
        int i = 0;
        while (i < linesOffset.size()) {
            if (linesOffset.get(i).toString().trim().equals(message)) {
                removePosition = i;
                found = true;
            }
            ++i;
        }
        if (found) {
            linesOffset.remove(removePosition);
            lineOptions = new HashMap<Object, Object>();
        }
    }

    private IPath makePathAbsolute(IPath path) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource workspaceResource = root.findMember(path);
        if (workspaceResource != null) {
            path = workspaceResource.getRawLocation();
        }
        return path;
    }
}

