/*
 * Decompiled with CFR 0.152.
 */
package br.ufpe.cin.emergo.handlers;

import br.ufpe.cin.emergo.core.ConfigSet;
import br.ufpe.cin.emergo.core.DependencyFinder;
import br.ufpe.cin.emergo.editor.IfDefJavaEditor;
import br.ufpe.cin.emergo.util.ResourceUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.Range;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.views.markers.MarkerItem;

public class HideFeaturesHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getActiveMenuSelection((ExecutionEvent)event);
        Shell shell = HandlerUtil.getActiveShellChecked((ExecutionEvent)event);
        Object marker = ((IStructuredSelection)selection).getFirstElement();
        try {
            if (marker instanceof MarkerItem) {
                IfDefJavaEditor editor = (IfDefJavaEditor)((Object)HandlerUtil.getActiveEditor((ExecutionEvent)event).getAdapter(IfDefJavaEditor.class));
                IDocument d = editor.getDocument();
                IFile file = (IFile)HandlerUtil.getActiveEditorChecked((ExecutionEvent)event).getEditorInput().getAdapter(IFile.class);
                ConfigSet selectedConfigSet = (ConfigSet)((MarkerItem)marker).getMarker().getAttribute("org.eclipse.core.resources.textmarker");
                Map<ConfigSet, Collection<Range<Integer>>> featureRangeLineNumbers = DependencyFinder.getIfDefLineMapping(file.getRawLocation().toFile());
                HashMap ifDefLineMapping = new HashMap();
                Set<Map.Entry<ConfigSet, Collection<Range<Integer>>>> entrySet = featureRangeLineNumbers.entrySet();
                for (Map.Entry<ConfigSet, Collection<Range<Integer>>> entry : entrySet) {
                    Collection<Range<Integer>> rangeCollection = entry.getValue();
                    ArrayList<? extends Integer> lineNumbers = new ArrayList<Integer>();
                    for (Range<Integer> range : rangeCollection) {
                        Integer minimum = (Integer)range.getMinimum();
                        Integer maximum = (Integer)range.getMaximum();
                        lineNumbers.addAll(this.generateListFromXplus1toY(minimum, maximum));
                    }
                    ifDefLineMapping.put(entry.getKey(), lineNumbers);
                }
                ConcurrentHashMap<ConfigSet, Collection<Integer>> concurrent = new ConcurrentHashMap<ConfigSet, Collection<Integer>>();
                concurrent.putAll(ifDefLineMapping);
                for (ConfigSet configSet : concurrent.keySet()) {
                    if (!configSet.and(selectedConfigSet).equals(configSet) && !selectedConfigSet.and(configSet).equals(selectedConfigSet)) continue;
                    concurrent.remove(configSet);
                }
                if (concurrent.size() == 0) {
                    new MessageDialog(shell, "Emergo Message", ResourceUtil.getEmergoIcon(), "There is nothing to hide!", 2, new String[]{"Ok"}, 0).open();
                }
                List<Position> positions = this.createPositions(d, concurrent);
                ArrayList<Position> positionsEmpty = new ArrayList<Position>();
                if (editor instanceof IfDefJavaEditor) {
                    editor.expandAllAnnotations(d.getLength());
                    editor.removeAllAnnotations();
                    editor.updateFoldingStructure(positionsEmpty);
                    editor.updateFoldingStructure(positions);
                }
            }
        }
        catch (BadLocationException e1) {
            e1.printStackTrace();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        return null;
    }

    private List<? extends Integer> generateListFromXplus1toY(Integer x, Integer y) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        x = x + 1;
        int i = x;
        while (i <= y) {
            result.add(i);
            ++i;
        }
        return result;
    }

    private List<Position> createPositions(IDocument d, Map<ConfigSet, Collection<Integer>> featuresLineNumbers) throws BadLocationException {
        ArrayList<Position> positions = new ArrayList<Position>();
        Iterator<Integer> iteratorInteger = null;
        int line = 0;
        int previousLine = 0;
        int length = 0;
        int offset = 0;
        boolean newAnnotation = false;
        boolean first = true;
        Iterator<ConfigSet> featureNames = featuresLineNumbers.keySet().iterator();
        while (featureNames.hasNext()) {
            line = 0;
            previousLine = 0;
            length = 0;
            offset = 0;
            first = true;
            ConfigSet featureName = featureNames.next();
            Collection<Integer> lines = featuresLineNumbers.get(featureName);
            if (lines.size() <= 1) continue;
            iteratorInteger = lines.iterator();
            while (iteratorInteger.hasNext()) {
                if (newAnnotation) {
                    try {
                        offset = d.getLineOffset(line - 1);
                        length = d.getLineLength(line - 1);
                    }
                    catch (BadLocationException badLocationException) {
                        length = 0;
                        offset = d.getLineOffset(line);
                    }
                    newAnnotation = false;
                } else {
                    line = iteratorInteger.next() - 1;
                    if (first) {
                        try {
                            offset = d.getLineOffset(line - 1);
                            length = d.getLineLength(line - 1);
                        }
                        catch (BadLocationException badLocationException) {
                            length = 0;
                            offset = d.getLineOffset(line);
                        }
                        first = false;
                    }
                }
                length += d.getLineLength(line);
                if (previousLine > 0 && line > previousLine + 1) {
                    previousLine = line;
                    newAnnotation = true;
                    positions.add(new Position(offset, length));
                    break;
                }
                previousLine = line;
            }
            positions.add(new Position(offset, length));
        }
        return positions;
    }
}

