/*
 * Decompiled with CFR 0.152.
 */
package br.ufpe.cin.emergo.handlers;

import br.ufpe.cin.emergo.core.ConfigSet;
import br.ufpe.cin.emergo.core.DependencyFinder;
import br.ufpe.cin.emergo.core.DependencyFinderID;
import br.ufpe.cin.emergo.core.SelectionPosition;
import br.ufpe.cin.emergo.graph.DependencyNode;
import br.ufpe.cin.emergo.graph.ValueContainerEdge;
import br.ufpe.cin.emergo.properties.SystemProperties;
import br.ufpe.cin.emergo.util.ResourceUtil;
import br.ufpe.cin.emergo.views.EmergoGraphView;
import br.ufpe.cin.emergo.views.EmergoView;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.internal.ide.dialogs.InternalErrorDialog;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.jgrapht.DirectedGraph;

public class GenerateEmergentInterfaceHandler
extends AbstractHandler {
    private static boolean interprocedural = true;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        DirectedGraph<DependencyNode, ValueContainerEdge<ConfigSet>> dependencyGraph;
        Shell shell;
        block13: {
            IProject project;
            IJavaProject javaProject;
            ISelection selection = HandlerUtil.getCurrentSelectionChecked((ExecutionEvent)event);
            shell = HandlerUtil.getActiveShellChecked((ExecutionEvent)event);
            HashMap<Object, Object> options = new HashMap<Object, Object>();
            if (!(selection instanceof ITextSelection)) {
                throw new ExecutionException("Not a textual selection");
            }
            ITextEditor editor = (ITextEditor)HandlerUtil.getActiveEditorChecked((ExecutionEvent)event);
            IFile textSelectionFile = (IFile)editor.getEditorInput().getAdapter(IFile.class);
            IDocumentProvider provider = editor.getDocumentProvider();
            IDocument document = provider.getDocument((Object)editor.getEditorInput());
            ITextSelection textSelection = (ITextSelection)editor.getSite().getSelectionProvider().getSelection();
            if (textSelection.getLength() == -1) {
                new MessageDialog(shell, "Emergo Message", ResourceUtil.getEmergoIcon(), "The selection is invalid.", 4, new String[]{"Ok"}, 0).open();
            }
            interprocedural = (javaProject = JavaCore.create((IProject)(project = textSelectionFile.getProject()))).getResource().getPersistentProperty(SystemProperties.INTERPROCEDURAL_PROPKEY) != null ? javaProject.getResource().getPersistentProperty(SystemProperties.INTERPROCEDURAL_PROPKEY).toString().equals("true") : false;
            options.put("rootpath", javaProject.getResource().getLocation().toFile().getAbsolutePath());
            IClasspathEntry[] resolvedClasspath = javaProject.getResolvedClasspath(true);
            ArrayList<File> classpath = new ArrayList<File>();
            IClasspathEntry[] iClasspathEntryArray = resolvedClasspath;
            int n = resolvedClasspath.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry cpEntry = iClasspathEntryArray[n2];
                switch (cpEntry.getEntryKind()) {
                    case 5: {
                        classpath.add(cpEntry.getPath().makeAbsolute().toFile());
                        break;
                    }
                    case 3: {
                        classpath.add(ResourcesPlugin.getWorkspace().getRoot().getFolder(cpEntry.getPath()).getLocation().toFile());
                        break;
                    }
                    case 1: {
                        IPath ipath = this.makePathAbsolute(cpEntry.getPath());
                        classpath.add(ipath.toFile());
                    }
                }
                ++n2;
            }
            options.put("classpath", classpath);
            String selectionFileString = textSelectionFile.getLocation().toOSString();
            SelectionPosition selectionPosition = SelectionPosition.builder().length(textSelection.getLength()).offSet(textSelection.getOffset()).startLine(textSelection.getStartLine()).startColumn(GenerateEmergentInterfaceHandler.calculateColumnFromOffset(document, textSelection.getOffset())).endLine(textSelection.getEndLine()).endColumn(GenerateEmergentInterfaceHandler.calculateColumnFromOffset(document, textSelection.getOffset() + textSelection.getLength())).filePath(selectionFileString).build();
            dependencyGraph = DependencyFinder.findFromSelection(DependencyFinderID.JWCOMPILER, selectionPosition, options, interprocedural);
            if (dependencyGraph != null && dependencyGraph.vertexSet().size() >= 2) break block13;
            new MessageDialog(shell, "Emergo Message", ResourceUtil.getEmergoIcon(), "No dependencies found!", 2, new String[]{"Ok"}, 0).open();
            return null;
        }
        try {
            IViewPart treeView;
            IViewPart findGraphView = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getActivePage().findView("br.ufpe.cin.emergo.view.GraphView");
            if (findGraphView instanceof EmergoGraphView) {
                final EmergoGraphView view = (EmergoGraphView)findGraphView;
                new Runnable(){

                    @Override
                    public void run() {
                        view.adaptTo((DirectedGraph<DependencyNode, ValueContainerEdge<ConfigSet>>)dependencyGraph);
                    }
                }.run();
            }
            if ((treeView = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getActivePage().findView("br.ufpe.cin.emergo.views.EmergoView")) instanceof EmergoView) {
                final EmergoView emergoView = (EmergoView)treeView;
                new Runnable(){

                    @Override
                    public void run() {
                        emergoView.adaptTo((DirectedGraph<DependencyNode, ValueContainerEdge<ConfigSet>>)dependencyGraph, true);
                    }
                }.run();
            }
        }
        catch (Throwable e) {
            String message = e.getMessage() == null ? "No message specified" : e.getMessage();
            InternalErrorDialog internalErrorDialog = new InternalErrorDialog(shell, "An error has occurred", ResourceUtil.getEmergoIcon(), message, e, 1, new String[]{"Ok", "Details"}, 0);
            internalErrorDialog.setDetailButton(1);
            internalErrorDialog.open();
            e.printStackTrace();
        }
        return null;
    }

    public static int calculateColumnFromOffset(IDocument doc, int offset) {
        int sumpos = 0;
        int i = 0;
        try {
            while (sumpos + doc.getLineLength(i) - 1 < offset) {
                sumpos += doc.getLineLength(i);
                ++i;
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        return offset - sumpos + 1;
    }

    private IPath makePathAbsolute(IPath path) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource workspaceResource = root.findMember(path);
        if (workspaceResource != null) {
            path = workspaceResource.getRawLocation();
        }
        return path;
    }
}

