/*
 * Decompiled with CFR 0.152.
 */
package br.ufpe.cin.emergo.handlers;

import br.ufpe.cin.emergo.popup.SampleDialog;
import br.ufpe.cin.emergo.properties.SystemProperties;
import br.ufpe.cin.emergo.util.EmergoConstants;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class FeaturePreferencesHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        block7: {
            Shell s = HandlerUtil.getActiveShellChecked((ExecutionEvent)event);
            ITextEditor editor = (ITextEditor)HandlerUtil.getActiveEditorChecked((ExecutionEvent)event);
            IFile textSelectionFile = (IFile)editor.getEditorInput().getAdapter(IFile.class);
            IProject project = textSelectionFile.getProject();
            IJavaProject javaProject = JavaCore.create((IProject)project);
            try {
                String[] features = this.getFeaturesFromFile(javaProject);
                String choosenFeatures = javaProject.getResource().getPersistentProperty(SystemProperties.CHOOSEN_FEATURES);
                if (choosenFeatures == null) {
                    choosenFeatures = ";";
                }
                String[] choosenFeaturesArray = choosenFeatures.split(";");
                SampleDialog sp = new SampleDialog(s, features, choosenFeaturesArray);
                sp.open();
                int returnCode = sp.getReturnCode();
                if (returnCode == 1 || returnCode == 9998 || returnCode != 9999) break block7;
                features = sp.getSelectedFeatures();
                String allFeatures = "";
                int i = 0;
                while (i < features.length) {
                    allFeatures = String.valueOf(allFeatures) + features[i] + ";";
                    ++i;
                }
                javaProject.getResource().setPersistentProperty(SystemProperties.CHOOSEN_FEATURES, allFeatures);
                IDocumentProvider dp = editor.getDocumentProvider();
                IDocument doc = dp.getDocument((Object)editor.getEditorInput());
                IRegion lineInfo = null;
                try {
                    int line = 1;
                    lineInfo = doc.getLineInformation(line - 1);
                }
                catch (BadLocationException e) {
                    e.printStackTrace();
                }
                if (lineInfo != null) {
                    editor.selectAndReveal(lineInfo.getOffset(), lineInfo.getLength());
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private String[] getFeaturesFromFile(IJavaProject javaProject) {
        ArrayList<String> features = new ArrayList<String>();
        String rootpath = javaProject.getResource().getLocation().toFile().getAbsolutePath();
        File ifdefSpecFile = new File(String.valueOf(rootpath) + File.separator + EmergoConstants.FEATURE_MODEL_FILE_NAME);
        try {
            String strLine;
            if (!ifdefSpecFile.exists()) {
                throw new RuntimeException("The " + EmergoConstants.FEATURE_MODEL_FILE_NAME + " of the project was not found at " + rootpath);
            }
            FileInputStream ifdeffile = new FileInputStream(ifdefSpecFile);
            DataInputStream ifdefData = new DataInputStream(ifdeffile);
            BufferedReader ifdefReader = new BufferedReader(new InputStreamReader(ifdefData));
            int stage = 0;
            while ((strLine = ifdefReader.readLine()) != null) {
                if (strLine.trim().equals("features = {")) {
                    stage = 1;
                    continue;
                }
                if (strLine.trim().equals("}")) {
                    stage = 2;
                    continue;
                }
                if (stage != 1) continue;
                features.add(strLine.trim());
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String[] result = new String[features.size()];
        int i = 0;
        while (i < features.size()) {
            result[i] = (String)features.get(i);
            ++i;
        }
        return result;
    }
}

