/*
 * Decompiled with CFR 0.152.
 */
package br.ufpe.cin.emergo.handlers;

import br.ufpe.cin.emergo.properties.SystemProperties;
import br.ufpe.cin.emergo.util.ResourceUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.internal.ide.dialogs.InternalErrorDialog;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public abstract class AbstractEmergoHandler
extends AbstractHandler {
    private static boolean interprocedural = true;
    private final Map<Object, Object> options = new HashMap<Object, Object>();

    protected void handleSelection(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelectionChecked((ExecutionEvent)event);
        Shell shell = HandlerUtil.getActiveShellChecked((ExecutionEvent)event);
        try {
            if (!(selection instanceof ITextSelection)) {
                throw new ExecutionException("Not a textual selection");
            }
            ITextEditor editor = (ITextEditor)HandlerUtil.getActiveEditorChecked((ExecutionEvent)event);
            IFile textSelectionFile = (IFile)editor.getEditorInput().getAdapter(IFile.class);
            IDocumentProvider provider = editor.getDocumentProvider();
            provider.getDocument((Object)editor.getEditorInput());
            ITextSelection textSelection = (ITextSelection)editor.getSite().getSelectionProvider().getSelection();
            if (textSelection.getLength() == -1) {
                new MessageDialog(shell, "Emergo Message", ResourceUtil.getEmergoIcon(), "The selection is invalid.", 4, new String[]{"Ok"}, 0).open();
            }
            IProject project = textSelectionFile.getProject();
            IJavaProject javaProject = JavaCore.create((IProject)project);
            interprocedural = javaProject.getResource().getPersistentProperty(SystemProperties.INTERPROCEDURAL_PROPKEY).toString().equals("true");
            this.options.put("rootpath", javaProject.getResource().getLocation().toFile().getAbsolutePath());
            this.generateClasspath(javaProject);
        }
        catch (Throwable e) {
            String message = e.getMessage() == null ? "No message specified" : e.getMessage();
            InternalErrorDialog internalErrorDialog = new InternalErrorDialog(shell, "An error has occurred", ResourceUtil.getEmergoIcon(), message, e, 1, new String[]{"Ok", "Details"}, 0);
            internalErrorDialog.setDetailButton(1);
            internalErrorDialog.open();
            e.printStackTrace();
        }
    }

    private List<File> generateClasspath(IJavaProject javaProject) throws JavaModelException {
        IClasspathEntry[] resolvedClasspath = javaProject.getResolvedClasspath(true);
        ArrayList<File> classpath = new ArrayList<File>();
        IClasspathEntry[] iClasspathEntryArray = resolvedClasspath;
        int n = resolvedClasspath.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry cpEntry = iClasspathEntryArray[n2];
            switch (cpEntry.getEntryKind()) {
                case 5: {
                    classpath.add(cpEntry.getPath().makeAbsolute().toFile());
                    break;
                }
                case 3: {
                    classpath.add(ResourcesPlugin.getWorkspace().getRoot().getFolder(cpEntry.getPath()).getLocation().toFile());
                    break;
                }
                case 1: {
                    IPath ipath = this.makePathAbsolute(cpEntry.getPath());
                    classpath.add(ipath.toFile());
                }
            }
            ++n2;
        }
        return classpath;
    }

    private IPath makePathAbsolute(IPath path) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource workspaceResource = root.findMember(path);
        if (workspaceResource != null) {
            path = workspaceResource.getRawLocation();
        }
        return path;
    }
}

