/*
 * Decompiled with CFR 0.152.
 */
package br.ufpe.cin.emergo.graph;

import br.ufpe.cin.emergo.core.ConfigSet;
import br.ufpe.cin.emergo.core.DefUseRules;
import br.ufpe.cin.emergo.core.JWCompilerConfigSet;
import br.ufpe.cin.emergo.core.SelectionPosition;
import br.ufpe.cin.emergo.graph.DependencyNode;
import br.ufpe.cin.emergo.graph.DependencyNodeWrapper;
import br.ufpe.cin.emergo.graph.ValueContainerEdge;
import br.ufpe.cin.emergo.util.DebugUtil;
import dk.au.cs.java.compiler.cfg.ControlFlowGraph;
import dk.au.cs.java.compiler.cfg.FixedPointAnalysis;
import dk.au.cs.java.compiler.cfg.Worklist;
import dk.au.cs.java.compiler.cfg.analysis.Analysis;
import dk.au.cs.java.compiler.cfg.analysis.AnalysisProcessor;
import dk.au.cs.java.compiler.cfg.analysis.InterproceduralAnalysis;
import dk.au.cs.java.compiler.cfg.analysis.PointVisitor;
import dk.au.cs.java.compiler.cfg.edge.Edge;
import dk.au.cs.java.compiler.cfg.point.Expression;
import dk.au.cs.java.compiler.cfg.point.Point;
import dk.au.cs.java.compiler.cfg.point.Read;
import dk.au.cs.java.compiler.cfg.point.Variable;
import dk.au.cs.java.compiler.cfg.point.Write;
import dk.au.cs.java.compiler.ifdef.IfDefVarSet;
import dk.au.cs.java.compiler.ifdef.SharedSimultaneousAnalysis;
import dk.au.cs.java.compiler.node.ACompilationUnit;
import dk.au.cs.java.compiler.node.AProgram;
import dk.au.cs.java.compiler.node.Node;
import dk.au.cs.java.compiler.node.Token;
import dk.brics.lattice.LatticeSet;
import dk.brics.lattice.LatticeSetFilter;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.jgrapht.DirectedGraph;
import org.jgrapht.Graph;
import org.jgrapht.graph.DefaultDirectedGraph;
import org.jgrapht.graph.DirectedMultigraph;

public class IntermediateDependencyGraphBuilder {
    private IntermediateDependencyGraphBuilder() {
    }

    public static DirectedGraph<DependencyNode, ValueContainerEdge<ConfigSet>> buildIntraproceduralGraph(AProgram node, ControlFlowGraph cfg, Collection<Point> pointsInUserSelection, Node methodDecl) {
        SharedSimultaneousAnalysis sharedAnalysis = AnalysisProcessor.processShared((Node)methodDecl, (Analysis)new DefUseRules());
        DirectedGraph<Object, ValueContainerEdge<ConfigSet>> dependencyGraph = IntermediateDependencyGraphBuilder.createGraph(cfg, (SharedSimultaneousAnalysis<LatticeSet<Object>>)sharedAnalysis);
        DirectedGraph<DependencyNodeWrapper<Point>, ValueContainerEdge<ConfigSet>> filteredDependencyGraph = IntermediateDependencyGraphBuilder.filterWithUserSelection(pointsInUserSelection, dependencyGraph);
        DirectedGraph<DependencyNode, ValueContainerEdge<ConfigSet>> collapsedDependencyGraph = IntermediateDependencyGraphBuilder.collapseIntoLineNumbers(filteredDependencyGraph);
        DebugUtil.writeStringToFile(cfg.toDot(), "cfg-intra.dot");
        DebugUtil.exportToDotFile(dependencyGraph, "dep-intra.dot");
        DebugUtil.exportToDotFile(filteredDependencyGraph, "fil-intra.dot");
        DebugUtil.exportToDotFile(collapsedDependencyGraph, "col-intra.dot");
        return collapsedDependencyGraph;
    }

    public static DirectedGraph<DependencyNode, ValueContainerEdge<ConfigSet>> buildInterproceduralGraph(AProgram node, ControlFlowGraph cfg, final SelectionPosition selectionPosition) {
        final HashSet<Point> pointsInUserSelection = new HashSet<Point>();
        cfg = InterproceduralAnalysis.createInterproceduralControlFlowGraph((ControlFlowGraph)cfg, (int)2);
        cfg.apply((PointVisitor)new PointVisitor<Object, Object>(){

            protected Object defaultPoint(Point point, Object question) {
                Token token = point.getToken();
                int line = token.getLine();
                if (line >= selectionPosition.getStartLine() + 1 && line <= selectionPosition.getEndLine() + 1) {
                    pointsInUserSelection.add(point);
                }
                return null;
            }
        });
        SharedSimultaneousAnalysis defUseRules = new SharedSimultaneousAnalysis((Analysis)new DefUseRules());
        Worklist.process((ControlFlowGraph)cfg, (FixedPointAnalysis)defUseRules);
        DirectedGraph<Object, ValueContainerEdge<ConfigSet>> dependencyGraph = IntermediateDependencyGraphBuilder.createGraph(cfg, (SharedSimultaneousAnalysis<LatticeSet<Object>>)defUseRules);
        DirectedGraph<DependencyNodeWrapper<Point>, ValueContainerEdge<ConfigSet>> filteredDependencyGraph = IntermediateDependencyGraphBuilder.filterWithUserSelection(pointsInUserSelection, dependencyGraph);
        DirectedGraph<DependencyNode, ValueContainerEdge<ConfigSet>> collapsedDependencyGraph = IntermediateDependencyGraphBuilder.collapseIntoLineNumbers(filteredDependencyGraph);
        DebugUtil.writeStringToFile(cfg.toDot(), "cfg-inter.dot");
        DebugUtil.exportToDotFile(dependencyGraph, "dep-inter.dot");
        DebugUtil.exportToDotFile(filteredDependencyGraph, "fil-inter.dot");
        DebugUtil.exportToDotFile(collapsedDependencyGraph, "col-inter.dot");
        return collapsedDependencyGraph;
    }

    private static DirectedGraph<DependencyNode, ValueContainerEdge<ConfigSet>> collapseIntoLineNumbers(DirectedGraph<DependencyNodeWrapper<Point>, ValueContainerEdge<ConfigSet>> dependencyGraph) {
        Set nodes;
        class LineAndFile {
            public final int line;
            public final String file;

            public LineAndFile(Token token) {
                this.line = token.getLine();
                this.file = ((ACompilationUnit)token.getAncestor(ACompilationUnit.class)).getFile().getAbsolutePath();
            }

            public int hashCode() {
                return new HashCodeBuilder().append(this.line).append((Object)this.file).build();
            }

            public boolean equals(Object obj) {
                if (!(obj instanceof LineAndFile)) {
                    return false;
                }
                if (this == obj) {
                    return true;
                }
                LineAndFile otherObject = (LineAndFile)obj;
                return new EqualsBuilder().append(this.line, otherObject.line).append((Object)this.file, (Object)otherObject.file).isEquals();
            }
        }
        LineAndFile lineAndFile;
        assert (dependencyGraph != null);
        DefaultDirectedGraph collapsedGraph = new DefaultDirectedGraph(ValueContainerEdge.class);
        Set vertexSet = dependencyGraph.vertexSet();
        Set edgeSet = dependencyGraph.edgeSet();
        if (edgeSet.size() == 0 || vertexSet.size() <= 1) {
            return collapsedGraph;
        }
        HashMap<LineAndFile, HashSet<DependencyNodeWrapper>> lineNodesSetMapping = new HashMap<LineAndFile, HashSet<DependencyNodeWrapper>>();
        HashMap<LineAndFile, DependencyNodeWrapper<Set>> lineNodeMapping = new HashMap<LineAndFile, DependencyNodeWrapper<Set>>();
        HashSet<LineAndFile> keysInSelection = new HashSet<LineAndFile>();
        for (DependencyNodeWrapper dependencyNode : vertexSet) {
            Token pointToken = ((Point)dependencyNode.getData()).getToken();
            lineAndFile = new LineAndFile(pointToken);
            HashSet<DependencyNodeWrapper> set = (HashSet<DependencyNodeWrapper>)lineNodesSetMapping.get(lineAndFile);
            if (set == null) {
                set = new HashSet<DependencyNodeWrapper>();
                lineNodesSetMapping.put(lineAndFile, set);
            }
            set.add(dependencyNode);
            if (!dependencyNode.isInSelection()) continue;
            keysInSelection.add(lineAndFile);
        }
        Set entrySet = lineNodesSetMapping.entrySet();
        for (Map.Entry entry : entrySet) {
            DependencyNodeWrapper<Set> dependencyNode2;
            lineAndFile = (LineAndFile)entry.getKey();
            nodes = (Set)entry.getValue();
            IfDefVarSet accumulator = null;
            for (DependencyNodeWrapper<Set> dependencyNode2 : nodes) {
                accumulator = accumulator == null ? ((Point)dependencyNode2.getData()).getVarSet() : accumulator.and(((Point)dependencyNode2.getData()).getVarSet());
            }
            dependencyNode2 = new DependencyNodeWrapper<Set>(nodes, SelectionPosition.builder().startLine(lineAndFile.line).filePath(lineAndFile.file).build(), keysInSelection.contains(lineAndFile), accumulator);
            collapsedGraph.addVertex(dependencyNode2);
            lineNodeMapping.put(lineAndFile, dependencyNode2);
        }
        for (Map.Entry entry : entrySet) {
            lineAndFile = (LineAndFile)entry.getKey();
            nodes = (Set)entry.getValue();
            for (DependencyNodeWrapper dependencyNode : nodes) {
                Set outgoingEdgesOf = dependencyGraph.outgoingEdgesOf((Object)dependencyNode);
                for (ValueContainerEdge valueContainerEdge : outgoingEdgesOf) {
                    DependencyNodeWrapper tgtNodeWrapper;
                    DependencyNodeWrapper edgeTarget = (DependencyNodeWrapper)dependencyGraph.getEdgeTarget((Object)valueContainerEdge);
                    Token targeToken = ((Point)edgeTarget.getData()).getToken();
                    DependencyNodeWrapper srcNodeWrapper = (DependencyNodeWrapper)lineNodeMapping.get(lineAndFile);
                    ValueContainerEdge addedEdge = (ValueContainerEdge)((Object)collapsedGraph.addEdge((Object)srcNodeWrapper, (Object)(tgtNodeWrapper = (DependencyNodeWrapper)lineNodeMapping.get(new LineAndFile(targeToken)))));
                    if (addedEdge == null) {
                        ValueContainerEdge existingEdge = (ValueContainerEdge)((Object)collapsedGraph.getEdge((Object)srcNodeWrapper, (Object)tgtNodeWrapper));
                        existingEdge.setValue(((ConfigSet)existingEdge.getValue()).and((ConfigSet)valueContainerEdge.getValue()));
                        continue;
                    }
                    addedEdge.setValue((ConfigSet)valueContainerEdge.getValue());
                }
            }
        }
        return collapsedGraph;
    }

    private static DirectedGraph<DependencyNodeWrapper<Point>, ValueContainerEdge<ConfigSet>> filterWithUserSelection(Collection<Point> pointsInUserSelection, DirectedGraph<Object, ValueContainerEdge<ConfigSet>> reachesData) {
        DirectedMultigraph filteredGraph = new DirectedMultigraph(ValueContainerEdge.class);
        LinkedList<Point> workList = new LinkedList<Point>(pointsInUserSelection);
        HashSet<Point> alreadyVisitedPoints = new HashSet<Point>();
        while (!workList.isEmpty()) {
            Point head = workList.removeFirst();
            if (!reachesData.containsVertex((Object)head)) {
                alreadyVisitedPoints.add(head);
                continue;
            }
            Set outgoingEdges = reachesData.outgoingEdgesOf((Object)head);
            if (outgoingEdges.isEmpty()) {
                alreadyVisitedPoints.add(head);
                continue;
            }
            alreadyVisitedPoints.add(head);
            for (ValueContainerEdge edge : outgoingEdges) {
                Point target = (Point)reachesData.getEdgeTarget((Object)edge);
                DependencyNodeWrapper<Point> dependencyNodeTarget = new DependencyNodeWrapper<Point>(target, IntermediateDependencyGraphBuilder.makePosition(target), pointsInUserSelection.contains(target), target.getVarSet());
                filteredGraph.addVertex(dependencyNodeTarget);
                DependencyNodeWrapper<Point> dependencyNodeHead = new DependencyNodeWrapper<Point>(head, IntermediateDependencyGraphBuilder.makePosition(head), pointsInUserSelection.contains(head), head.getVarSet());
                filteredGraph.addVertex(dependencyNodeHead);
                ValueContainerEdge addedEdge = (ValueContainerEdge)((Object)filteredGraph.addEdge(dependencyNodeHead, dependencyNodeTarget));
                if (addedEdge != null) {
                    addedEdge.setValue((ConfigSet)edge.getValue());
                }
                if (!alreadyVisitedPoints.add(target)) continue;
                workList.add(target);
            }
        }
        return filteredGraph;
    }

    private static DirectedGraph<Object, ValueContainerEdge<ConfigSet>> createGraph(ControlFlowGraph controlFlowGraph, SharedSimultaneousAnalysis<LatticeSet<Object>> analysisResult) {
        final DirectedMultigraph reachesData = new DirectedMultigraph(ValueContainerEdge.class);
        LinkedList<Object> pendingPoints = new LinkedList<Object>();
        HashSet<Point> visitedPoints = new HashSet<Point>();
        pendingPoints.add(controlFlowGraph.getEntryPoint());
        while (!pendingPoints.isEmpty()) {
            IfDefVarSet key;
            LatticeSet value;
            Set entrySet;
            Map variable;
            Set ingoingEdges;
            final Point poppedPoint = (Point)pendingPoints.removeFirst();
            visitedPoints.add(poppedPoint);
            Set outgoingEdges = poppedPoint.getOutgoingEdges();
            for (Edge edge : outgoingEdges) {
                if (!visitedPoints.add(edge.getTarget())) continue;
                pendingPoints.add(edge.getTarget());
            }
            if (poppedPoint instanceof Read) {
                Read read = (Read)poppedPoint;
                final Expression expression = read.getExpression();
                ingoingEdges = read.getIngoingEdges();
                for (Edge edge : ingoingEdges) {
                    variable = analysisResult.getVariable(edge);
                    if (variable == null) continue;
                    entrySet = variable.entrySet();
                    for (Map.Entry entry : entrySet) {
                        value = (LatticeSet)entry.getValue();
                        key = (IfDefVarSet)entry.getKey();
                        if (key.and(poppedPoint.getVarSet()).isEmpty()) continue;
                        value.filter((LatticeSetFilter)new LatticeSetFilter<Object>(){

                            public boolean accept(Object obj) {
                                Write element;
                                if (obj instanceof Read) {
                                    Read element2 = (Read)obj;
                                    if (expression.toString().contains(element2.getVariable().toString())) {
                                        IntermediateDependencyGraphBuilder.connectVertices((Graph<Object, ValueContainerEdge<ConfigSet>>)((Graph)reachesData), poppedPoint, key, (Point)element2);
                                    }
                                    return true;
                                }
                                if (obj instanceof Write && (element = (Write)obj).getLValue().equals(expression)) {
                                    IntermediateDependencyGraphBuilder.connectVertices((Graph<Object, ValueContainerEdge<ConfigSet>>)((Graph)reachesData), poppedPoint, key, (Point)element);
                                }
                                return true;
                            }
                        });
                    }
                }
                continue;
            }
            if (poppedPoint instanceof Write) {
                Write write = (Write)poppedPoint;
                final Variable rValue = write.getVariable();
                ingoingEdges = write.getIngoingEdges();
                for (Edge edge : ingoingEdges) {
                    variable = analysisResult.getVariable(edge);
                    if (variable == null) continue;
                    entrySet = variable.entrySet();
                    for (Map.Entry entry : entrySet) {
                        value = (LatticeSet)entry.getValue();
                        key = (IfDefVarSet)entry.getKey();
                        value.filter((LatticeSetFilter)new LatticeSetFilter<Object>(){

                            public boolean accept(Object obj) {
                                Read element;
                                if (obj instanceof Read && rValue.equals((element = (Read)obj).getVariable())) {
                                    IntermediateDependencyGraphBuilder.connectVertices((Graph<Object, ValueContainerEdge<ConfigSet>>)((Graph)reachesData), poppedPoint, key, (Point)element);
                                }
                                return true;
                            }
                        });
                    }
                }
                continue;
            }
            final String strPoint = poppedPoint.toString();
            Set ingoingEdges2 = poppedPoint.getIngoingEdges();
            for (Edge edge : ingoingEdges2) {
                Map variable2 = analysisResult.getVariable(edge);
                if (variable2 == null) continue;
                Set entrySet2 = variable2.entrySet();
                for (Map.Entry entry : entrySet2) {
                    LatticeSet value2 = (LatticeSet)entry.getValue();
                    final IfDefVarSet key2 = (IfDefVarSet)entry.getKey();
                    value2.filter((LatticeSetFilter)new LatticeSetFilter<Object>(){

                        public boolean accept(Object obj) {
                            Read element;
                            if (obj instanceof Read && strPoint.contains((element = (Read)obj).getVariable().toString())) {
                                IntermediateDependencyGraphBuilder.connectVertices((Graph<Object, ValueContainerEdge<ConfigSet>>)((Graph)reachesData), poppedPoint, key2, (Point)element);
                            }
                            return true;
                        }
                    });
                }
            }
        }
        return reachesData;
    }

    private static void connectVertices(Graph<Object, ValueContainerEdge<ConfigSet>> graph, Point source, IfDefVarSet key, Point target) {
        graph.addVertex((Object)source);
        graph.addVertex((Object)target);
        if (graph.containsEdge((Object)target, (Object)source)) {
            ValueContainerEdge existingEdge = (ValueContainerEdge)((Object)graph.getEdge((Object)target, (Object)source));
            ConfigSet existingIfDefVarSet = (ConfigSet)existingEdge.getValue();
            ConfigSet or = existingIfDefVarSet.or(new JWCompilerConfigSet(key));
            if (((JWCompilerConfigSet)or).getVarSet().isValidInFeatureModel()) {
                existingEdge.setValue(or);
            }
        } else if (key.isValidInFeatureModel()) {
            ValueContainerEdge addedEdge = (ValueContainerEdge)((Object)graph.addEdge((Object)target, (Object)source));
            addedEdge.setValue(new JWCompilerConfigSet(key.and(source.getVarSet())));
        }
    }

    private static SelectionPosition makePosition(Point p) {
        ACompilationUnit ancestorCompilationUnit = (ACompilationUnit)p.getToken().getAncestor(ACompilationUnit.class);
        return SelectionPosition.builder().startColumn(p.getToken().getPos()).startLine(p.getToken().getLine()).filePath(ancestorCompilationUnit.getFile().getAbsolutePath()).build();
    }
}

