/*
 * Decompiled with CFR 0.152.
 */
package br.ufpe.cin.emergo.core.dependencies;

import br.ufpe.cin.emergo.core.SelectionPosition;
import br.ufpe.cin.emergo.core.dependencies.FieldDependencyVisitor;
import br.ufpe.cin.emergo.core.dependencies.IfDefGetVarSet;
import br.ufpe.cin.emergo.core.dependencies.MethodDependencyVisitor;
import dk.au.cs.java.compiler.analysis.Analysis;
import dk.au.cs.java.compiler.analysis.DepthFirstAdapter;
import dk.au.cs.java.compiler.ifdef.IfDefVarSet;
import dk.au.cs.java.compiler.node.ACompilationUnit;
import dk.au.cs.java.compiler.node.AFieldAccessPrimary;
import dk.au.cs.java.compiler.node.AFieldDecl;
import dk.au.cs.java.compiler.node.AIfdefDecl;
import dk.au.cs.java.compiler.node.AMethodDecl;
import dk.au.cs.java.compiler.node.AMethodInvocationPrimary;
import dk.au.cs.java.compiler.node.AProgram;
import dk.au.cs.java.compiler.node.Node;
import dk.au.cs.java.compiler.node.Token;
import dk.au.cs.java.compiler.type.members.Field;
import dk.au.cs.java.compiler.type.members.Method;
import java.util.ArrayList;

public class DependencyTypeDetectorVisitor
extends DepthFirstAdapter {
    private String filePath;
    private SelectionPosition position;
    private ArrayList<DepthFirstAdapter> visitors = new ArrayList();

    public DependencyTypeDetectorVisitor(String filePath, SelectionPosition position) {
        this.filePath = filePath;
        this.position = position;
    }

    public void runVisitors(AProgram rootNode) {
        for (DepthFirstAdapter visitor : this.visitors) {
            rootNode.apply((Analysis)visitor);
        }
    }

    public ArrayList<DepthFirstAdapter> getVisitors() {
        return this.visitors;
    }

    public void caseAIfdefDecl(AIfdefDecl node) {
        System.out.println("caseAIfdefDecl " + node.toString());
        super.caseAIfdefDecl(node);
    }

    public void caseACompilationUnit(ACompilationUnit cUnit) {
        String file = cUnit.getFile().getPath();
        if (file.equals(this.filePath)) {
            cUnit.apply((Analysis)new DepthFirstAdapter(){

                public void caseAFieldDecl(AFieldDecl node) {
                    if (DependencyTypeDetectorVisitor.this.selected(node.getToken())) {
                        Field field = node.getField();
                        IfDefVarSet varSet = IfDefGetVarSet.getVarSet((Node)node);
                        DependencyTypeDetectorVisitor.this.addField(field, varSet);
                    }
                    super.caseAFieldDecl(node);
                }

                public void caseAFieldAccessPrimary(AFieldAccessPrimary node) {
                    if (DependencyTypeDetectorVisitor.this.selected((Token)node.getToken())) {
                        Field field = node.getField();
                        IfDefVarSet varSet = IfDefGetVarSet.getVarSet((Node)node);
                        DependencyTypeDetectorVisitor.this.addField(field, varSet);
                    }
                    super.caseAFieldAccessPrimary(node);
                }

                public void caseAMethodDecl(AMethodDecl node) {
                    if (DependencyTypeDetectorVisitor.this.selected(node.getToken())) {
                        Method method = node.getMethod();
                        IfDefVarSet varSet = IfDefGetVarSet.getVarSet((Node)node);
                        DependencyTypeDetectorVisitor.this.addMethod(method, varSet);
                    }
                    super.caseAMethodDecl(node);
                }

                public void caseAMethodInvocationPrimary(AMethodInvocationPrimary node) {
                    if (DependencyTypeDetectorVisitor.this.selected(node.getToken())) {
                        Method method = node.getMethod();
                        IfDefVarSet varSet = IfDefGetVarSet.getVarSet((Node)node);
                        DependencyTypeDetectorVisitor.this.addMethod(method, varSet);
                    }
                    super.caseAMethodInvocationPrimary(node);
                }
            });
        }
    }

    private boolean selected(Token token) {
        int line = token.getLine();
        int startLine = this.position.getStartLine() + 1;
        int endLine = this.position.getEndLine() + 1;
        if (line >= startLine && line <= endLine) {
            int pos = token.getPos();
            int startColumn = this.position.getStartColumn();
            int endColumn = this.position.getEndColumn();
            if (line == startLine && pos < startColumn) {
                return false;
            }
            return line != endLine || pos <= endColumn;
        }
        return false;
    }

    private void addField(Field field, IfDefVarSet varSet) {
        if (field == null) {
            System.err.println("Field == null");
            return;
        }
        if (varSet == null) {
            System.err.println("VarSet == null");
            return;
        }
        this.visitors.add(new FieldDependencyVisitor(field, varSet));
    }

    private void addMethod(Method method, IfDefVarSet varSet) {
        if (method == null) {
            System.err.println("Method == null");
            return;
        }
        if (varSet == null) {
            System.err.println("VarSet == null");
            return;
        }
        this.visitors.add(new MethodDependencyVisitor(method, varSet));
    }
}

