/*
 * Decompiled with CFR 0.152.
 */
package br.ufpe.cin.emergo.core;

import java.io.File;

public final class SelectionPosition {
    private final int length;
    private final int offSet;
    private final int startLine;
    private final int startColumn;
    private final int endLine;
    private final int endColumn;
    private final String filePath;
    private final String stringRepresentation;

    public SelectionPosition(int l, int o, int sl, int sc, int el, int ec, String f) {
        this.length = l;
        this.offSet = o;
        this.startLine = sl;
        this.startColumn = sc;
        this.endLine = el;
        this.endColumn = ec;
        this.filePath = f;
        this.stringRepresentation = "[(" + sl + "," + sc + "),(" + el + "," + ec + ")," + l + "," + new File(this.filePath).getName() + "]";
    }

    public int getStartLine() {
        return this.startLine;
    }

    public int getOffSet() {
        return this.offSet;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public int getLength() {
        return this.length;
    }

    public int getEndColumn() {
        return this.endColumn;
    }

    public int getEndLine() {
        return this.endLine;
    }

    public int getStartColumn() {
        return this.startColumn;
    }

    public String toString() {
        return this.stringRepresentation;
    }

    public static Builder builder() {
        return new Builder();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.endColumn;
        result = 31 * result + this.endLine;
        result = 31 * result + (this.filePath == null ? 0 : this.filePath.hashCode());
        result = 31 * result + this.length;
        result = 31 * result + this.offSet;
        result = 31 * result + this.startColumn;
        result = 31 * result + this.startLine;
        result = 31 * result + (this.stringRepresentation == null ? 0 : this.stringRepresentation.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SelectionPosition)) {
            return false;
        }
        SelectionPosition other = (SelectionPosition)obj;
        if (this.endColumn != other.endColumn) {
            return false;
        }
        if (this.endLine != other.endLine) {
            return false;
        }
        if (this.filePath == null ? other.filePath != null : !this.filePath.equals(other.filePath)) {
            return false;
        }
        if (this.length != other.length) {
            return false;
        }
        if (this.offSet != other.offSet) {
            return false;
        }
        if (this.startColumn != other.startColumn) {
            return false;
        }
        if (this.startLine != other.startLine) {
            return false;
        }
        return !(this.stringRepresentation == null ? other.stringRepresentation != null : !this.stringRepresentation.equals(other.stringRepresentation));
    }

    public static final class Builder {
        private int l;
        private int o;
        private int sl;
        private int el;
        private int sc;
        private int ec;
        private String f;

        public Builder length(int l) {
            this.l = l;
            return this;
        }

        public Builder offSet(int o) {
            this.o = o;
            return this;
        }

        public Builder startLine(int sl) {
            this.sl = sl;
            return this;
        }

        public Builder startColumn(int sc) {
            this.sc = sc;
            return this;
        }

        public Builder endLine(int el) {
            this.el = el;
            return this;
        }

        public Builder endColumn(int ec) {
            this.ec = ec;
            return this;
        }

        public Builder filePath(String f) {
            this.f = f;
            return this;
        }

        public SelectionPosition build() {
            return new SelectionPosition(this.l, this.o, this.sl, this.sc, this.el, this.ec, this.f);
        }
    }
}

