/*
 * Decompiled with CFR 0.152.
 */
package br.ufpe.cin.emergo.core;

import br.ufpe.cin.emergo.core.ConfigSet;
import br.ufpe.cin.emergo.core.EmergoException;
import br.ufpe.cin.emergo.core.JWCompilerConfigSet;
import br.ufpe.cin.emergo.core.SelectionPosition;
import br.ufpe.cin.emergo.graph.DependencyNode;
import br.ufpe.cin.emergo.graph.IntermediateDependencyGraphBuilder;
import br.ufpe.cin.emergo.graph.ValueContainerEdge;
import br.ufpe.cin.emergo.util.EmergoConstants;
import dk.au.cs.java.compiler.ErrorType;
import dk.au.cs.java.compiler.Errors;
import dk.au.cs.java.compiler.Flags;
import dk.au.cs.java.compiler.Main;
import dk.au.cs.java.compiler.SourceError;
import dk.au.cs.java.compiler.Util;
import dk.au.cs.java.compiler.analysis.Analysis;
import dk.au.cs.java.compiler.analysis.DepthFirstAdapter;
import dk.au.cs.java.compiler.cfg.ControlFlowGraph;
import dk.au.cs.java.compiler.cfg.analysis.PointVisitor;
import dk.au.cs.java.compiler.cfg.gen.CFGGenerator;
import dk.au.cs.java.compiler.cfg.point.Point;
import dk.au.cs.java.compiler.check.DisambiguationCheck;
import dk.au.cs.java.compiler.check.EnvironmentsCheck;
import dk.au.cs.java.compiler.check.HierarchyCheck;
import dk.au.cs.java.compiler.check.TypeCheckingCheck;
import dk.au.cs.java.compiler.check.TypeLinkingCheck;
import dk.au.cs.java.compiler.check.WeedingCheck;
import dk.au.cs.java.compiler.ifdef.IfDefBDDAssigner;
import dk.au.cs.java.compiler.ifdef.IfDefUtil;
import dk.au.cs.java.compiler.ifdef.IfDefVarSet;
import dk.au.cs.java.compiler.ifdef.SharedSimultaneousAnalysis;
import dk.au.cs.java.compiler.lexer.Lexer;
import dk.au.cs.java.compiler.lexer.LexerException;
import dk.au.cs.java.compiler.node.ACompilationUnit;
import dk.au.cs.java.compiler.node.AIfdefStm;
import dk.au.cs.java.compiler.node.AMethodDecl;
import dk.au.cs.java.compiler.node.AProgram;
import dk.au.cs.java.compiler.node.Node;
import dk.au.cs.java.compiler.node.PIfdefExp;
import dk.au.cs.java.compiler.node.Start;
import dk.au.cs.java.compiler.node.TEndif;
import dk.au.cs.java.compiler.node.TIdentifier;
import dk.au.cs.java.compiler.node.Token;
import dk.au.cs.java.compiler.parser.Parser;
import dk.au.cs.java.compiler.parser.ParserException;
import dk.au.cs.java.compiler.phases.Disambiguation;
import dk.au.cs.java.compiler.phases.Environments;
import dk.au.cs.java.compiler.phases.Hierarchy;
import dk.au.cs.java.compiler.phases.Reachability;
import dk.au.cs.java.compiler.phases.Resources;
import dk.au.cs.java.compiler.phases.TargetResolver;
import dk.au.cs.java.compiler.phases.TypeChecking;
import dk.au.cs.java.compiler.phases.TypeLinking;
import dk.au.cs.java.compiler.phases.Weeding;
import dk.au.cs.java.compiler.phases.XACTDesugaring;
import dk.au.cs.java.compiler.type.environment.ClassEnvironment;
import dk.au.cs.java.compiler.type.members.Method;
import dk.brics.util.file.WildcardExpander;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.Range;
import org.jgrapht.DirectedGraph;

public class JWCompilerDependencyFinder {
    private static DirectedGraph<DependencyNode, ValueContainerEdge<ConfigSet>> useDefWeb;
    private static AProgram rootNode;

    public static Map<ConfigSet, Collection<Range<Integer>>> ifDefBlocks(File file) {
        if (rootNode == null) {
            throw new IllegalStateException("Program has not been parsed yet");
        }
        final HashMap<ConfigSet, Collection<Range<Integer>>> configMapping = new HashMap<ConfigSet, Collection<Range<Integer>>>();
        new ArrayDeque();
        final String filePath = file.getAbsolutePath();
        rootNode.apply((Analysis)new DepthFirstAdapter(){

            public void caseACompilationUnit(ACompilationUnit compilationUnit) {
                String file = compilationUnit.getFile().getPath();
                if (file.equals(filePath)) {
                    compilationUnit.apply((Analysis)new DepthFirstAdapter(){

                        public void caseAIfdefStm(AIfdefStm node) {
                            int startLine;
                            IfDefVarSet varSet = node.getOnTrueSet();
                            int endLine = startLine = node.getToken().getLine();
                            TEndif endToken = node.getEndToken();
                            if (endToken != null) {
                                endLine = endToken.getLine();
                            } else if (!$assertionsDisabled) {
                                throw new AssertionError();
                            }
                            JWCompilerConfigSet configSet = JWCompilerConfigSet.of(varSet);
                            Range blockRange = Range.between((Comparable)Integer.valueOf(startLine), (Comparable)Integer.valueOf(endLine));
                            if (configMapping.containsKey(configSet)) {
                                ((Collection)configMapping.get(configSet)).add(blockRange);
                            } else {
                                HashSet<Range> collectionOfBlocks = new HashSet<Range>();
                                collectionOfBlocks.add(blockRange);
                                configMapping.put(configSet, collectionOfBlocks);
                            }
                        }
                    });
                }
            }
        });
        return configMapping;
    }

    public static DirectedGraph<DependencyNode, ValueContainerEdge<ConfigSet>> generateDependencyGraph(SelectionPosition selectionPosition, Map<Object, Object> options, boolean interprocedural) throws EmergoException {
        Main.resetCompiler();
        useDefWeb = null;
        rootNode = null;
        File selectionFile = new File(selectionPosition.getFilePath());
        if (!selectionFile.exists()) {
            throw new EmergoException("File " + selectionPosition.getFilePath() + " not found.");
        }
        String rootpath = (String)options.get("rootpath");
        File ifdefSpecFile = new File(String.valueOf(rootpath) + File.separator + EmergoConstants.FEATURE_MODEL_FILE_NAME);
        if (!ifdefSpecFile.exists()) {
            throw new RuntimeException("The " + EmergoConstants.FEATURE_MODEL_FILE_NAME + " of the project was not found at " + rootpath);
        }
        ArrayList<File> javaFiles = new ArrayList<File>();
        ArrayList<File> jarFiles = new ArrayList<File>();
        List sources = (List)options.get("classpath");
        for (File file : sources) {
            if (file.isDirectory()) {
                String filepath = String.valueOf(file.getPath()) + File.separator + "**" + File.separator + "*.java";
                List expandWildcards = WildcardExpander.expandWildcards((String)filepath);
                javaFiles.addAll(expandWildcards);
                continue;
            }
            if (!file.isFile() || !file.exists()) continue;
            jarFiles.add(file);
        }
        String classpath = JWCompilerDependencyFinder.generateClassPath(jarFiles);
        ClassEnvironment.init((String)classpath, (boolean)false);
        EnumSet flags = Main.FLAGS;
        flags.add(Flags.IFDEF);
        SharedSimultaneousAnalysis.useSharedSetStrategy((boolean)true);
        IfDefUtil.parseIfDefSpecification((File)ifdefSpecFile);
        IfDefVarSet.getIfDefBDDFactory();
        Main.program = rootNode = JWCompilerDependencyFinder.parseProgram(javaFiles);
        rootNode.setOptionalInvariant(true);
        try {
            Errors.check();
            rootNode.apply((Analysis)new Weeding());
            Errors.check();
            rootNode.apply((Analysis)new WeedingCheck());
            Errors.check();
            rootNode.apply((Analysis)new IfDefBDDAssigner());
            Errors.check();
            rootNode.apply((Analysis)new Environments());
            Errors.check();
            rootNode.apply((Analysis)new EnvironmentsCheck());
            Errors.check();
            rootNode.apply((Analysis)new TypeLinking());
            Errors.check();
            rootNode.apply((Analysis)new TypeLinkingCheck());
            Errors.check();
            rootNode.apply((Analysis)new Hierarchy());
            Errors.check();
            rootNode.apply((Analysis)new HierarchyCheck());
            Errors.check();
            rootNode.apply((Analysis)new Disambiguation());
            Errors.check();
            rootNode.apply((Analysis)new DisambiguationCheck());
            Errors.check();
            rootNode.apply((Analysis)new TargetResolver());
            Errors.check();
            rootNode.apply((Analysis)new Reachability());
            Errors.check();
            rootNode.apply((Analysis)new TypeChecking());
            Errors.check();
            rootNode.apply((Analysis)new TypeCheckingCheck());
            Errors.check();
            rootNode.apply((Analysis)new CFGGenerator());
            Errors.check();
            rootNode.apply((Analysis)new XACTDesugaring());
            Errors.check();
            rootNode.apply((Analysis)new Resources());
            Errors.check();
        }
        catch (SourceError ex) {
            ex.printStackTrace();
            throw new EmergoException("Compilation error: " + ex.getMessage());
        }
        final int selectionStartLine = selectionPosition.getStartLine() + 1;
        final int selecionEndLine = selectionPosition.getEndLine() + 1;
        final HashSet<Point> pointsInUserSelection = new HashSet<Point>();
        final AMethodDecl[] methodBox = new AMethodDecl[1];
        final String filePath = selectionPosition.getFilePath();
        rootNode.apply((Analysis)new DepthFirstAdapter(){
            private boolean found = false;

            public void caseACompilationUnit(ACompilationUnit cUnit) {
                String file = cUnit.getFile().getPath();
                if (!this.found && file.equals(filePath)) {
                    final Token[] tokenBox = new Token[1];
                    cUnit.apply((Analysis)new DepthFirstAdapter(){

                        public void defaultToken(Token defaultToken) {
                            if (tokenBox[0] != null) {
                                return;
                            }
                            int line = defaultToken.getLine();
                            if (line >= selectionStartLine && line <= selecionEndLine) {
                                tokenBox[0] = defaultToken;
                            }
                        }
                    });
                    methodBox[0] = (AMethodDecl)tokenBox[0].getAncestor(AMethodDecl.class);
                    this.found = true;
                }
            }
        });
        AMethodDecl methodDecl = methodBox[0];
        if (methodDecl == null) {
            throw new IllegalArgumentException("Could not find enclosing method for the selection");
        }
        Method method = methodDecl.getMethod();
        ControlFlowGraph cfg = method.getControlFlowGraph();
        cfg.apply((PointVisitor)new PointVisitor<Object, Object>(){

            protected Object defaultPoint(Point point, Object question) {
                Token token = point.getToken();
                int line = token.getLine();
                if (line >= selectionStartLine && line <= selecionEndLine) {
                    pointsInUserSelection.add(point);
                }
                return null;
            }
        });
        useDefWeb = interprocedural ? IntermediateDependencyGraphBuilder.buildInterproceduralGraph(rootNode, cfg, selectionPosition) : IntermediateDependencyGraphBuilder.buildIntraproceduralGraph(rootNode, cfg, pointsInUserSelection, (Node)methodDecl);
        return useDefWeb;
    }

    public static AProgram parseProgram(List<File> sourceFiles) {
        ArrayList<ACompilationUnit> sources = new ArrayList<ACompilationUnit>();
        for (File file : sourceFiles) {
            try {
                Util.showPhaseProgress();
                FileInputStream fis = new FileInputStream(file);
                Parser parser = new Parser(new Lexer((InputStream)fis));
                Start startsym = parser.parse();
                fis.close();
                ACompilationUnit compilationUnit = startsym.getCompilationUnit();
                compilationUnit.setToken((Token)new TIdentifier(file.getPath(), 0, 0));
                compilationUnit.setFile(file);
                sources.add(compilationUnit);
            }
            catch (FileNotFoundException fileNotFoundException) {
                Errors.errorMessage((ErrorType)ErrorType.FILE_OPEN_ERROR, (String)("File " + file.getPath() + " not found"));
                Errors.check();
            }
            catch (LexerException e) {
                Errors.error((ErrorType)ErrorType.LEXER_EXCEPTION, (File)file, (int)e.getLine(), (int)e.getPos(), (String)("Syntax error at " + file.getPath() + " " + e.getMessage()), (boolean)false);
            }
            catch (ParserException e) {
                Errors.error((ErrorType)ErrorType.PARSER_EXCEPTION, (File)file, (int)e.getToken().getLine(), (int)e.getToken().getPos(), (String)("Syntax error at " + file.getPath() + " " + e.getMessage()), (boolean)false);
            }
            catch (IOException e) {
                Errors.errorMessage((ErrorType)ErrorType.IO_ERROR, (String)("Error reading file " + file.getPath() + ": " + e.getMessage()));
                Errors.check();
            }
        }
        AProgram node = new AProgram((Token)new TIdentifier("AProgram", 0, 0), sources);
        node.setOptionalInvariant(true);
        return node;
    }

    private static String generateClassPath(Collection<File> jarFiles) {
        StringBuilder classpath = new StringBuilder();
        for (File file : jarFiles) {
            classpath.append(String.valueOf(file.getAbsolutePath()) + File.pathSeparator);
        }
        String result = classpath.toString();
        return result.substring(0, result.length() - 1);
    }

    public static Map<PIfdefExp, Collection<Range<Integer>>> ifDefBlocks(File file, AProgram rootNode2) {
        rootNode = rootNode2;
        return JWCompilerDependencyFinder.ifDefBlocksWithFeaturesTags(file);
    }

    public static Map<PIfdefExp, Collection<Range<Integer>>> ifDefBlocksWithFeaturesTags(File file) {
        if (rootNode == null) {
            throw new IllegalStateException("Program has not been parsed yet");
        }
        final HashMap<PIfdefExp, Collection<Range<Integer>>> configMapping = new HashMap<PIfdefExp, Collection<Range<Integer>>>();
        new ArrayDeque();
        final String filePath = file.getAbsolutePath();
        rootNode.apply((Analysis)new DepthFirstAdapter(){

            public void caseACompilationUnit(ACompilationUnit compilationUnit) {
                String file = compilationUnit.getFile().getPath();
                if (file.equals(filePath)) {
                    compilationUnit.apply((Analysis)new DepthFirstAdapter(){

                        public void caseAIfdefStm(AIfdefStm node) {
                            int startLine;
                            IfDefVarSet varSet = node.getOnTrueSet();
                            int endLine = startLine = node.getToken().getLine();
                            TEndif endToken = node.getEndToken();
                            if (endToken != null) {
                                endLine = endToken.getLine();
                            } else if (!$assertionsDisabled) {
                                throw new AssertionError();
                            }
                            JWCompilerConfigSet configSet = JWCompilerConfigSet.of(varSet);
                            Range blockRange = Range.between((Comparable)Integer.valueOf(startLine), (Comparable)Integer.valueOf(endLine));
                            if (configMapping.containsKey(configSet)) {
                                ((Collection)configMapping.get(configSet)).add(blockRange);
                            } else {
                                HashSet<Range> collectionOfBlocks = new HashSet<Range>();
                                collectionOfBlocks.add(blockRange);
                                configMapping.put(node.getExp(), collectionOfBlocks);
                            }
                        }
                    });
                }
            }
        });
        return configMapping;
    }
}

