/*
 * Decompiled with CFR 0.152.
 */
package CIspace.prolog;

import CIspace.prolog.Functor;
import CIspace.prolog.Goal;
import CIspace.prolog.Predicate;
import CIspace.prolog.Program;
import CIspace.prolog.Substitution;
import java.util.Vector;

public class Term {
    public static final int C_VARIABLE = 0;
    public static final int C_CONSTANT = 1;
    public static final int C_COMPOUND = 2;
    public int type;
    protected Term[] terms;
    protected String name;
    protected String realName;
    public boolean isList = false;
    protected Functor func;
    public Term unifiedWith;

    public Term(String str) {
        this.name = "";
        this.realName = "";
        int bracket = str.indexOf("(");
        int square = str.indexOf("[");
        if (bracket == -1 && square == -1) {
            if (str.indexOf("=") != -1 || str.indexOf("<") != -1 || str.indexOf(">") != -1) {
                Goal g = Program.parseBuiltInGoal(str);
                this.type = 2;
                this.func = new Functor(g.pred.type);
                this.terms = g.terms;
            } else {
                this.name = str;
                this.realName = str;
                String firstLetter = str.substring(0, 1);
                this.type = firstLetter.toLowerCase().equals(firstLetter) && !str.startsWith("_") ? 1 : 0;
            }
        } else if (square != -1 && (square < bracket || bracket == -1)) {
            square = str.indexOf("[", square + 1);
            int middle = str.indexOf("|");
            int nextComma = str.indexOf(",");
            int next = -1;
            next = !(bracket == -1 || bracket >= square && square != -1 || bracket >= nextComma && nextComma != -1) ? Program.findNextRight(bracket, str) + 1 : (!(square == -1 || square >= bracket && bracket != -1 || square >= nextComma && nextComma != -1) ? Program.findNextRightSquare(square, str) + 1 : (nextComma != -1 ? nextComma : str.length()));
            if (next <= 0) {
                this.name = "";
                this.realName = "";
                return;
            }
            if (middle == -1 && str.indexOf(",", next) == -1 && nextComma < next) {
                if (str.substring(1, str.length() - 1).trim().equals("")) {
                    this.name = "[]";
                    this.realName = "[]";
                    this.type = 1;
                    this.isList = true;
                } else {
                    Term t = new Term(str.substring(1, str.lastIndexOf("]")).trim());
                    this.type = 2;
                    this.func = new Functor(772);
                    this.terms = new Term[2];
                    this.terms[0] = t;
                    this.terms[1] = new Term("[]");
                    this.isList = true;
                }
            } else if (middle != -1 && nextComma < next && str.indexOf(",", next) == -1) {
                this.type = 2;
                this.func = new Functor(772);
                this.isList = true;
                this.terms = new Term[2];
                this.terms[0] = new Term(str.substring(1, middle).trim());
                Term carCdr = new Term(str.substring(middle + 1, str.lastIndexOf("]")).trim());
                if (carCdr.type != 0) {
                    Term cdrCdr = new Term("[]");
                    Term[] tempTerms = new Term[]{carCdr, cdrCdr};
                    this.terms[1] = new Term(this.func, tempTerms);
                } else {
                    this.terms[1] = carCdr;
                }
                this.terms[1].isList = true;
            } else {
                int j = next;
                this.type = 2;
                this.func = new Functor(772);
                this.isList = true;
                this.terms = new Term[2];
                this.terms[0] = new Term(str.substring(1, j).trim());
                String tempString = str.substring(j + 1).trim();
                this.terms[1] = new Term("[" + tempString);
            }
        } else {
            int next;
            int i = str.indexOf("(");
            String fname = str.substring(0, i).trim();
            int compound = str.indexOf("(", i + 1);
            int compound2 = str.indexOf("[", i + 1);
            int j = str.indexOf(",");
            int end = str.length() - 1;
            if (compound > -1 && compound < j && (compound2 == -1 || compound < compound)) {
                next = Program.findNextRight(compound, str);
                if (next == -1) {
                    this.name = "";
                    this.realName = "";
                    return;
                }
                j = next + 1;
            } else if (compound2 > -1 && compound2 < j) {
                next = Program.findNextRightSquare(compound2, str);
                if (next == -1) {
                    this.name = "";
                    this.realName = "";
                    return;
                }
                j = next + 1;
            }
            Vector<Term> newTerms = new Vector<Term>();
            ++i;
            while (j > 0) {
                String nextTerm = str.substring(i, j).trim();
                if (!Program.matchBrackets(nextTerm)) {
                    this.name = "";
                    this.realName = "";
                    return;
                }
                i = j + 1;
                newTerms.addElement(new Term(nextTerm));
                compound = str.indexOf("(", j);
                compound2 = str.indexOf("[", j);
                int nextComma = str.indexOf(",", i);
                j = compound != -1 && compound < nextComma && (compound2 == -1 || compound < compound2) ? Program.findNextRight(compound, str) + 1 : (compound2 > -1 && compound2 < nextComma ? Program.findNextRightSquare(compound2, str) + 1 : str.indexOf(",", i));
            }
            if (i < end) {
                newTerms.addElement(new Term(str.substring(i, end).trim()));
            }
            this.terms = new Term[newTerms.size()];
            int ind = 0;
            while (ind < newTerms.size()) {
                this.terms[ind] = (Term)newTerms.elementAt(ind);
                ++ind;
            }
            this.func = new Functor(fname, this.terms.length);
            this.type = 2;
        }
    }

    public Term(Functor f, Term[] newTerms) {
        this.name = "";
        this.realName = "";
        this.func = f;
        this.terms = newTerms;
        this.type = 2;
        if (f.type == 772) {
            this.isList = true;
        }
    }

    public Term(Term t) {
        this.type = t.type;
        if (this.type != 2) {
            this.name = t.name;
            this.realName = t.name;
        } else {
            this.name = "";
            this.realName = "";
            this.func = t.func;
            this.terms = new Term[t.terms.length];
            int i = 0;
            while (i < t.terms.length) {
                this.terms[i] = new Term(t.terms[i]);
                ++i;
            }
        }
        this.isList = t.isList;
    }

    public Goal termToGoal() {
        if (this.type != 2) {
            return null;
        }
        if (this.func.builtIn()) {
            Predicate p = Predicate.getPred(this.func.type);
            Goal g = new Goal(p, this.copyTerms());
            return g;
        }
        Predicate p = new Predicate(this.func.name, this.func.arity);
        Goal g = new Goal(p, this.cloneTerms());
        return g;
    }

    public String getName() {
        return this.toString();
    }

    public String getRealName() {
        return this.realName;
    }

    public void setName(String newName) {
        this.name = newName;
    }

    public Vector getVariables() {
        if (this.type == 2) {
            Vector vars = new Vector(this.terms.length);
            int i = 0;
            while (i < this.terms.length) {
                Program.append(vars, this.terms[i].getVariables());
                ++i;
            }
            return vars;
        }
        Vector<Term> vars = new Vector<Term>(1);
        vars.addElement(this);
        return vars;
    }

    private Term[] copyTerms() {
        Term[] newTerms = new Term[this.terms.length];
        int i = 0;
        while (i < this.terms.length) {
            newTerms[i] = new Term(this.terms[i]);
            ++i;
        }
        return newTerms;
    }

    private Term[] cloneTerms() {
        Term[] newTerms = new Term[this.terms.length];
        int i = 0;
        while (i < this.terms.length) {
            newTerms[i] = this.terms[i];
            ++i;
        }
        return newTerms;
    }

    public int putVariables(Vector v, int index) {
        if (this.type != 2) {
            return index;
        }
        int i = 0;
        while (i < this.terms.length) {
            if (this.terms[i].type != 2) {
                this.terms[i] = (Term)v.elementAt(index);
                ++index;
            } else {
                index = this.terms[i].putVariables(v, index);
            }
            ++i;
        }
        return index;
    }

    public void clearUnified() {
        this.unifiedWith = null;
        if (this.type == 2) {
            int i = 0;
            while (i < this.terms.length) {
                this.terms[i].clearUnified();
                ++i;
            }
        }
    }

    public Term[] getTerms() {
        if (this.terms != null) {
            return this.terms;
        }
        return null;
    }

    public Term lastUnified() {
        if (this.unifiedWith == null) {
            return this;
        }
        Term t = this.unifiedWith.lastUnified();
        if (t.type == 2 && !t.containsVariable(this)) {
            return t.fixTerms();
        }
        return t;
    }

    public Term fixTerms() {
        if (this.type != 2) {
            return new Term(this.lastUnified());
        }
        Term[] newTerms = new Term[this.terms.length];
        int i = 0;
        while (i < this.terms.length) {
            newTerms[i] = this.terms[i].lastUnified();
            ++i;
        }
        Term t = new Term(this.func, newTerms);
        t.isList = this.isList;
        return t;
    }

    public Term fixTerms2() {
        if (this.type != 2) {
            if (this.unifiedWith == null) {
                return this;
            }
            if (this.unifiedWith.containsVariable(this)) {
                return this.unifiedWith;
            }
            return this.unifiedWith.fixTerms2();
        }
        Term[] newTerms = new Term[this.terms.length];
        int i = 0;
        while (i < this.terms.length) {
            newTerms[i] = this.terms[i].containsVariable(this) ? this.terms[i] : this.terms[i].fixTerms2();
            ++i;
        }
        Term t = new Term(this.func, newTerms);
        t.isList = this.isList;
        return t;
    }

    protected boolean containsVariable(Term t) {
        if (this.type != 2) {
            return false;
        }
        int i = 0;
        while (i < this.terms.length) {
            if (this.terms[i] == t || this.terms[i].containsVariable(t)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public Term unify(Term t, boolean occursCheck) {
        if (t.name.equals("_")) {
            return this;
        }
        if (this.name.equals("_")) {
            return t;
        }
        if (!(t.type != 0 || occursCheck && this.containsVariable(t))) {
            if (this.type == 1 && !this.isList && t.isList) {
                return null;
            }
            t.unifiedWith = this;
            if (this.unifiedWith == t) {
                this.unifiedWith = null;
            }
            return this;
        }
        if (!(this.type != 0 || occursCheck && t.containsVariable(this))) {
            if (t.type == 1 && !t.isList && this.isList) {
                return null;
            }
            this.unifiedWith = t;
            if (t.unifiedWith == this) {
                t.unifiedWith = null;
            }
            return t;
        }
        if (this.type == 1 && t.type == 1 && t.name.equals(this.name)) {
            return this;
        }
        if (this.type == 2 && t.type == 2 && t.func.name.equals(this.func.name) && t.func.arity == this.func.arity && t.isList == this.isList) {
            Term[] unified = new Term[this.terms.length];
            int i = 0;
            while (i < this.terms.length) {
                Term newTerm = this.terms[i].lastUnified().unify(t.getTerms()[i].lastUnified(), occursCheck);
                if (newTerm == null) {
                    return null;
                }
                unified[i] = newTerm;
                unified[i].isList = this.terms[i].isList;
                ++i;
            }
            this.unifiedWith = new Term(this.func, unified);
            this.unifiedWith.isList = this.isList;
            return this.unifiedWith;
        }
        return null;
    }

    public Integer solveArithmetic() {
        try {
            if (this.type == 1 && this.name.toUpperCase().equals(this.name)) {
                int ans = Integer.parseInt(this.name);
                return new Integer(ans);
            }
            if (this.type == 2 && this.func != null && this.func.builtin) {
                int type = this.func.type;
                Integer left1 = this.terms[0].lastUnified().solveArithmetic();
                Integer left2 = this.terms[1].lastUnified().solveArithmetic();
                if (left1 == null || left2 == null) {
                    return null;
                }
                int left = left1;
                int right = left2;
                switch (type) {
                    case 770: {
                        return new Integer(left * right);
                    }
                    case 771: {
                        return new Integer(left + right);
                    }
                    case 773: {
                        return new Integer(left % right);
                    }
                    case 774: {
                        return new Integer(left - right);
                    }
                }
                return null;
            }
            return null;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static Term applySubs(Term newTerm, Vector subs) {
        if (newTerm.type != 2) {
            return newTerm;
        }
        Vector<Term> newTerms = new Vector<Term>(newTerm.getVariables().size());
        Vector vars = newTerm.getVariables();
        int i = 0;
        while (i < vars.size()) {
            Term t = (Term)vars.elementAt(i);
            int j = 0;
            while (j < subs.size()) {
                Substitution s = (Substitution)subs.elementAt(j);
                if (s.first.name.equals(t.name)) {
                    t = Term.applySubs(s.second, subs);
                }
                ++j;
            }
            newTerms.addElement(t);
            ++i;
        }
        Term t1 = new Term(newTerm);
        t1.putVariables(newTerms, 0);
        return t1;
    }

    public Term applySubs(Vector subs, boolean recurse) {
        if (this.type != 2) {
            int i = 0;
            while (i < subs.size()) {
                Substitution s = (Substitution)subs.elementAt(i);
                if (s.first.name.equals(this.name)) {
                    if (s.second.type != 1 && recurse && !s.second.containsVariable(this)) {
                        return s.second.applySubs(subs, true);
                    }
                    s.second.unifiedWith = null;
                    return s.second;
                }
                ++i;
            }
            return this;
        }
        Term[] newTerms = new Term[this.terms.length];
        int i = 0;
        while (i < this.terms.length) {
            newTerms[i] = this.terms[i].containsVariable(this) ? this.terms[i] : this.terms[i].applySubs(subs, recurse);
            ++i;
        }
        return new Term(this.func, newTerms);
    }

    protected boolean equals(Term t) {
        if (t.type == 1) {
            return this.name.equals(t.name);
        }
        if (t.type == 0) {
            if (this.isList != t.isList) {
                return false;
            }
            return this.name.equals(t.name);
        }
        if (!t.func.equals(this.func)) {
            return false;
        }
        int i = 0;
        while (i < this.terms.length) {
            if (!this.terms[i].equals(t.terms[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean isGround() {
        if (this.type == 0) {
            return false;
        }
        if (this.type == 1) {
            return true;
        }
        int i = 0;
        while (i < this.terms.length) {
            if (!this.terms[i].isGround()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public Vector getElements() {
        if (this.type == 1) {
            Vector<Term> single = new Vector<Term>(1);
            single.addElement(this);
            return single;
        }
        if (!this.isList) {
            return new Vector();
        }
        if (this.type == 0) {
            Vector<Term> two = new Vector<Term>(2);
            two.addElement(this);
            two.addElement(new Term("[]"));
            return two;
        }
        Vector<Term> elements = new Vector<Term>(5, 2);
        elements.addElement(this.terms[0]);
        Program.append(elements, this.terms[1].getElements());
        return elements;
    }

    public String toString() {
        if (this.isList && this.type == 2) {
            String str = new String("[");
            Vector elements = this.getElements();
            str = String.valueOf(str) + ((Term)elements.elementAt(0)).toString();
            int i = 1;
            while (i < elements.size() - 1) {
                Term t = (Term)elements.elementAt(i);
                str = i == elements.size() - 2 && t.type == 0 && t.isList ? String.valueOf(str) + " | " + t.toString() : String.valueOf(str) + ", " + t.toString();
                ++i;
            }
            str = String.valueOf(str) + "]";
            return str;
        }
        if (this.type != 2) {
            return this.name;
        }
        if (!this.func.builtIn()) {
            String str = new String(this.func.name);
            str = String.valueOf(str) + "(" + this.terms[0].toString();
            int i = 1;
            while (i < this.terms.length) {
                str = String.valueOf(str) + ", " + this.terms[i].toString();
                ++i;
            }
            str = String.valueOf(str) + ")";
            return str;
        }
        String middle = new String("");
        switch (this.func.type) {
            case 770: {
                middle = "*";
                break;
            }
            case 771: {
                middle = "+";
                break;
            }
            case 773: {
                middle = " mod ";
                break;
            }
            case 774: {
                middle = "-";
                break;
            }
            default: {
                return this.termToGoal().toString();
            }
        }
        String str = new String("(" + this.terms[0].toString());
        str = String.valueOf(str) + middle;
        str = String.valueOf(str) + this.terms[1].toString() + ")";
        return str;
    }
}

