/*
 * Decompiled with CFR 0.152.
 */
package CIspace.prolog;

import CIspace.prolog.Goal;
import CIspace.prolog.Predicate;
import CIspace.prolog.Program;
import CIspace.prolog.StripsRule;
import java.util.StringTokenizer;
import java.util.Vector;

public class StripsProgram
extends Program {
    public Vector world = new Vector(5, 2);
    public Vector initWorld = new Vector(5, 2);

    public void reset() {
        super.reset();
        this.world = (Vector)this.initWorld.clone();
    }

    public Predicate predContains(String name, int arity) {
        int i = 0;
        while (i < this.predicates.size()) {
            Predicate p = (Predicate)this.predicates.elementAt(i);
            if (p.name.equals(name) && p.arity == arity) {
                return p;
            }
            ++i;
        }
        return null;
    }

    public String parse(String text) {
        String errorMessage = new String("");
        StringTokenizer tokenizer = new StringTokenizer(text, "\n");
        this.predicates = new Vector(5, 2);
        int lineCount = 0;
        try {
            while (tokenizer.hasMoreTokens()) {
                String inString = tokenizer.nextToken().trim();
                if (inString.length() <= 0 || inString.charAt(0) == '%') continue;
                while (inString.charAt(inString.length() - 1) != '.') {
                    if (!tokenizer.hasMoreTokens()) {
                        return "Unexpected end of file";
                    }
                    String nextString = tokenizer.nextToken();
                    inString = String.valueOf(inString) + nextString;
                }
                errorMessage = this.parseStripsRule(inString);
                ++lineCount;
                if (errorMessage.length() <= 0) continue;
                System.out.println(String.valueOf(errorMessage) + " at " + (lineCount + 1));
            }
            return errorMessage;
        }
        catch (Exception e) {
            if (errorMessage.length() > 0) {
                return "Error at rule " + (lineCount + 1) + " -- " + errorMessage;
            }
            return "Error at rule " + (lineCount + 1) + " -- " + e.toString();
        }
    }

    public String parseStripsRule(String str) {
        if (!Program.matchBrackets(str)) {
            return "Mismatched parentheses";
        }
        int i = str.indexOf("\n");
        Goal action = this.parseGoal(str.substring(0, i).trim());
        if (action == null) {
            return "Error parsing action";
        }
        Predicate p = action.getPredicate();
        Predicate old = this.predContains(p.getName(), p.getArity());
        if (old != null && !p.builtIn()) {
            action.pred = old;
        } else if (!p.builtIn()) {
            this.predicates.addElement(p);
        }
        int j = str.indexOf("\n", ++i);
        String precond = str.substring(i, j).trim();
        if (!precond.startsWith("preconditions")) {
            return "Missing preconditions";
        }
        int start = precond.indexOf("[");
        if (!Program.matchBrackets(precond) || start == -1) {
            return "Mismatched parentheses";
        }
        Vector preconditions = this.parseVector(precond.substring(start).trim());
        i = j + 1;
        String add = str.substring(i, j = str.indexOf("\n", i)).trim();
        if (!add.startsWith("add list")) {
            return "Missing add list";
        }
        start = add.indexOf("[");
        if (!Program.matchBrackets(add) || start == -1) {
            return "Mismatched parentheses";
        }
        Vector addList = this.parseVector(add.substring(start).trim());
        i = j + 1;
        String del = str.substring(i, j = str.indexOf("\n", i)).trim();
        if (!del.startsWith("delete list") || start == -1) {
            return "Missing delete list";
        }
        Vector deleteList = this.parseVector(del.substring(start).trim());
        StripsRule r = new StripsRule(action, preconditions, addList, deleteList);
        return "";
    }

    protected Vector parseVector(String str) {
        if (str.substring(1, str.length()).trim().equals("")) {
            return new Vector();
        }
        int nextComma = str.indexOf(",");
        Vector<Goal> v = new Vector<Goal>(5, 2);
        int last = 1;
        while (nextComma != -1) {
            int compound = str.indexOf("(");
            int builtIn = str.indexOf("=");
            int nextLeft = 0;
            if (builtIn == -1 || compound < builtIn && compound != -1) {
                nextLeft = Program.findNextRight(compound, str) + 1;
            } else if (compound == -1 || builtIn < compound && builtIn != -1) {
                nextLeft = nextComma;
            }
            if (nextLeft <= 0) {
                return null;
            }
            Goal g = this.parseGoal(str.substring(last, nextLeft));
            if (g == null) {
                return null;
            }
            Predicate p = g.getPredicate();
            Predicate old = this.predContains(p.getName(), p.getArity());
            if (old != null && !p.builtIn()) {
                g.pred = old;
            } else if (!p.builtIn()) {
                this.predicates.addElement(p);
            }
            v.addElement(g);
            last = nextLeft + 1;
            nextComma = str.indexOf(",", last);
        }
        Goal g = this.parseGoal(str.substring(last, str.length() - 1));
        if (g == null) {
            return null;
        }
        Predicate p = g.getPredicate();
        Predicate old = this.predContains(p.getName(), p.getArity());
        if (old != null && !p.builtIn()) {
            g.pred = old;
        } else if (!p.builtIn()) {
            this.predicates.addElement(p);
        }
        v.addElement(g);
        return v;
    }

    public String textRep() {
        String str = new String("");
        int i = 0;
        while (i < this.predicates.size()) {
            Predicate p = (Predicate)this.predicates.elementAt(i);
            Vector rules = p.rules;
            int j = 0;
            while (j < rules.size()) {
                StripsRule r = (StripsRule)rules.elementAt(j);
                str = String.valueOf(str) + r.toString();
                ++j;
            }
            ++i;
        }
        return str;
    }

    public boolean holds(Goal g) {
        int i = 0;
        while (i < this.world.size()) {
            if (g.equals((Goal)this.world.elementAt(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public Vector achieveGoal(Goal g, StripsRule r) {
        g.usedRules.addElement(r);
        Goal unified = g.unify(r.getAction(), this.occursCheck);
        if (unified != null) {
            Vector changes = r.applyUnification();
            Vector preconditions = (Vector)changes.elementAt(0);
            Vector addList = (Vector)changes.elementAt(1);
            Vector delList = (Vector)changes.elementAt(2);
            this.removeWorld(delList);
            this.addWorld(addList);
            Vector<Goal> subs = new Vector<Goal>(1);
            subs.addElement(r.action);
            g.substitutions = subs;
            return preconditions;
        }
        g.clearUnified();
        return null;
    }

    public void checkHolds(Vector v) {
        int i = v.size() - 1;
        while (i >= 0) {
            Goal g = (Goal)v.elementAt(i);
            if (this.holds(g)) {
                v.removeElement(g);
            }
            --i;
        }
    }

    public boolean canHold(Goal goal) {
        int i = 0;
        while (i < this.world.size()) {
            Goal g = (Goal)this.world.elementAt(i);
            Goal newGoal = goal.unify(g, this.occursCheck);
            if (newGoal != null) {
                return true;
            }
            g.clearUnified();
            goal.clearUnified();
            ++i;
        }
        return false;
    }

    private Goal pickGoal(Vector goals) {
        Goal g = (Goal)goals.elementAt(0);
        int i = 0;
        while (i < goals.size()) {
            g = (Goal)goals.elementAt(i);
            if (!g.pred.builtIn() || !g.needsDelaying() || this.canHold(g)) {
                return g;
            }
            ++i;
        }
        return g;
    }

    private void removeWorld(Vector v) {
        int i = 0;
        while (i < v.size()) {
            Goal g = (Goal)v.elementAt(i);
            Goal remove = this.findInWorld(g);
            if (remove != null) {
                this.world.removeElement(remove);
            }
            ++i;
        }
    }

    private void addWorld(Vector v) {
        int i = 0;
        while (i < v.size()) {
            this.world.addElement(v.elementAt(i));
            ++i;
        }
    }

    private Goal findInWorld(Goal g) {
        int i = 0;
        while (i < this.world.size()) {
            if (g.equals((Goal)this.world.elementAt(i))) {
                return (Goal)this.world.elementAt(i);
            }
            ++i;
        }
        return null;
    }
}

