/*
 * Decompiled with CFR 0.152.
 */
package CIspace.prolog;

import CIspace.prolog.Functor;
import CIspace.prolog.Predicate;
import CIspace.prolog.Rule;
import CIspace.prolog.Substitution;
import CIspace.prolog.Term;
import java.util.Vector;

public class Goal {
    protected Term[] terms;
    protected Predicate pred;
    public boolean neg = false;
    public Vector substitutions;
    public Vector extraSubs;
    public Vector usedRules;
    public Rule derivedFrom;

    public Goal(Predicate p) {
        this.pred = p;
        this.terms = new Term[p.getArity()];
        this.usedRules = new Vector(5, 2);
    }

    public Goal(Predicate p, Term[] newTerms) {
        this.pred = p;
        this.terms = newTerms;
        this.usedRules = new Vector(5, 2);
    }

    public Goal(String name, Term[] newTerms) {
        this.terms = newTerms;
        this.pred = new Predicate(name, newTerms.length);
        this.usedRules = new Vector(5, 2);
    }

    public Goal(int builtIn, Term[] newTerms) {
        this.pred = Predicate.getPred(builtIn);
        this.terms = newTerms;
        this.usedRules = new Vector(5, 2);
    }

    public Goal(Goal g) {
        this.pred = g.pred;
        this.terms = new Term[this.pred.getArity()];
        int i = 0;
        while (i < g.terms.length) {
            this.terms[i] = new Term(g.terms[i]);
            ++i;
        }
        this.usedRules = new Vector(5, 2);
        this.neg = g.neg;
    }

    protected Term goalToTerm() {
        if (this.pred.builtIn()) {
            Functor f = new Functor(this.pred.type);
            Term t = new Term(f, this.terms);
            return t;
        }
        Functor f = new Functor(this.pred.name, this.pred.arity);
        Term t = new Term(f, this.terms);
        return t;
    }

    public void reset() {
        this.usedRules = new Vector(5, 2);
    }

    public void setPredicate(Predicate p) {
        this.pred = p;
    }

    public Predicate getPredicate() {
        return this.pred;
    }

    public Vector getVariables() {
        Vector vars = new Vector(this.terms.length);
        int i = 0;
        while (i < this.terms.length) {
            int j = 0;
            while (j < this.terms[i].getVariables().size()) {
                vars.addElement(this.terms[i].getVariables().elementAt(j));
                ++j;
            }
            ++i;
        }
        return vars;
    }

    public Vector getUniqueVariables() {
        Vector vars = new Vector(this.terms.length);
        int i = 0;
        while (i < this.terms.length) {
            Vector temp = this.terms[i].getVariables();
            int j = 0;
            while (j < temp.size()) {
                if (!vars.contains((Term)temp.elementAt(j))) {
                    vars.addElement(temp.elementAt(j));
                }
                ++j;
            }
            ++i;
        }
        return vars;
    }

    public int putVariables(Vector v, int index) {
        int i = 0;
        while (i < this.terms.length) {
            if (this.terms[i].type != 2) {
                this.terms[i] = (Term)v.elementAt(index);
                ++index;
            } else {
                index = this.terms[i].putVariables(v, index);
            }
            ++i;
        }
        return index;
    }

    public Term[] getTerms() {
        return this.terms;
    }

    public Term[] copyTerms() {
        Term[] newTerms = new Term[this.terms.length];
        int i = 0;
        while (i < this.terms.length) {
            newTerms[i] = new Term(this.terms[i]);
            ++i;
        }
        return newTerms;
    }

    public Goal unify(Goal g, boolean occursCheck) {
        if (!g.pred.equals(this.pred)) {
            return null;
        }
        Term[] newTerms = new Term[this.pred.getArity()];
        int i = 0;
        while (i < this.terms.length) {
            Term newTerm = this.terms[i].lastUnified().unify(g.terms[i].lastUnified(), occursCheck);
            if (newTerm == null) {
                return null;
            }
            ++i;
        }
        i = 0;
        while (i < this.terms.length) {
            newTerms[i] = this.terms[i].lastUnified();
            ++i;
        }
        return new Goal(this.pred, newTerms);
    }

    public boolean needsDelaying() {
        int i;
        Vector vars;
        if (!this.pred.builtIn()) {
            return false;
        }
        if (this.pred.type != 556) {
            vars = this.terms[0].getVariables();
            i = 0;
            while (i < vars.size()) {
                if (((Term)vars.elementAt((int)i)).type == 0) {
                    return true;
                }
                ++i;
            }
        }
        vars = this.terms[1].getVariables();
        i = 0;
        while (i < vars.size()) {
            if (((Term)vars.elementAt((int)i)).type == 0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public Goal solve() {
        if (!this.pred.builtIn()) {
            return null;
        }
        if (this.pred.type == 555) {
            Term t1 = this.terms[0].lastUnified();
            Term t2 = this.terms[1].lastUnified();
            if (t1.type == 0 || t2.type == 0) {
                return null;
            }
            if (!t1.equals(t2)) {
                return this;
            }
            return null;
        }
        if (this.pred.type == 556) {
            Term t1 = this.terms[0].lastUnified();
            Integer ans = this.terms[1].solveArithmetic();
            if (ans == null) {
                return null;
            }
            int answer = ans;
            Term newTerm = t1.unify(new Term(String.valueOf(answer)), true);
            if (newTerm != null) {
                Goal newGoal = new Goal(this);
                newGoal.terms[0] = newTerm;
                return newGoal;
            }
            return null;
        }
        if (this.pred.type == 557) {
            Term t2;
            Term t1 = this.terms[0].lastUnified();
            if (t1.equals(t2 = this.terms[1].lastUnified())) {
                return this;
            }
            return null;
        }
        if (this.terms[0].type == 0 || this.terms[1].type == 0) {
            return new Goal(this);
        }
        Integer left1 = this.terms[0].solveArithmetic();
        Integer right1 = this.terms[1].solveArithmetic();
        if (left1 == null || right1 == null) {
            return null;
        }
        int left = left1;
        int right = right1;
        switch (this.pred.type) {
            case 550: {
                if (left > right) break;
                return this;
            }
            case 551: {
                if (left < right) break;
                return this;
            }
            case 552: {
                if (left >= right) break;
                return this;
            }
            case 553: {
                if (left <= right) break;
                return this;
            }
            case 554: {
                if (left == right) break;
                return this;
            }
            default: {
                return null;
            }
        }
        return null;
    }

    public Goal fixTerms() {
        Vector vars = this.getVariables();
        Vector<Term> newVars = new Vector<Term>(vars.size());
        int i = 0;
        while (i < vars.size()) {
            newVars.addElement(((Term)vars.elementAt(i)).lastUnified());
            ++i;
        }
        Goal g = new Goal(this.pred, this.copyTerms());
        g.putVariables(newVars, 0);
        g.derivedFrom = this.derivedFrom;
        g.neg = this.neg;
        return g;
    }

    public Goal fixTerms2() {
        Term[] newTerms = new Term[this.terms.length];
        int i = 0;
        while (i < this.terms.length) {
            newTerms[i] = this.terms[i].fixTerms2();
            ++i;
        }
        Goal g = new Goal(this.pred, newTerms);
        g.derivedFrom = this.derivedFrom;
        g.neg = this.neg;
        return g;
    }

    public Goal applySubs(Vector subs) {
        if (subs.size() == 0) {
            return new Goal(this.pred, this.copyTerms());
        }
        Vector<Term> newTerms = new Vector<Term>(this.getVariables().size());
        Vector vars = this.getVariables();
        int i = 0;
        while (i < vars.size()) {
            Term t = (Term)vars.elementAt(i);
            int j = 0;
            while (j < subs.size()) {
                Substitution s = (Substitution)subs.elementAt(j);
                if (s.first.name.equals(t.name)) {
                    t = Term.applySubs(s.second, subs);
                }
                ++j;
            }
            newTerms.addElement(t);
            ++i;
        }
        Goal g = new Goal(this.pred, this.copyTerms());
        g.putVariables(newTerms, 0);
        g.neg = this.neg;
        return g;
    }

    public Goal applySubs2(Vector subs) {
        if (subs.size() == 0) {
            return new Goal(this.pred, this.copyTerms());
        }
        Term[] newTerms = new Term[this.terms.length];
        int i = 0;
        while (i < this.terms.length) {
            newTerms[i] = this.terms[i].applySubs(subs, false);
            ++i;
        }
        Goal g = new Goal(this.pred, newTerms);
        g.neg = this.neg;
        return g;
    }

    public boolean isGround() {
        int i = 0;
        while (i < this.terms.length) {
            if (!this.terms[i].isGround()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void clearUnified() {
        int i = 0;
        while (i < this.terms.length) {
            this.terms[i].clearUnified();
            ++i;
        }
    }

    protected boolean equals(Goal g) {
        if (!g.pred.equals(this.pred)) {
            return false;
        }
        int i = 0;
        while (i < this.terms.length) {
            if (!this.terms[i].equals(g.terms[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String toString() {
        if (this.pred.builtIn()) {
            String middle;
            switch (this.pred.type) {
                case 550: {
                    middle = "=<";
                    break;
                }
                case 551: {
                    middle = ">=";
                    break;
                }
                case 552: {
                    middle = "<";
                    break;
                }
                case 553: {
                    middle = ">";
                    break;
                }
                case 554: {
                    middle = "=\\=";
                    break;
                }
                case 555: {
                    middle = "\\=";
                    break;
                }
                case 556: {
                    middle = " is ";
                    break;
                }
                case 557: {
                    middle = "=";
                    break;
                }
                default: {
                    middle = "";
                }
            }
            String str = new String(this.terms[0].toString());
            if (this.neg) {
                str = "~" + str;
            }
            str = String.valueOf(str) + middle;
            str = String.valueOf(str) + this.terms[1].toString();
            return str;
        }
        String str = new String(this.pred.name);
        if (this.neg) {
            str = "~" + str;
        }
        if (this.terms.length > 0) {
            str = String.valueOf(str) + "(";
            str = String.valueOf(str) + this.terms[0].toString();
            int i = 1;
            while (i < this.terms.length) {
                str = String.valueOf(str) + ", " + this.terms[i].toString();
                ++i;
            }
            str = String.valueOf(str) + ")";
        }
        return str;
    }
}

