/*
 * Decompiled with CFR 0.152.
 */
package CIspace.planning;

import CIspace.planning.Action;
import CIspace.planning.Atom;
import CIspace.planning.Predicate;
import CIspace.planning.Term;
import CIspace.planning.Variable;
import CIspace.planning.World;

public class WorldFactory {
    public static World makeBlockWorld() {
        World blockWorld = new World();
        WorldFactory.addBlockWorldActions(blockWorld);
        WorldFactory.addBlockWorldInitialStateItems(blockWorld);
        return blockWorld;
    }

    protected static void addBlockWorldActions(World blockWorld) {
        Action pickuptable = new Action("pickuptable", 1);
        Term t1 = new Term(new Variable("B1"));
        pickuptable.setTerm(0, t1);
        pickuptable.addPrecondition(WorldFactory.makeAtom("ontable", t1));
        pickuptable.addPrecondition(WorldFactory.makeAtom("clear", t1));
        pickuptable.addPrecondition(WorldFactory.makeAtom("empty"));
        pickuptable.addAddListItem(WorldFactory.makeAtom("holding", t1));
        pickuptable.addDeleteListItem(WorldFactory.makeAtom("empty"));
        pickuptable.addDeleteListItem(WorldFactory.makeAtom("ontable", t1));
        pickuptable.addDeleteListItem(WorldFactory.makeAtom("clear", t1));
        blockWorld.addAction(pickuptable);
        Action pickup = new Action("pickup", 2);
        t1 = new Term(new Variable("B1"));
        Term t2 = new Term(new Variable("B2"));
        pickup.setTerm(0, t1);
        pickup.setTerm(1, t2);
        pickup.addPrecondition(WorldFactory.makeAtom("on", t1, t2));
        pickup.addPrecondition(WorldFactory.makeAtom("clear", t1));
        pickup.addPrecondition(WorldFactory.makeAtom("empty"));
        pickup.addAddListItem(WorldFactory.makeAtom("holding", t1));
        pickup.addAddListItem(WorldFactory.makeAtom("clear", t2));
        pickup.addDeleteListItem(WorldFactory.makeAtom("empty"));
        pickup.addDeleteListItem(WorldFactory.makeAtom("on", t1, t2));
        pickup.addDeleteListItem(WorldFactory.makeAtom("clear", t1));
        blockWorld.addAction(pickup);
        Action putdowntable = new Action("putdowntable", 1);
        t1 = new Term(new Variable("B1"));
        putdowntable.setTerm(0, t1);
        putdowntable.addPrecondition(WorldFactory.makeAtom("holding", t1));
        putdowntable.addAddListItem(WorldFactory.makeAtom("empty"));
        putdowntable.addAddListItem(WorldFactory.makeAtom("ontable", t1));
        putdowntable.addAddListItem(WorldFactory.makeAtom("clear", t1));
        putdowntable.addDeleteListItem(WorldFactory.makeAtom("holding", t1));
        blockWorld.addAction(putdowntable);
        Action putdown = new Action("putdown", 2);
        t1 = new Term(new Variable("B1"));
        t2 = new Term(new Variable("B2"));
        putdown.setTerm(0, t1);
        putdown.setTerm(1, t2);
        putdown.addPrecondition(WorldFactory.makeAtom("clear", t2));
        putdown.addPrecondition(WorldFactory.makeAtom("holding", t1));
        putdown.addAddListItem(WorldFactory.makeAtom("empty"));
        putdown.addAddListItem(WorldFactory.makeAtom("on", t1, t2));
        putdown.addAddListItem(WorldFactory.makeAtom("clear", t1));
        putdown.addDeleteListItem(WorldFactory.makeAtom("clear", t2));
        putdown.addDeleteListItem(WorldFactory.makeAtom("holding", t1));
        blockWorld.addAction(putdown);
    }

    public static void addBlockWorldInitialStateItems(World blockWorld) {
        Atom empty = WorldFactory.makeAtom("empty");
        blockWorld.addStateItem(empty, 200);
        empty = WorldFactory.makeAtom("empty");
        blockWorld.addStateItem(empty, 201);
    }

    protected static Atom makeAtom(String predicateSymbol) {
        Predicate newPredicate = new Predicate(predicateSymbol, 0);
        return new Atom(newPredicate);
    }

    protected static Atom makeAtom(String predicateSymbol, Term t0) {
        Predicate newPredicate = new Predicate(predicateSymbol, 1);
        Atom newAtom = new Atom(newPredicate);
        newAtom.setTerm(0, t0);
        return newAtom;
    }

    protected static Atom makeAtom(String predicateSymbol, Term t0, Term t1) {
        Predicate newPredicate = new Predicate(predicateSymbol, 2);
        Atom newAtom = new Atom(newPredicate);
        newAtom.setTerm(0, t0);
        newAtom.setTerm(1, t1);
        return newAtom;
    }
}

