/*
 * Decompiled with CFR 0.152.
 */
package CIspace.planning;

import CIspace.planning.Action;
import CIspace.planning.Atom;
import CIspace.planning.DefiniteClause;
import CIspace.planning.Term;
import CIspace.planning.Variable;
import CIspace.planning.WorldFactory;
import CIspace.planning.WorldListener;
import java.util.Vector;

public class World {
    public static final int INITIAL_STATE = 200;
    public static final int GOALS = 201;
    public static final int CURRENT_STATE = 202;
    public static final int PLAN = 203;
    public static final int ACTIONS = 204;
    protected Vector initialState = new Vector();
    protected Vector currentState = new Vector();
    protected Vector goalState = new Vector();
    protected Vector plan;
    protected Vector actions = new Vector();
    protected Vector predicateSet;
    protected Vector constantSet;
    protected Vector listeners;
    protected boolean hasChanged;

    public World() {
        this.plan = new Vector();
        this.predicateSet = new Vector();
        this.constantSet = new Vector();
        this.listeners = new Vector();
    }

    public void addAction(Action newAction) {
        Atom currAtom;
        this.actions.addElement(newAction);
        Vector atomVector = newAction.getPreconditions();
        int i = 0;
        while (i < atomVector.size()) {
            currAtom = (Atom)atomVector.elementAt(i);
            this.addToSet(this.predicateSet, currAtom.getPredicate());
            ++i;
        }
        atomVector = newAction.getAddList();
        i = 0;
        while (i < atomVector.size()) {
            currAtom = (Atom)atomVector.elementAt(i);
            this.addToSet(this.predicateSet, currAtom.getPredicate());
            ++i;
        }
        atomVector = newAction.getDeleteList();
        i = 0;
        while (i < atomVector.size()) {
            currAtom = (Atom)atomVector.elementAt(i);
            this.addToSet(this.predicateSet, currAtom.getPredicate());
            ++i;
        }
    }

    public void addStateItem(DefiniteClause newDefiniteClause, int type) {
        if (type == 200) {
            this.initialState.addElement(newDefiniteClause);
        } else if (type == 201) {
            this.goalState.addElement(newDefiniteClause);
        } else if (type == 202) {
            this.currentState.addElement(newDefiniteClause);
        } else if (type == 203) {
            this.plan.addElement(newDefiniteClause);
        }
        this.hasChanged = true;
        this.notifyObservers();
    }

    public void removeStateItem(String removeDefiniteClause, int type) {
        String removeStr = removeDefiniteClause.toString();
        Vector stateVec = null;
        if (type == 200) {
            stateVec = this.initialState;
        } else if (type == 201) {
            stateVec = this.goalState;
        } else if (type == 202) {
            stateVec = this.currentState;
        }
        int i = 0;
        while (i < stateVec.size()) {
            DefiniteClause currClause = (DefiniteClause)stateVec.elementAt(i);
            if (removeStr.equals(currClause.toString())) {
                stateVec.removeElementAt(i);
            }
            ++i;
        }
        this.hasChanged = true;
        this.notifyObservers();
    }

    public void removeStateItem(DefiniteClause removeDefiniteClause, int type) {
        String removeStr = removeDefiniteClause.toString();
        this.removeStateItem(removeStr, type);
    }

    public void clearState(int type) {
        World emptyWorld = WorldFactory.makeBlockWorld();
        if (type == 200) {
            this.initialState = emptyWorld.initialState;
        } else if (type == 201) {
            this.goalState = emptyWorld.goalState;
        } else if (type == 202) {
            this.currentState = emptyWorld.currentState;
        } else if (type == 204) {
            this.actions = emptyWorld.actions;
        } else if (type == 203) {
            int i = this.plan.size() - 1;
            while (i >= 0) {
                this.plan.removeElementAt(i);
                --i;
            }
        }
        this.hasChanged = true;
        this.notifyObservers();
    }

    public void clearActions() {
        this.actions = new Vector();
    }

    protected void removeAllElements(Vector targetVector) {
        int i = targetVector.size() - 1;
        while (i >= 0) {
            targetVector.removeElementAt(i);
            --i;
        }
    }

    public void resetAllState() {
        this.clearState(200);
        this.clearState(201);
        this.clearState(202);
        this.clearState(203);
        this.clearState(204);
        this.hasChanged = true;
        this.notifyObservers();
    }

    public void clearAllState() {
        this.removeAllElements(this.initialState);
        this.removeAllElements(this.goalState);
        this.removeAllElements(this.currentState);
        this.removeAllElements(this.plan);
        this.hasChanged = true;
        this.notifyObservers();
    }

    protected void addToSet(Vector targetSet, Object newObject) {
        boolean duplicate = false;
        Object currObj = null;
        int i = 0;
        while (i < targetSet.size()) {
            currObj = targetSet.elementAt(i);
            if (currObj.toString().equals(newObject.toString())) {
                duplicate = true;
                break;
            }
            ++i;
        }
        if (!duplicate) {
            targetSet.addElement(newObject);
        }
    }

    public Vector getConstantSet() {
        Vector constSet = new Vector();
        int i = 0;
        while (i < this.initialState.size()) {
            DefiniteClause currClause = (DefiniteClause)this.initialState.elementAt(i);
            if (currClause.getClauseType() == 500) {
                int j = 0;
                while (j < ((Atom)currClause).getNumTerms()) {
                    Term currTerm = ((Atom)currClause).getTermAt(j);
                    if (currTerm.type == 100) {
                        this.addToSet(constSet, (Term)currTerm.clone());
                    }
                    ++j;
                }
            } else {
                System.out.println("Rule support required in world.getConstantSet()");
            }
            ++i;
        }
        return constSet;
    }

    public Action getActionByName(String name) {
        int i = 0;
        while (i < this.actions.size()) {
            Action currAction = (Action)this.actions.elementAt(i);
            if (name.equals(currAction.getName())) {
                return currAction;
            }
            ++i;
        }
        return null;
    }

    public void addListener(WorldListener newListener) {
        this.listeners.addElement(newListener);
    }

    public void removeListener(WorldListener oldListener) {
        int i = 0;
        while (i < this.listeners.size()) {
            WorldListener currListener = (WorldListener)this.listeners.elementAt(i);
            if (currListener == oldListener) {
                this.listeners.removeElementAt(i);
                return;
            }
            ++i;
        }
    }

    public void notifyObservers() {
        int i = 0;
        while (i < this.listeners.size()) {
            WorldListener currListener = (WorldListener)this.listeners.elementAt(i);
            if (currListener != null) {
                currListener.update();
            }
            ++i;
        }
    }

    public void resetCurrentState() {
        Vector variables = new Vector();
        this.currentState = new Vector();
        int i = 0;
        while (i < this.initialState.size()) {
            if (((DefiniteClause)this.initialState.elementAt(i)).getClauseType() == 501) {
                System.out.println("Support for rules required in world.resetCurrentState()");
                return;
            }
            this.currentState.addElement(((Atom)this.initialState.elementAt(i)).copy(variables));
            ++i;
        }
    }

    public Vector getInitialState() {
        return this.initialState;
    }

    public Vector getGoalState() {
        Vector<Atom> returnVector = new Vector<Atom>();
        Vector variables = new Vector();
        int i = 0;
        while (i < this.goalState.size()) {
            if (((DefiniteClause)this.goalState.elementAt(i)).getClauseType() == 501) {
                System.out.println("Support for rules required in world.resetCurrentState()");
                return null;
            }
            returnVector.addElement(((Atom)this.goalState.elementAt(i)).copy(variables));
            ++i;
        }
        return returnVector;
    }

    public Vector getGoalStateVector() {
        return this.goalState;
    }

    public Vector getCurrentState() {
        return this.currentState;
    }

    public Variable getGoalStateVariable(String varName) {
        int i = 0;
        while (i < this.goalState.size()) {
            DefiniteClause currClause = (DefiniteClause)this.goalState.elementAt(i);
            if (currClause.getClauseType() == 501) {
                System.out.println("Support for rules required in world.getGoalStateVariable()");
            }
            int j = 0;
            while (j < ((Atom)currClause).getNumTerms()) {
                Variable currVariable;
                Term currTerm = ((Atom)currClause).getTermAt(j);
                if (currTerm.getType() == 101 && (currVariable = currTerm.getVariable()).getVarName().equals(varName)) {
                    return currVariable;
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    public Vector getGoalStateVariableNames() {
        Vector<String> names = new Vector<String>();
        int i = 0;
        while (i < this.goalState.size()) {
            DefiniteClause currClause = (DefiniteClause)this.goalState.elementAt(i);
            if (currClause.getClauseType() == 501) {
                System.out.println("Support for rules required in world.getGoalStateVariable()");
            }
            int j = 0;
            while (j < ((Atom)currClause).getNumTerms()) {
                Term currTerm = ((Atom)currClause).getTermAt(j);
                if (currTerm.getType() == 101) {
                    Variable currVariable = currTerm.getVariable();
                    names.addElement(currVariable.getVarName());
                }
                ++j;
            }
            ++i;
        }
        return names;
    }

    public Vector getActions() {
        Vector<Action> returnVector = new Vector<Action>();
        int i = 0;
        while (i < this.actions.size()) {
            returnVector.addElement(((Action)this.actions.elementAt(i)).copy());
            ++i;
        }
        return returnVector;
    }

    public void removeLastPlanElement() {
        if (this.plan.size() > 0) {
            this.plan.removeElementAt(this.plan.size() - 1);
        }
        this.notifyObservers();
    }

    public String getInitialStateLogicXML(int numTabs) {
        return this.getStateLogicXML(this.initialState, numTabs);
    }

    public String getGoalStateLogicXML(int numTabs) {
        return this.getStateLogicXML(this.goalState, numTabs);
    }

    protected String getStateLogicXML(Vector stateVector, int numTabs) {
        StringBuffer output = new StringBuffer("");
        String indent = "";
        int i = 0;
        while (i < numTabs) {
            indent = String.valueOf(indent) + "\t";
            ++i;
        }
        if (stateVector.size() > 0) {
            output.append(String.valueOf(indent) + "<LogicProgram>\n");
            i = 0;
            while (i < stateVector.size()) {
                DefiniteClause currClause = (DefiniteClause)stateVector.elementAt(i);
                output.append(String.valueOf(indent) + "\t" + currClause + ".\n");
                ++i;
            }
            output.append(String.valueOf(indent) + "</LogicProgram>\n");
        }
        return output.toString();
    }

    public String getActionXML(int numTabs) {
        String output = "";
        String indent = "";
        int i = 0;
        while (i < numTabs) {
            indent = String.valueOf(indent) + "\t";
            ++i;
        }
        if (this.actions.size() > 0) {
            output = String.valueOf(output) + "\n\n" + indent + "<!-- STRIPS Actions -->\n";
            i = 0;
            while (i < this.actions.size()) {
                output = String.valueOf(output) + indent + "<Action>\n";
                Action currAction = (Action)this.actions.elementAt(i);
                String actionString = String.valueOf(currAction.getName()) + "(";
                int j = 0;
                while (j < currAction.getNumTerms()) {
                    actionString = String.valueOf(actionString) + currAction.getTermAt(j).toString();
                    if (j != currAction.getNumTerms() - 1) {
                        actionString = String.valueOf(actionString) + ",";
                    }
                    ++j;
                }
                actionString = String.valueOf(actionString) + ").";
                output = String.valueOf(output) + indent + "\t<LogicProgram>" + actionString + "</LogicProgram>\n";
                output = String.valueOf(output) + indent + "\t<Preconditions>\n";
                output = String.valueOf(output) + indent + "\t\t<LogicProgram>\n";
                Vector preconditions = currAction.getPreconditions();
                int j2 = 0;
                while (j2 < preconditions.size()) {
                    DefiniteClause currClause = (DefiniteClause)preconditions.elementAt(j2);
                    output = String.valueOf(output) + indent + "\t\t\t" + currClause.toString() + ".\n";
                    ++j2;
                }
                output = String.valueOf(output) + indent + "\t\t</LogicProgram>\n";
                output = String.valueOf(output) + indent + "\t</Preconditions>\n";
                output = String.valueOf(output) + indent + "\t<AddList>\n";
                output = String.valueOf(output) + indent + "\t\t<LogicProgram>\n";
                Vector addList = currAction.getAddList();
                int j3 = 0;
                while (j3 < addList.size()) {
                    DefiniteClause currClause = (DefiniteClause)addList.elementAt(j3);
                    output = String.valueOf(output) + indent + "\t\t\t" + currClause.toString() + ".\n";
                    ++j3;
                }
                output = String.valueOf(output) + indent + "\t\t</LogicProgram>\n";
                output = String.valueOf(output) + indent + "\t</AddList>\n";
                output = String.valueOf(output) + indent + "\t<DeleteList>\n";
                output = String.valueOf(output) + indent + "\t\t<LogicProgram>\n";
                Vector deleteList = currAction.getDeleteList();
                int j4 = 0;
                while (j4 < deleteList.size()) {
                    DefiniteClause currClause = (DefiniteClause)deleteList.elementAt(j4);
                    output = String.valueOf(output) + indent + "\t\t\t" + currClause.toString() + ".\n";
                    ++j4;
                }
                output = String.valueOf(output) + indent + "\t\t</LogicProgram>\n";
                output = String.valueOf(output) + indent + "\t</DeleteList>\n";
                output = String.valueOf(output) + indent + "</Action>\n";
                ++i;
            }
        }
        return output;
    }

    public Vector getActionsVector() {
        return this.actions;
    }

    public Vector getPredicateSet() {
        return this.predicateSet;
    }

    public boolean hasChanged() {
        return this.hasChanged;
    }

    public void setUnchanged() {
        this.hasChanged = false;
    }

    public void setChanged() {
        this.hasChanged = true;
    }

    public Vector getPlan() {
        return this.plan;
    }
}

