/*
 * Decompiled with CFR 0.152.
 */
package CIspace.planning;

import CIspace.graphToolKit.MessageDialog;
import CIspace.planning.DialogAdapter;
import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class VariableInputDialog
extends DialogAdapter {
    protected JTextField inputBox;
    protected String userInput;
    protected JFrame window;

    public VariableInputDialog(JFrame parent) {
        super(parent, "Input Variable Name", true);
        this.window = parent;
        this.userInput = "";
        this.constructDialog();
        this.pack();
        this.centerWindow();
        this.show();
        this.inputBox.requestFocus();
    }

    protected void constructDialog() {
        JPanel mainJPanel = new JPanel(new BorderLayout());
        mainJPanel.add("Center", this.makeInputJPanel());
        mainJPanel.add("South", this.makeButtonJPanel());
        this.getContentPane().add(mainJPanel);
    }

    protected JPanel makeInputJPanel() {
        JPanel inputJPanel = new JPanel();
        this.inputBox = new JTextField(10);
        inputJPanel.add(new JLabel("Enter variable name: "));
        inputJPanel.add(this.inputBox);
        return inputJPanel;
    }

    protected JPanel makeButtonJPanel() {
        JPanel buttonJPanel = new JPanel();
        JButton okButton = new JButton("Ok");
        okButton.addActionListener(this);
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(this);
        buttonJPanel.add(okButton);
        buttonJPanel.add(cancelButton);
        return buttonJPanel;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand() == "Ok") {
            this.validateInput();
        } else if (e.getActionCommand() == "Cancel") {
            this.hide();
        }
    }

    protected void validateInput() {
        if (this.inputBox.getText().length() == 0) {
            MessageDialog md = new MessageDialog(this.window);
            md.open("Invalid Variable", "Please enter a variable name");
            return;
        }
        String firstChar = this.inputBox.getText().substring(0, 1);
        if (firstChar.equals(firstChar.toLowerCase())) {
            MessageDialog md = new MessageDialog(this.window);
            md.open("Invalid Variable", "Variables must begin with a capital letter");
            return;
        }
        this.userInput = this.inputBox.getText();
        this.hide();
    }

    protected String getInput() {
        return this.userInput;
    }
}

