/*
 * Decompiled with CFR 0.152.
 */
package CIspace.planning;

import CIspace.planning.Constant;

public class Variable {
    protected String varName;
    protected boolean isBound;
    protected Constant binding;

    public Variable(String varName) {
        this.varName = varName;
        this.isBound = false;
        this.binding = null;
    }

    public boolean isBound() {
        return this.isBound;
    }

    public void bind(Constant constant) {
        this.binding = constant;
        this.isBound = constant != null;
    }

    public void unBind() {
        this.binding = null;
        this.isBound = false;
    }

    public String getVarName() {
        return this.varName;
    }

    public Constant getBinding() {
        return this.binding;
    }

    public String toString() {
        if (this.isBound) {
            return this.binding.toString();
        }
        return this.varName;
    }

    public Object clone() {
        Variable newVariable = new Variable(this.varName);
        newVariable.isBound = this.isBound;
        newVariable.binding = this.binding;
        return newVariable;
    }
}

