/*
 * Decompiled with CFR 0.152.
 */
package CIspace.planning;

import CIspace.planning.StripsEdge;
import CIspace.planning.StripsGraph;
import CIspace.planning.StripsNode;
import java.util.Vector;

public class SubtreePruner
extends Thread {
    protected static final int NUM_STEPS = 4;
    protected int currStep;
    protected boolean animate;
    protected StripsNode subtree;
    protected StripsGraph graph;

    public SubtreePruner(StripsNode subtree, StripsGraph graph, boolean animate) {
        this.subtree = subtree;
        this.graph = graph;
        this.currStep = 0;
        this.animate = animate;
        if (animate) {
            this.removeLabels(subtree);
        } else {
            this.prune(subtree);
        }
    }

    public void run() {
        int[] customDelay = new int[]{250, 250, 250, 400};
        if (this.animate) {
            while (this.currStep < 4) {
                try {
                    Thread.sleep(customDelay[this.currStep]);
                }
                catch (InterruptedException err) {
                    System.out.println(err);
                }
                this.fadeTree(this.subtree);
                this.graph.canvas.repaint();
                ++this.currStep;
            }
            this.prune(this.subtree);
        }
        this.graph.canvas.repaint();
    }

    protected void fadeTree(StripsNode subtree) {
        subtree.color = subtree.color.brighter();
        if (subtree.getEdgesIn().size() > 0) {
            ((StripsEdge)subtree.getEdgesIn().elementAt((int)0)).color = ((StripsEdge)subtree.getEdgesIn().elementAt((int)0)).color.brighter();
        }
        Vector children = subtree.getNeighbours();
        int i = 0;
        while (i < children.size()) {
            this.fadeTree((StripsNode)children.elementAt(i));
            ++i;
        }
    }

    protected void prune(StripsNode subtree) {
        Vector children = subtree.getNeighbours();
        int i = 0;
        while (i < children.size()) {
            this.prune((StripsNode)children.elementAt(i));
            ++i;
        }
        this.graph.deselectAll();
        this.graph.select(subtree);
        this.graph.deleteSelected();
    }

    protected void removeLabels(StripsNode subtree) {
        subtree.setValue(null);
        subtree.fail();
        subtree.setLabel(this.makeWhiteSpace(subtree.getLabel().length()));
        Vector children = subtree.getNeighbours();
        int i = 0;
        while (i < children.size()) {
            this.removeLabels((StripsNode)children.elementAt(i));
            ++i;
        }
    }

    protected String makeWhiteSpace(int numSpaces) {
        String space = "";
        while (space.length() < numSpaces) {
            space = String.valueOf(space) + " ";
        }
        return space;
    }
}

