/*
 * Decompiled with CFR 0.152.
 */
package CIspace.planning;

import CIspace.planning.DialogAdapter;
import CIspace.planning.StripsGraph;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class StripsOptionsDialog
extends DialogAdapter {
    protected JCheckBox loopDetection;
    protected JCheckBox autoGoalReordering;
    protected JCheckBox reachieveSubgoals;
    protected JCheckBox protectSubgoals;
    protected JCheckBox pruneFailedSubtrees;
    protected JCheckBox noProtection;
    protected ButtonGroup subgoalActionGroup;
    protected StripsGraph graph;

    public StripsOptionsDialog(JFrame parent, StripsGraph graph) {
        super(parent, "STRIPS Options", true);
        this.graph = graph;
        this.gbl = new GridBagLayout();
        this.gbc = new GridBagConstraints();
        this.gbc.anchor = 18;
        this.gbc.fill = 1;
        this.constructWindow();
        this.loadOptions();
        this.pack();
        this.centerWindow();
        this.show();
    }

    protected void constructWindow() {
        JPanel mainJPanel = new JPanel(new BorderLayout());
        mainJPanel.add("Center", this.makeOptionJPanel());
        mainJPanel.add("South", this.makeButtonJPanel());
        this.getContentPane().add(mainJPanel);
    }

    protected void open() {
        ((Component)this).setVisible(true);
    }

    protected JPanel makeOptionJPanel() {
        JPanel optionJPanel = new JPanel();
        this.subgoalActionGroup = new ButtonGroup();
        this.loopDetection = new JCheckBox("Loop Detection", true);
        this.autoGoalReordering = new JCheckBox("Goal Reordering");
        this.reachieveSubgoals = new JCheckBox("Reachieve subgoals that are undone", true);
        this.protectSubgoals = new JCheckBox("Protect subgoals so that they cannot be undone", false);
        this.noProtection = new JCheckBox("No subgoal protection", false);
        this.subgoalActionGroup.add(this.autoGoalReordering);
        this.subgoalActionGroup.add(this.reachieveSubgoals);
        this.subgoalActionGroup.add(this.protectSubgoals);
        this.subgoalActionGroup.add(this.noProtection);
        this.pruneFailedSubtrees = new JCheckBox("Prune failed action subtrees");
        this.gbc.anchor = 18;
        this.gbc.fill = 0;
        JPanel reachieveSubgoalsJPanel = new JPanel();
        reachieveSubgoalsJPanel.add(new JLabel("  "));
        reachieveSubgoalsJPanel.add(this.reachieveSubgoals);
        JPanel protectSubgoalsJPanel = new JPanel();
        protectSubgoalsJPanel.add(new JLabel("  "));
        protectSubgoalsJPanel.add(this.protectSubgoals);
        JPanel noProtectionJPanel = new JPanel();
        noProtectionJPanel.add(new JLabel("  "));
        noProtectionJPanel.add(this.noProtection);
        JPanel pruneFailedSubtreesJPanel = new JPanel();
        pruneFailedSubtreesJPanel.add(new JLabel("  "));
        pruneFailedSubtreesJPanel.add(this.pruneFailedSubtrees);
        this.addComponent(this.loopDetection, optionJPanel, 3, 0, 1, 1, 1.0, 1.0);
        this.addComponent(this.autoGoalReordering, optionJPanel, 4, 0, 1, 1, 1.0, 1.0);
        this.addComponent(new JLabel(""), optionJPanel, 5, 0, 1, 1, 1.0, 1.0);
        this.addComponent(new JLabel("Subgoal Protection:"), optionJPanel, 6, 0, 1, 1, 1.0, 1.0);
        this.addComponent(this.reachieveSubgoals, optionJPanel, 7, 0, 1, 1, 1.0, 1.0);
        this.addComponent(this.protectSubgoals, optionJPanel, 8, 0, 1, 1, 1.0, 1.0);
        this.addComponent(this.noProtection, optionJPanel, 9, 0, 1, 1, 1.0, 1.0);
        optionJPanel.setLayout(this.gbl);
        return optionJPanel;
    }

    protected JPanel makeButtonJPanel() {
        JPanel buttonJPanel = new JPanel();
        JButton okJButton = new JButton("Ok");
        okJButton.addActionListener(this);
        JButton cancelJButton = new JButton("Cancel");
        cancelJButton.addActionListener(this);
        buttonJPanel.add(okJButton);
        buttonJPanel.add(cancelJButton);
        return buttonJPanel;
    }

    protected void loadOptions() {
        int protectionAction = this.graph.getSubgoalProtectionAction();
        if (protectionAction == 201) {
            this.subgoalActionGroup.setSelected(this.reachieveSubgoals.getModel(), true);
        } else if (protectionAction == 200) {
            this.subgoalActionGroup.setSelected(this.protectSubgoals.getModel(), true);
        } else if (protectionAction == 202) {
            this.subgoalActionGroup.setSelected(this.noProtection.getModel(), true);
        }
        if (this.graph.loopDetectionEnabled()) {
            this.loopDetection.setEnabled(true);
        } else {
            this.loopDetection.setEnabled(false);
        }
        if (this.graph.pruneFailedSubtreesEnabled()) {
            this.pruneFailedSubtrees.setEnabled(true);
        } else {
            this.pruneFailedSubtrees.setEnabled(false);
        }
        if (this.graph.autoGoalReorderingEnabled()) {
            this.autoGoalReordering.setEnabled(true);
        } else {
            this.autoGoalReordering.setEnabled(false);
        }
    }

    protected void saveOptions() {
        if (this.reachieveSubgoals.isSelected()) {
            this.graph.setSubgoalProtectionAction(201);
        } else if (this.protectSubgoals.isSelected()) {
            this.graph.setSubgoalProtectionAction(200);
        } else if (this.noProtection.isSelected()) {
            this.graph.setSubgoalProtectionAction(202);
        }
        this.graph.enableLoopDetection(this.loopDetection.isSelected());
        this.graph.enableAutoGoalReordering(this.autoGoalReordering.isSelected());
        this.graph.enablePruneFailedSubtrees(this.pruneFailedSubtrees.isSelected());
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand() == "Ok") {
            this.saveOptions();
            ((Component)this).setVisible(false);
        } else if (e.getActionCommand() == "Cancel") {
            ((Component)this).setVisible(false);
        }
    }
}

