/*
 * Decompiled with CFR 0.152.
 */
package CIspace.planning;

import CIspace.graphToolKit.Node;
import CIspace.graphToolKit.Point;
import CIspace.planning.Action;
import CIspace.planning.Atom;
import CIspace.planning.DefiniteClause;
import CIspace.planning.PermutationGenerator;
import CIspace.planning.StripsEdge;
import CIspace.planning.StripsGraph;
import CIspace.planning.Substitution;
import CIspace.planning.SubtreePruner;
import CIspace.planning.Term;
import CIspace.planning.Variable;
import java.awt.Color;
import java.awt.Graphics;
import java.util.Vector;

public class StripsNode
extends Node {
    public static final int GOAL_NODE = 101;
    public static final int ACTION_NODE = 102;
    public static final int CLAUSE_FAILED = 200;
    public static final int SELECTED_CLAUSE = 201;
    public static final int UNATTEMPTED_CLAUSE = 202;
    protected int nodeType;
    protected Atom value;
    protected int screenWidth = 600;
    protected int branchWidth;
    protected Vector addList;
    protected Vector deleteList;
    protected Vector potentialActions;
    protected boolean goalActionsGenerated;
    protected StripsNode parent;
    protected boolean achieved;
    protected boolean failed;
    protected boolean finished;
    protected String goalString;
    protected Vector appliedClauses;
    protected Vector appliedClauseSubs;
    protected Vector appliedClauseStatus;
    protected boolean firstVisit;
    protected int currentAction;
    protected DefiniteClause clauseUnifiedWith;
    protected boolean[] isBoundInitially;
    protected int numActionsSoFar;
    protected PermutationGenerator permGen;
    protected int precondNum;

    public StripsNode(StripsGraph graph, int newNodeType) {
        super(graph);
        this.construct(newNodeType);
    }

    public StripsNode(StripsGraph graph, String label, Point pos, int newNodeType) {
        super(graph, label, pos, Color.blue, 1111);
        this.construct(newNodeType);
    }

    public void construct(int newNodeType) {
        this.nodeType = newNodeType;
        this.wPad = 10;
        this.hPad = 10;
        this.updateSize();
        this.setAppearance();
        this.failed = false;
        this.finished = false;
        this.achieved = false;
        this.firstVisit = true;
        this.currentAction = 0;
        this.numActionsSoFar = 0;
        this.precondNum = -1;
        this.goalActionsGenerated = false;
        this.value = null;
        this.color = StripsGraph.unachievedColor;
        this.setParent(null);
        this.potentialActions = new Vector();
        this.clauseUnifiedWith = null;
        this.goalString = "";
        this.appliedClauses = new Vector();
        this.appliedClauseSubs = new Vector();
        this.appliedClauseStatus = new Vector();
    }

    public void reset(boolean resetMore) {
        this.failed = false;
        this.achieved = false;
        this.finished = false;
        ((StripsEdge)this.edgesIn.elementAt(0)).setUnachieved();
        this.setAppearance();
        if (resetMore) {
            this.firstVisit = true;
            this.currentAction = 0;
            this.numActionsSoFar = 0;
            this.goalActionsGenerated = false;
            this.appliedClauses = new Vector();
            this.appliedClauseSubs = new Vector();
            this.appliedClauseStatus = new Vector();
        }
    }

    public void setNewChildren(Vector newChildren) {
        this.graph.deselectAll();
        int i = 0;
        while (i < this.edgesOut.size()) {
            StripsEdge edge = (StripsEdge)this.edgesOut.elementAt(i);
            this.graph.select(edge);
            this.graph.deleteSelected();
            ++i;
        }
        this.edgesOut = new Vector();
        i = 0;
        while (i < newChildren.size()) {
            StripsNode newChild = (StripsNode)newChildren.elementAt(i);
            StripsEdge newEdge = new StripsEdge((StripsGraph)this.graph, (Node)this, (Node)newChild);
            this.graph.addEdge(newEdge);
            newChild.reset(true);
            ++i;
        }
        this.repositionChildren();
    }

    public void initPermutationGenerator() {
        this.permGen = new PermutationGenerator(this.getNeighbours().size());
        this.permGen.getNext();
    }

    public int[] getNextPermutation() {
        return this.permGen.getNext();
    }

    public boolean hasMorePermutations() {
        return this.permGen.hasMore();
    }

    protected void setAppearance() {
        if (this.nodeType == 101) {
            this.shape = 1110;
        } else if (this.nodeType == 102) {
            this.shape = 1111;
        }
        if (this.finished) {
            this.color = StripsGraph.finishedColor;
            if (this.edgesIn.size() > 0) {
                ((StripsEdge)this.edgesIn.elementAt(0)).setType(200);
            }
        } else if (this.failed) {
            this.color = StripsGraph.failedColor;
            if (this.edgesIn.size() > 0) {
                ((StripsEdge)this.edgesIn.elementAt(0)).setType(201);
            }
        } else {
            if (this.edgesIn.size() > 0) {
                ((StripsEdge)this.edgesIn.elementAt(0)).setType(202);
            }
            this.color = this.achieved ? StripsGraph.achievedColor : StripsGraph.unachievedColor;
        }
    }

    public void repositionChildren() {
        Vector neighbours = this.getNeighbours();
        if (neighbours.size() == 0) {
            return;
        }
        if (neighbours.size() == 1) {
            StripsNode node = (StripsNode)neighbours.elementAt(0);
            node.pos.x = this.pos.x;
            node.updateSize();
            this.graph.updateNodeSize(node);
            node.repositionChildren();
        } else {
            int drawWidth = 0;
            if (!this.isAchieved() && !this.failed()) {
                this.setBranchWidth();
                drawWidth = Math.max(this.screenWidth, this.branchWidth);
                if (this.isRoot() && drawWidth > this.screenWidth) {
                    drawWidth = this.screenWidth;
                }
            } else {
                drawWidth = this.screenWidth;
            }
            float leftPosition = this.pos.x - (float)(drawWidth / 2);
            float rightPosition = this.pos.x + (float)(drawWidth / 2);
            float emptySpace = rightPosition - leftPosition - (float)drawWidth;
            float interval = emptySpace / (float)(neighbours.size() + 1);
            int currPos = (int)leftPosition;
            currPos += (int)interval;
            int i = 0;
            while (i < neighbours.size()) {
                StripsNode node = (StripsNode)neighbours.elementAt(i);
                node.pos = new Point(currPos + drawWidth / neighbours.size() / 2, node.pos.y);
                currPos += drawWidth / neighbours.size() + (int)interval;
                node.updateSize();
                this.graph.updateNodeSize(node);
                node.repositionChildren();
                ++i;
            }
        }
    }

    public void setBranchWidth() {
        Vector neighbours = this.getNeighbours();
        if (neighbours.size() == 0) {
            this.branchWidth = this.width;
            return;
        }
        this.branchWidth = 0;
        int i = 0;
        while (i < neighbours.size()) {
            StripsNode child = (StripsNode)neighbours.elementAt(i);
            this.branchWidth += child.width;
            ++i;
        }
    }

    public void draw(Graphics offscreen, boolean moving) {
        if (this.value != null) {
            this.setLabel(this.value.toString());
            this.updateSize();
        }
        this.xw = this == ((StripsGraph)this.graph).highlightedNode || this == ((StripsGraph)this.graph).violatedGoal || this == ((StripsGraph)this.graph).loopOriginalGoal || this == ((StripsGraph)this.graph).goalToReachieve ? 2 * (int)this.graph.getLineWidth() : 0;
        super.draw(offscreen, moving);
    }

    public int getBranchWidth() {
        return this.branchWidth;
    }

    public void setScreenWidth(int newWidth) {
        this.screenWidth = newWidth;
    }

    public int getScreenWidth() {
        return this.screenWidth;
    }

    public void setAchieved() {
        this.color = StripsGraph.achievedColor;
        if (this.nodeType == 102) {
            if (this.edgesIn.size() > 0) {
                ((StripsEdge)this.edgesIn.elementAt(0)).setAchieved();
                ((StripsEdge)this.edgesIn.elementAt((int)0)).color = StripsGraph.finishedColor;
            }
        } else if (this.edgesIn.size() > 0) {
            ((StripsEdge)this.edgesIn.elementAt(0)).setAchieved();
        }
        this.achieved = true;
    }

    public void pruneChildren() {
        Vector children = this.getNeighbours();
        int i = 0;
        while (i < children.size()) {
            StripsNode currChild = (StripsNode)children.elementAt(i);
            SubtreePruner pruner = new SubtreePruner(currChild, (StripsGraph)this.graph, true);
            pruner.start();
            ++i;
        }
    }

    protected Vector getAllDescendents() {
        Vector<StripsNode> v = new Vector<StripsNode>(5, 2);
        if (this.getNeighbours() != null && this.getNeighbours().size() > 0) {
            int i = 0;
            while (i < this.getNeighbours().size()) {
                StripsNode node = (StripsNode)this.getNeighbours().elementAt(i);
                v.addElement(node);
                ++i;
            }
        }
        return v;
    }

    public StripsEdge getEdgeIn() {
        if (this.edgesIn.size() > 0) {
            return (StripsEdge)this.edgesIn.elementAt(0);
        }
        return null;
    }

    public void unBind() {
        int i = 0;
        while (i < this.appliedClauseSubs.size()) {
            Substitution sub = (Substitution)this.appliedClauseSubs.elementAt(i);
            if (sub != null) {
                Vector variables = sub.getSubstitutions();
                int j = 0;
                while (j < variables.size()) {
                    Variable currVar = (Variable)variables.elementAt(j);
                    currVar.unBind();
                    ++j;
                }
            }
            ++i;
        }
    }

    public void setSelectedClauseSubstitution(Substitution substitution) {
        int i = 0;
        while (i < this.appliedClauseStatus.size()) {
            int status = (Integer)this.appliedClauseStatus.elementAt(i);
            if (status == 201) {
                this.appliedClauseSubs.setElementAt(substitution, i);
            }
            ++i;
        }
    }

    public boolean isFinished() {
        return this.finished;
    }

    public void setFinished() {
        this.finished = true;
        this.setAppearance();
    }

    public void setValue(Atom goal) {
        this.value = goal;
        if (goal != null && this.nodeType == 101) {
            this.goalString = goal.toString();
            this.isBoundInitially = new boolean[goal.getNumTerms()];
            int i = 0;
            while (i < goal.getNumTerms()) {
                Term currTerm = goal.getTermAt(i);
                if (currTerm.getType() == 101) {
                    this.isBoundInitially[i] = currTerm.getVariable().isBound();
                }
                ++i;
            }
        }
    }

    public Atom getValue() {
        return this.value;
    }

    public void initPrecondNums() {
        Vector children = this.getNeighbours();
        int i = 0;
        while (i < children.size()) {
            StripsNode currNode = (StripsNode)children.elementAt(i);
            currNode.setPrecondNum(i);
            ++i;
        }
    }

    public boolean isAchieved() {
        return this.achieved;
    }

    public int getType() {
        return this.nodeType;
    }

    public void fail() {
        this.failed = true;
        this.setAppearance();
    }

    public boolean failed() {
        return this.failed;
    }

    public void setAddList(Vector addList) {
        this.addList = addList;
    }

    public Vector getAddList() {
        return this.addList;
    }

    public void setDeleteList(Vector deleteList) {
        this.deleteList = deleteList;
    }

    public Vector getDeleteList() {
        return this.deleteList;
    }

    public void setParent(StripsNode parent) {
        this.parent = parent;
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public StripsNode getParent() {
        return this.parent;
    }

    public void setPotentialActions(Vector potentialActions) {
        this.potentialActions = potentialActions;
        this.goalActionsGenerated = true;
        this.currentAction = 0;
    }

    public Action getNextAction() {
        if (this.potentialActions == null || this.currentAction >= this.potentialActions.size()) {
            ++this.currentAction;
            return null;
        }
        Action nextAction = (Action)this.potentialActions.elementAt(this.currentAction);
        ++this.currentAction;
        return nextAction;
    }

    public Vector getPotentialActions() {
        return this.potentialActions;
    }

    public int getNextActionIndex() {
        return this.currentAction;
    }

    public boolean goalActionsGenerated() {
        return this.goalActionsGenerated;
    }

    public Vector getEdgesIn() {
        return this.edgesIn;
    }

    public void addAppliedClause(DefiniteClause clause, Substitution substitution, int status) {
        this.appliedClauses.addElement(clause);
        this.appliedClauseSubs.addElement(substitution);
        this.appliedClauseStatus.addElement(new Integer(status));
    }

    public DefiniteClause getNextClause() {
        int i = 0;
        while (i < this.appliedClauseStatus.size()) {
            int status = (Integer)this.appliedClauseStatus.elementAt(i);
            if (status != 200) {
                if (status == 201) {
                    this.appliedClauseStatus.setElementAt(new Integer(200), i);
                } else if (status == 202) {
                    this.appliedClauseStatus.setElementAt(new Integer(201), i);
                    return (DefiniteClause)this.appliedClauses.elementAt(i);
                }
            }
            ++i;
        }
        return null;
    }

    public void debugOutputClauses() {
        int i = 0;
        while (i < this.appliedClauses.size()) {
            DefiniteClause currClause = (DefiniteClause)this.appliedClauses.elementAt(i);
            System.out.println(currClause);
            ++i;
        }
    }

    public String getGoalString() {
        return this.goalString;
    }

    public int getNodeType() {
        return this.nodeType;
    }

    public Vector getAppliedClauses() {
        return this.appliedClauses;
    }

    public Vector getAppliedClauseSubs() {
        return this.appliedClauseSubs;
    }

    public Vector getAppliedClauseStatus() {
        return this.appliedClauseStatus;
    }

    public DefiniteClause getClauseUnifiedWith() {
        return this.clauseUnifiedWith;
    }

    public void setClauseUnifiedWith(DefiniteClause atom) {
        this.clauseUnifiedWith = atom;
    }

    public boolean[] getIsBoundInitially() {
        return this.isBoundInitially;
    }

    public boolean potentialClausesStored() {
        return this.appliedClauses.size() > 0;
    }

    public boolean hasMoreClausesToAttempt() {
        int i = 0;
        while (i < this.appliedClauseStatus.size()) {
            int status = (Integer)this.appliedClauseStatus.elementAt(i);
            if (status == 202) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean firstVisit() {
        boolean temp = this.firstVisit;
        this.firstVisit = true;
        return temp;
    }

    public void setNumActionsSoFar(int numActionsSoFar) {
        this.numActionsSoFar = numActionsSoFar;
    }

    public int getNumActionsSoFar() {
        return this.numActionsSoFar;
    }

    public void setPrecondNum(int precondNum) {
        this.precondNum = precondNum;
    }

    public int getPrecondNum() {
        return this.precondNum;
    }
}

