/*
 * Decompiled with CFR 0.152.
 */
package CIspace.planning;

import CIspace.graphToolKit.Graph;
import CIspace.graphToolKit.Node;
import CIspace.graphToolKit.Point;
import CIspace.planning.Action;
import CIspace.planning.Atom;
import CIspace.planning.DefiniteClause;
import CIspace.planning.Predicate;
import CIspace.planning.StripsCanvas;
import CIspace.planning.StripsEdge;
import CIspace.planning.StripsNode;
import CIspace.planning.Substitution;
import CIspace.planning.SubtreePruner;
import CIspace.planning.Term;
import CIspace.planning.World;
import java.awt.Color;
import java.awt.Graphics;
import java.util.Vector;

public class StripsGraph
extends Graph {
    protected static final Color achievedColor = Color.green;
    protected static final Color unachievedColor = Color.red.darker();
    protected static final Color finishedColor = Color.green.darker();
    protected static final Color failedColor = Color.darkGray;
    protected static final Color showViolationColor = Color.orange;
    protected static final int VERT_NODE_SPACE = 60;
    protected static final int HORIZ_SUBTREE_PAD = 5;
    protected static final int DEFAULT_ROOT_SCREEN_WIDTH = 600;
    protected static final int NORMAL_STEP = 100;
    protected static final int AFTER_PROTECTING_SUBGOAL_STEP = 101;
    protected static final int AFTER_LOOP_DETECTED_STEP = 102;
    protected static final int AFTER_ADDING_SUBGOAL_TO_REACHIEVE_STEP = 103;
    protected static final int PROTECT_SUBGOALS = 200;
    protected static final int REACHIEVE_SUBGOALS = 201;
    protected static final int NO_PROTECTION = 202;
    protected int protectionAction;
    protected int stepType;
    protected World world;
    protected Vector goals;
    protected StripsCanvas canvas;
    protected StripsNode root;
    protected StripsNode currentNode;
    protected StripsNode highlightedNode;
    protected StripsNode violatingAction;
    protected StripsNode violatedGoal;
    protected StripsNode loopOriginalGoal;
    protected StripsNode loopRepeatedGoal;
    protected StripsNode goalToReachieve;
    protected String failureMessage;
    protected boolean plannerFailed;
    protected boolean loopDetection;
    protected boolean reorderGoals;
    protected boolean pruneFailedSubtrees;

    public StripsGraph(StripsCanvas canvas, World world) {
        super(canvas);
        this.canvas = canvas;
        this.world = world;
        this.root = null;
        this.currentNode = null;
        this.plannerFailed = false;
        this.loopDetection = true;
        this.highlightedNode = null;
        this.stepType = 100;
        this.violatingAction = null;
        this.violatedGoal = null;
        this.loopOriginalGoal = null;
        this.loopRepeatedGoal = null;
        this.goalToReachieve = null;
        this.pruneFailedSubtrees = true;
        this.protectionAction = 201;
        this.reorderGoals = false;
        this.failureMessage = "";
    }

    public void initialize() {
        this.goals = this.world.getGoalState();
        this.removeAll();
        this.currentNode = null;
        this.plannerFailed = false;
        this.world.resetCurrentState();
        this.world.clearState(203);
        StripsNode root = new StripsNode(this, "Solved", new Point(0.0f, -200.0f), 102);
        root.setScreenWidth(600);
        this.addNode(root);
        this.root = root;
        int i = 0;
        while (i < this.goals.size()) {
            StripsNode currNode = new StripsNode(this, ((Atom)this.goals.elementAt(i)).toString(), new Point(0.0f, root.pos.y + 60.0f), 101);
            currNode.setScreenWidth(root.getScreenWidth() / this.goals.size() - 5);
            currNode.setValue((Atom)this.goals.elementAt(i));
            currNode.setParent(root);
            this.addNode(currNode);
            StripsEdge currEdge = new StripsEdge(this, (Node)root, (Node)currNode);
            this.addEdge(currEdge);
            ++i;
        }
        root.initPermutationGenerator();
        root.initPrecondNums();
        this.repositionNodes();
        this.stepType = 100;
        this.violatedGoal = null;
        this.violatingAction = null;
        this.loopOriginalGoal = null;
        this.loopRepeatedGoal = null;
        this.failureMessage = "";
        Vector rootChildren = root.getNeighbours();
        this.currentNode = rootChildren.size() > 0 ? (StripsNode)rootChildren.elementAt(0) : root;
        this.repaint();
    }

    public void initialize(int screenWidth) {
        this.goals = this.world.getGoalState();
        this.removeAll();
        this.currentNode = null;
        this.plannerFailed = false;
        this.world.resetCurrentState();
        this.world.clearState(203);
        StripsNode root = new StripsNode(this, "Solved", new Point(0.0f, -200.0f), 102);
        root.setScreenWidth(screenWidth);
        this.addNode(root);
        this.root = root;
        int i = 0;
        while (i < this.goals.size()) {
            StripsNode currNode = new StripsNode(this, ((Atom)this.goals.elementAt(i)).toString(), new Point(0.0f, root.pos.y + 60.0f), 101);
            currNode.setScreenWidth(root.getScreenWidth() / this.goals.size() - 5);
            currNode.setValue((Atom)this.goals.elementAt(i));
            currNode.setParent(root);
            this.addNode(currNode);
            StripsEdge currEdge = new StripsEdge(this, (Node)root, (Node)currNode);
            this.addEdge(currEdge);
            ++i;
        }
        root.initPermutationGenerator();
        root.initPrecondNums();
        this.repositionNodes();
        this.stepType = 100;
        this.violatedGoal = null;
        this.violatingAction = null;
        this.loopOriginalGoal = null;
        this.loopRepeatedGoal = null;
        this.failureMessage = "";
        Vector rootChildren = root.getNeighbours();
        this.currentNode = rootChildren.size() > 0 ? (StripsNode)rootChildren.elementAt(0) : root;
        this.repaint();
    }

    public void removeAll() {
        this.nodes = new Vector(10, 10);
        this.edges = new Vector(10, 10);
    }

    public void step() {
        if (this.plannerFinished()) {
            return;
        }
        if (this.stepType != 100) {
            this.performSpecialStep();
            return;
        }
        this.canvas.setPromptLabel("", false);
        if (this.currentNode.getType() == 101) {
            this.goalNodeStep();
        } else if (this.currentNode.getType() == 102) {
            this.actionNodeStep();
        }
    }

    protected void performSpecialStep() {
        if (this.stepType == 101) {
            this.backtrack(this.currentNode, false);
            this.violatedGoal.color = achievedColor;
            this.violatedGoal = null;
            this.currentNode = this.violatingAction.getParent();
            this.setSubtreeFailed(this.violatingAction);
            if (this.pruneFailedSubtrees) {
                SubtreePruner pruner = new SubtreePruner(this.violatingAction, this, true);
                pruner.start();
            }
            this.canvas.setPromptLabel("", false);
            this.stepType = 100;
        } else if (this.stepType == 102) {
            this.loopOriginalGoal.color = unachievedColor;
            this.loopRepeatedGoal.fail();
            this.loopOriginalGoal = null;
            this.loopRepeatedGoal = null;
            this.currentNode = this.currentNode.getParent();
            this.canvas.setPromptLabel("", false);
            this.stepType = 100;
        } else if (this.stepType == 103) {
            this.goalToReachieve.color = unachievedColor;
            this.violatedGoal.color = achievedColor;
            this.goalToReachieve = null;
            this.violatedGoal = null;
            this.canvas.setPromptLabel("", false);
            this.stepType = 100;
        } else {
            this.stepType = 100;
            this.step();
        }
    }

    protected void goalNodeStep() {
        Action action;
        Vector currState;
        if (this.currentNode.isAchieved() || this.currentNode.failed()) {
            this.currentNode = this.currentNode.getParent();
            return;
        }
        this.highlight(this.currentNode);
        Vector children = this.currentNode.getNeighbours();
        int i = 0;
        while (i < children.size()) {
            StripsNode currActionNode = (StripsNode)children.elementAt(i);
            if (currActionNode.isAchieved()) {
                this.currentNode.setAchieved();
                this.currentNode = this.currentNode.getParent();
                return;
            }
            ++i;
        }
        if (this.loopDetection && this.handleLoops(this.currentNode)) {
            this.canvas.setPromptLabel("Loop Detected", true);
            return;
        }
        if (children.size() == 0 && this.isTrue(this.currentNode, currState = this.world.getCurrentState())) {
            this.currentNode.setAchieved();
            this.currentNode = this.currentNode.getParent();
            return;
        }
        if (!this.currentNode.goalActionsGenerated()) {
            Vector actions = this.getAllPotentialActions(this.currentNode.getValue());
            this.currentNode.setPotentialActions(actions);
        }
        if ((action = this.currentNode.getNextAction()) == null) {
            this.currentNode.fail();
            this.currentNode = this.currentNode.getParent();
            return;
        }
        Atom newActionAtom = new Atom(new Predicate(action.getName(), action.getNumTerms()));
        int j = 0;
        while (j < action.getNumTerms()) {
            newActionAtom.setTerm(j, action.getTermAt(j));
            ++j;
        }
        this.currentNode = this.addActionToGraph(newActionAtom, this.currentNode, action.getPreconditions(), action.getAddList(), action.getDeleteList());
        this.root.repositionChildren();
    }

    protected void actionNodeStep() {
        boolean undoneGoalFound;
        if (this.currentNode.isAchieved()) {
            this.highlight(this.currentNode);
            this.currentNode = this.currentNode.getParent();
            return;
        }
        Vector precondNodes = this.currentNode.getNeighbours();
        int i = 0;
        while (i < precondNodes.size()) {
            StripsNode currPrecondNode = (StripsNode)precondNodes.elementAt(i);
            if (!currPrecondNode.isAchieved() && !currPrecondNode.failed()) {
                this.currentNode = currPrecondNode;
                this.step();
                return;
            }
            if (currPrecondNode.failed()) {
                if (this.otherBindingsExist(this.currentNode)) {
                    this.canvas.setPromptLabel("Selecting another clause...", false);
                    this.backtrack(this.currentNode, true);
                    this.currentNode = (StripsNode)precondNodes.elementAt(0);
                    this.highlight(this.currentNode);
                    return;
                }
                if (this.reorderGoals && this.currentNode.hasMorePermutations()) {
                    this.canvas.setPromptLabel("Selecting another goal ordering...", false);
                    this.backtrack(this.currentNode, true);
                    int[] perm = this.currentNode.getNextPermutation();
                    this.reorderGoals(this.currentNode, perm);
                    this.currentNode = (StripsNode)this.currentNode.getNeighbours().elementAt(0);
                    this.highlight(this.currentNode);
                    this.root.repositionChildren();
                    return;
                }
                this.currentNode.fail();
                this.backtrack(this.currentNode, false);
                if (!this.currentNode.isRoot()) {
                    StripsNode actionNode = this.currentNode;
                    this.currentNode = this.currentNode.getParent();
                    if (this.pruneFailedSubtrees) {
                        SubtreePruner pruner = new SubtreePruner(actionNode, this, true);
                        pruner.start();
                    }
                    return;
                }
                this.canvas.setPromptLabel("Failed to find a plan", false);
                this.plannerFailed = true;
                return;
            }
            ++i;
        }
        this.highlight(this.currentNode);
        if (this.protectionAction != 200 && (undoneGoalFound = this.checkForUndoneGoals(this.currentNode))) {
            if (this.protectionAction == 201) {
                boolean found = false;
                precondNodes = this.currentNode.getNeighbours();
                int i2 = 0;
                while (i2 < precondNodes.size()) {
                    StripsNode currPrecond = (StripsNode)precondNodes.elementAt(i2);
                    if (!currPrecond.failed() && !currPrecond.isAchieved()) {
                        this.currentNode = currPrecond;
                        found = true;
                    }
                    ++i2;
                }
                this.stepType = 103;
                this.goalToReachieve.color = showViolationColor;
                this.canvas.setPromptLabel(String.valueOf(this.goalToReachieve.getValue().toString()) + " has been undone and must be reachieved.", true);
                this.highlight(this.goalToReachieve);
                this.highlight(this.violatedGoal);
                if (!found) {
                    System.out.println("Error in actionNodeStep(): precondition to reachieve not found");
                }
                return;
            }
            if (this.protectionAction == 202) {
                this.violatedGoal.color = showViolationColor;
                this.plannerFailed = true;
                this.canvas.setPromptLabel(this.failureMessage, false);
                return;
            }
        }
        if (!this.currentNode.isRoot() && this.protectionAction == 200 && this.checkSubgoalProtectionViolations(this.currentNode)) {
            return;
        }
        if (this.currentNode.isRoot()) {
            this.currentNode.setAchieved();
            this.setSubtreeFinished(this.currentNode);
            this.canvas.repaint();
            this.canvas.setPromptLabel("Plan Complete", false);
            return;
        }
        Vector addList = this.currentNode.getAddList();
        Vector deleteList = this.currentNode.getDeleteList();
        int i3 = 0;
        while (i3 < addList.size()) {
            this.world.addStateItem((Atom)addList.elementAt(i3), 202);
            ++i3;
        }
        i3 = 0;
        while (i3 < deleteList.size()) {
            this.world.removeStateItem((Atom)deleteList.elementAt(i3), 202);
            ++i3;
        }
        this.world.addStateItem(this.currentNode.getValue(), 203);
        this.currentNode.setAchieved();
        this.setSubtreeFinished(this.currentNode);
        this.currentNode = this.currentNode.getParent();
    }

    protected void reorderGoals(StripsNode actionNode, int[] ordering) {
        Vector children = actionNode.getNeighbours();
        Vector<StripsNode> newChildVector = new Vector<StripsNode>();
        int i = 0;
        while (i < ordering.length) {
            int nextNodeIndex = ordering[i];
            int j = 0;
            while (j < children.size()) {
                StripsNode currChild = (StripsNode)children.elementAt(j);
                if (currChild.getPrecondNum() == nextNodeIndex) {
                    newChildVector.addElement(currChild);
                }
                ++j;
            }
            ++i;
        }
        actionNode.setNewChildren(newChildVector);
        this.root.repositionChildren();
    }

    protected void backtrack(StripsNode actionNode, boolean isForAnotherAttempt) {
        Vector children = actionNode.getNeighbours();
        int actionsSoFar = actionNode.getNumActionsSoFar();
        if (this.world.getPlan().size() > actionsSoFar) {
            this.undoActionsBelow(actionNode);
            this.canvas.notifyBacktrack();
        }
        int i = 0;
        while (i < children.size()) {
            StripsNode currChild = (StripsNode)children.elementAt(i);
            if (isForAnotherAttempt || this.pruneFailedSubtrees) {
                currChild.pruneChildren();
            }
            if (isForAnotherAttempt) {
                currChild.reset(false);
            }
            currChild.unBind();
            ++i;
        }
    }

    protected void undoActionsBelow(StripsNode node) {
        if (node.getNodeType() == 102 && node.isAchieved()) {
            Vector addList = node.getAddList();
            Vector deleteList = node.getDeleteList();
            int i = 0;
            while (i < addList.size()) {
                this.world.removeStateItem((Atom)addList.elementAt(i), 202);
                ++i;
            }
            i = 0;
            while (i < deleteList.size()) {
                this.world.addStateItem((Atom)deleteList.elementAt(i), 202);
                ++i;
            }
            this.world.removeLastPlanElement();
        }
        Vector children = node.getNeighbours();
        int i = children.size() - 1;
        while (i >= 0) {
            StripsNode currNode = (StripsNode)children.elementAt(i);
            this.undoActionsBelow(currNode);
            --i;
        }
    }

    protected boolean otherBindingsExist(StripsNode actionNode) {
        Vector children = actionNode.getNeighbours();
        int i = 0;
        while (i < children.size()) {
            StripsNode currChild = (StripsNode)children.elementAt(i);
            if (currChild.hasMoreClausesToAttempt()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected boolean checkSubgoalProtectionViolations(StripsNode actionNode) {
        Vector addList = actionNode.getAddList();
        Vector deleteList = actionNode.getDeleteList();
        int i = 0;
        while (i < this.nodes.size()) {
            StripsNode currNode = (StripsNode)this.nodes.elementAt(i);
            if (currNode.nodeType == 101 && currNode.isAchieved() && !currNode.isFinished() && !currNode.failed()) {
                Atom goalAtom = currNode.getValue();
                int j = 0;
                while (j < deleteList.size()) {
                    Atom currAtom = (Atom)deleteList.elementAt(j);
                    if (goalAtom.toString().equals(currAtom.toString())) {
                        boolean currActionPrecond = false;
                        Vector children = actionNode.getNeighbours();
                        int k = 0;
                        while (k < children.size()) {
                            StripsNode childNode = (StripsNode)children.elementAt(k);
                            if (childNode == currNode) {
                                currActionPrecond = true;
                                break;
                            }
                            ++k;
                        }
                        if (!currActionPrecond) {
                            this.canvas.setPromptLabel("Subgoal Protection Violation: " + actionNode.getLabel() + " would undo " + currNode.getValue().toString(), true);
                            currNode.color = showViolationColor;
                            actionNode.color = showViolationColor;
                            this.violatedGoal = currNode;
                            this.violatingAction = actionNode;
                            this.repaint();
                            this.stepType = 101;
                            return true;
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        return false;
    }

    protected boolean handleLoops(StripsNode goalNode) {
        StripsNode originalNode = this.getDuplicateOnPathToRoot(goalNode, this.currentNode.getParent());
        if (originalNode != null) {
            this.canvas.setPromptLabel("Loop Detected", true);
            this.loopOriginalGoal = originalNode;
            this.loopRepeatedGoal = goalNode;
            goalNode.color = showViolationColor;
            originalNode.color = showViolationColor;
            this.stepType = 102;
            return true;
        }
        return false;
    }

    protected boolean checkForUndoneGoals(StripsNode actionNode) {
        boolean undoneGoalFound = false;
        Vector children = actionNode.getNeighbours();
        if (actionNode.getType() == 102) {
            Vector currState = this.world.getCurrentState();
            int numChildren = children.size();
            int i = 0;
            while (i < numChildren) {
                StripsNode currChild = (StripsNode)children.elementAt(i);
                if (currChild.isAchieved() && !currChild.isFinished() && !this.search(currChild.getValue().toString(), currState)) {
                    undoneGoalFound = true;
                    this.violatedGoal = currChild;
                    if (this.protectionAction == 201) {
                        if (!this.unachievedCopyExists(currChild, actionNode.getNeighbours())) {
                            StripsNode newNode = new StripsNode(this, currChild.getValue().toString(), new Point(0.0f, actionNode.pos.y + 60.0f), 101);
                            newNode.setScreenWidth(actionNode.getScreenWidth() / children.size() - 5);
                            newNode.setValue(currChild.getValue());
                            newNode.setParent(actionNode);
                            this.addNode(newNode);
                            this.goalToReachieve = newNode;
                            StripsEdge newEdge = new StripsEdge(this, (Node)actionNode, (Node)newNode);
                            this.addEdge(newEdge);
                            this.root.repositionChildren();
                            actionNode.initPrecondNums();
                            actionNode.initPermutationGenerator();
                        }
                    } else if (this.protectionAction == 202) {
                        this.violatedGoal = currChild;
                        this.failureMessage = "Planner Failed, " + currChild.getValue() + " has been undone.";
                    }
                }
                ++i;
            }
        }
        return undoneGoalFound;
    }

    protected boolean unachievedCopyExists(StripsNode testNode, Vector nodeSet) {
        int i = 0;
        while (i < nodeSet.size()) {
            StripsNode currNode = (StripsNode)nodeSet.elementAt(i);
            if (currNode.getValue().toString().equals(testNode.getValue().toString()) && !currNode.isAchieved()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected StripsNode addActionToGraph(Atom actionAtom, StripsNode goalNode, Vector preconditions, Vector addList, Vector deleteList) {
        StripsNode actionNode = new StripsNode(this, actionAtom.toString(), new Point(goalNode.pos.x, goalNode.pos.y + 60.0f), 102);
        actionNode.setScreenWidth(goalNode.getScreenWidth());
        actionNode.setValue(actionAtom);
        actionNode.setParent(goalNode);
        actionNode.setAddList(addList);
        actionNode.setDeleteList(deleteList);
        actionNode.setNumActionsSoFar(this.world.getPlan().size());
        this.addNode(actionNode);
        StripsEdge newEdge = new StripsEdge(this, (Node)goalNode, (Node)actionNode);
        this.addEdge(newEdge);
        int i = 0;
        while (i < preconditions.size()) {
            Atom currPrecond = (Atom)preconditions.elementAt(i);
            StripsNode precondNode = new StripsNode(this, currPrecond.toString(), new Point(actionNode.pos.x, actionNode.pos.y + 60.0f), 101);
            precondNode.setScreenWidth(actionNode.getScreenWidth() / preconditions.size() - 5);
            precondNode.setValue(currPrecond);
            precondNode.setParent(actionNode);
            this.addNode(precondNode);
            StripsEdge currEdge = new StripsEdge(this, (Node)actionNode, (Node)precondNode);
            this.addEdge(currEdge);
            ++i;
        }
        actionNode.initPermutationGenerator();
        actionNode.initPrecondNums();
        return actionNode;
    }

    protected Vector getAllPotentialActions(Atom goal) {
        Vector<Action> potentialActions = new Vector<Action>();
        Vector actions = this.world.getActions();
        int i = 0;
        while (i < actions.size()) {
            Atom addListItem;
            Action currAction = (Action)actions.elementAt(i);
            Vector currAddList = currAction.getAddList();
            int addListIndex = this.canAchieve(currAction, goal);
            if (addListIndex != -1 && this.resolves(goal, addListItem = (Atom)currAddList.elementAt(addListIndex))) {
                potentialActions.addElement(currAction);
            }
            ++i;
        }
        return potentialActions;
    }

    protected int canAchieve(Action action, Atom goal) {
        Vector addList = action.getAddList();
        int i = 0;
        while (i < addList.size()) {
            Atom addAtom = (Atom)addList.elementAt(i);
            if (addAtom.getPredicate().getPredicateSymbol().equals(goal.getPredicate().getPredicateSymbol())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected StripsNode getDuplicateOnPathToRoot(StripsNode searchNode, StripsNode currNode) {
        if (currNode.isRoot()) {
            return null;
        }
        if (currNode.getValue().toString().equals(searchNode.getValue().toString())) {
            return currNode;
        }
        return this.getDuplicateOnPathToRoot(searchNode, currNode.getParent());
    }

    protected void setSubtreeFinished(StripsNode tree) {
        tree.setFinished();
        Vector children = tree.getNeighbours();
        int i = 0;
        while (i < children.size()) {
            this.setSubtreeFinished((StripsNode)children.elementAt(i));
            ++i;
        }
    }

    protected void setSubtreeFailed(StripsNode tree) {
        tree.fail();
        Vector children = tree.getNeighbours();
        int i = 0;
        while (i < children.size()) {
            this.setSubtreeFailed((StripsNode)children.elementAt(i));
            ++i;
        }
    }

    public void repositionNodes() {
        try {
            this.root.setScreenWidth(Math.max(600, this.canvas.getScrollWidth()));
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.root.repositionChildren();
    }

    public void bringToForeground(StripsNode node) {
        int i = 0;
        while (i < this.nodes.size()) {
            StripsNode currNode = (StripsNode)this.nodes.elementAt(i);
            if (currNode == node) {
                this.nodes.removeElementAt(i);
                this.nodes.insertElementAt(currNode, 0);
                return;
            }
            ++i;
        }
    }

    public boolean plannerFinished() {
        return this.root.isAchieved() || this.plannerFailed;
    }

    public boolean planFound() {
        return this.root.isAchieved();
    }

    protected void highlight(StripsNode node) {
        this.bringToForeground(node);
        this.highlightedNode = node;
    }

    public int getSubgoalProtectionAction() {
        return this.protectionAction;
    }

    public void setSubgoalProtectionAction(int action) {
        this.protectionAction = action;
    }

    public boolean loopDetectionEnabled() {
        return this.loopDetection;
    }

    public void enableLoopDetection(boolean on) {
        this.loopDetection = on;
    }

    public boolean autoGoalReorderingEnabled() {
        return this.reorderGoals;
    }

    public void enableAutoGoalReordering(boolean on) {
        this.reorderGoals = on;
    }

    public boolean pruneFailedSubtreesEnabled() {
        return this.pruneFailedSubtrees;
    }

    public void enablePruneFailedSubtrees(boolean on) {
        this.pruneFailedSubtrees = on;
    }

    protected boolean resolves(Atom atom1, Atom atom2) {
        Vector<Atom> knowledgeBase = new Vector<Atom>();
        knowledgeBase.addElement(atom1);
        return this.isTrueAtoms(atom2, knowledgeBase);
    }

    protected boolean isTrueAtoms(Atom goal, Vector knowledgeBase) {
        DefiniteClause matchingClause = this.findClause(goal, knowledgeBase);
        if (matchingClause != null) {
            return true;
        }
        int i = 0;
        while (i < knowledgeBase.size()) {
            Atom currAtom = (Atom)knowledgeBase.elementAt(i);
            if (currAtom.getPredicate().equals(goal.getPredicate())) {
                Term currGoalTerm;
                boolean failure = false;
                int j = 0;
                while (j < goal.getNumTerms()) {
                    currGoalTerm = goal.getTermAt(j);
                    if ((currGoalTerm.type == 100 || currGoalTerm.type == 101 && currGoalTerm.getVariable().isBound()) && !currGoalTerm.equals(currAtom.getTermAt(j))) {
                        failure = true;
                        break;
                    }
                    ++j;
                }
                if (!failure) {
                    j = 0;
                    while (j < goal.getNumTerms()) {
                        currGoalTerm = goal.getTermAt(j);
                        if (currGoalTerm.type == 101 && !currGoalTerm.getVariable().isBound()) {
                            Term currKBatomTerm = currAtom.getTermAt(j);
                            if (currKBatomTerm.type == 100) {
                                currGoalTerm.getVariable().bind(currKBatomTerm.getConstant());
                            } else {
                                currGoalTerm.getVariable().bind(currKBatomTerm.getVariable().getBinding());
                            }
                        }
                        ++j;
                    }
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    protected boolean isTrue(StripsNode goalNode, Vector knowledgeBase) {
        Atom clause;
        Atom goal = goalNode.getValue();
        DefiniteClause matchingClause = this.findClause(goal, knowledgeBase);
        if (matchingClause != null) {
            goalNode.setClauseUnifiedWith(matchingClause);
            return true;
        }
        if (!goalNode.potentialClausesStored()) {
            int i = 0;
            while (i < knowledgeBase.size()) {
                Atom currAtom = (Atom)knowledgeBase.elementAt(i);
                if (currAtom.getPredicate().equals(goal.getPredicate())) {
                    boolean failure = false;
                    int j = 0;
                    while (j < goal.getNumTerms()) {
                        Term currGoalTerm = goal.getTermAt(j);
                        if ((currGoalTerm.type == 100 || currGoalTerm.type == 101 && currGoalTerm.getVariable().isBound()) && !currGoalTerm.equals(currAtom.getTermAt(j))) {
                            failure = true;
                            break;
                        }
                        ++j;
                    }
                    if (!failure) {
                        Substitution subs = new Substitution();
                        goalNode.addAppliedClause(currAtom, subs, 202);
                    }
                }
                ++i;
            }
        }
        if ((clause = (Atom)goalNode.getNextClause()) == null) {
            return false;
        }
        Substitution substitution = this.unify(goal, clause);
        goalNode.setSelectedClauseSubstitution(substitution);
        return true;
    }

    protected Substitution unify(Atom goal, Atom kbClause) {
        Substitution subs = new Substitution();
        int j = 0;
        while (j < goal.getNumTerms()) {
            Term currGoalTerm = goal.getTermAt(j);
            if (currGoalTerm.type == 101 && !currGoalTerm.getVariable().isBound()) {
                Term currKBatomTerm = kbClause.getTermAt(j);
                if (currKBatomTerm.type == 100) {
                    currGoalTerm.getVariable().bind(currKBatomTerm.getConstant());
                } else {
                    currGoalTerm.getVariable().bind(currKBatomTerm.getVariable().getBinding());
                }
                subs.addSubstitution(currGoalTerm.getVariable());
            }
            ++j;
        }
        return subs;
    }

    protected boolean search(String value, Vector searchVector) {
        int i = 0;
        while (i < searchVector.size()) {
            if (value.equals(((Atom)searchVector.elementAt(i)).toString())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected DefiniteClause findClause(DefiniteClause clause, Vector KB) {
        int i = 0;
        while (i < KB.size()) {
            DefiniteClause currKBclause = (DefiniteClause)KB.elementAt(i);
            if (clause.toString().equals(currKBclause.toString())) {
                return currKBclause;
            }
            ++i;
        }
        return null;
    }

    public void draw(Graphics g, boolean moving) {
        int i = this.numEdges() - 1;
        while (i >= 0) {
            this.edgeAt(i).draw(g, moving);
            --i;
        }
        i = this.numEdges() - 1;
        while (i >= 0) {
            this.edgeAt((int)i).eLabel.draw(g, moving);
            --i;
        }
        i = this.numNodes() - 1;
        while (i >= 0) {
            this.nodeAt(i).draw(g, moving);
            --i;
        }
    }
}

