/*
 * Decompiled with CFR 0.152.
 */
package CIspace.planning;

import CIspace.graphToolKit.Edge;
import CIspace.graphToolKit.Node;
import CIspace.planning.StripsGraph;
import java.awt.Color;

public class StripsEdge
extends Edge {
    public static final int FINISHED_EDGE = 200;
    public static final int FAILED_EDGE = 201;
    public static final int NOT_FINISHED_EDGE = 202;
    protected boolean isAchieved;
    protected int edgeType;

    public StripsEdge(StripsGraph stripsGraph) {
        super(stripsGraph);
        this.construct();
    }

    public StripsEdge(StripsGraph stripsGraph, Node start, Node end) {
        super(stripsGraph, "", start, end, StripsGraph.unachievedColor, 5550);
        this.construct();
    }

    public StripsEdge(StripsGraph stripsGraph, String label, Node start, Node end, Color color, int edgeType) {
        super(stripsGraph, label, start, end, color, edgeType);
        this.construct();
    }

    protected void construct() {
        this.isAchieved = false;
        this.edgeType = 202;
    }

    public void setAchieved() {
        if (this.edgeType == 200) {
            this.color = StripsGraph.achievedColor;
            this.color = StripsGraph.finishedColor;
        } else {
            this.color = StripsGraph.achievedColor;
        }
        this.isAchieved = true;
    }

    public boolean isAchieved() {
        return this.isAchieved;
    }

    public void setUnachieved() {
        this.isAchieved = false;
    }

    public int getType() {
        return this.edgeType;
    }

    public void setType(int newEdgeType) {
        this.edgeType = newEdgeType;
        this.color = this.edgeType == 200 ? StripsGraph.finishedColor : (this.edgeType == 201 ? StripsGraph.failedColor : (this.isAchieved ? StripsGraph.achievedColor : StripsGraph.unachievedColor));
    }
}

