/*
 * Decompiled with CFR 0.152.
 */
package CIspace.planning;

import CIspace.graphToolKit.Entity;
import CIspace.graphToolKit.GraphWindow;
import CIspace.graphToolKit.Point;
import CIspace.planning.NodeInfoDialog;
import CIspace.planning.PlannerCanvas;
import CIspace.planning.PlanningWindow;
import CIspace.planning.StripsGraph;
import CIspace.planning.StripsNode;
import CIspace.planning.StripsOptionsDialog;
import CIspace.planning.World;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public class StripsCanvas
extends PlannerCanvas {
    private StripsOptionsDialog optionsDialog;
    JMenuItem step;
    StripsGraph stripsGraph;
    PlanningWindow window;
    public static final int C_SELECT_MOVE_SUBTREE = 3340;
    public static final int C_MOVE_SUBTREE = 3341;

    public StripsCanvas(JFrame parent, boolean inline, World world) {
        super(parent, inline, world);
        this.graph = new StripsGraph(this, world);
        this.stripsGraph = (StripsGraph)this.graph;
        this.window = (PlanningWindow)parent;
        this.initialize();
    }

    public void initialize() {
        this.stripsGraph.initialize();
        this.repaint();
    }

    public void initialize(int screenWidth) {
        this.stripsGraph.initialize(screenWidth);
        this.step = new JMenuItem("Step");
        this.step.addActionListener(this.window);
        this.repaint();
    }

    public int getScrollWidth() {
        return ((PlanningWindow)this.parent).scrollPanel.getWidth();
    }

    public void step() {
        this.stripsGraph.step();
        this.repaint();
    }

    public void setPromptLabel(String label, boolean highlightBackground) {
        if (highlightBackground) {
            this.window.setPromptLabelBackground(Color.orange);
        } else {
            this.window.setPromptLabelBackground(Color.white);
        }
        this.window.setPromptLabelColorBack(label);
    }

    public void openOptionsDialog() {
        if (this.optionsDialog != null) {
            this.optionsDialog.open();
        } else {
            this.optionsDialog = new StripsOptionsDialog((JFrame)this.window, this.stripsGraph);
        }
    }

    public int print(Graphics g, PageFormat pf, int pi) throws PrinterException {
        if (pi >= 1) {
            return 1;
        }
        this.graphScale = this.graph.getScale();
        Point[] bounds = this.graph.getBound();
        Point min = bounds[0];
        Point max = bounds[1];
        float midX = Math.abs(max.x - min.x) / 2.0f;
        float midY = Math.abs(max.y - min.y) / 2.0f;
        this.graphPoint = new Point(midX += min.x, midY += min.y);
        this.zoomForPrinting();
        this.drawPrint((Graphics2D)g);
        this.graph.setScale(this.graphScale);
        this.moveGraphToPoint(this.graphPoint);
        return 0;
    }

    public boolean autoSolveContinue() {
        return !this.stripsGraph.plannerFinished();
    }

    public void moveToTopMiddle() {
        Point[] bounds = this.graph.getBound();
        Point min = bounds[0];
        Point max = bounds[1];
        if (min.equals(0.0f, 0.0f) || max.equals(0.0f, 0.0f)) {
            return;
        }
        float midX = Math.abs(max.x - min.x) / 2.0f;
        float midY = Math.abs(max.y - min.y) / 2.0f;
        float middleX = ((GraphWindow)this.parent).scrollPanel.getHorizontalScrollBar().getValue() + ((GraphWindow)this.parent).scrollPanel.getWidth() / 2;
        float middleY = ((GraphWindow)this.parent).scrollPanel.getVerticalScrollBar().getValue() + ((GraphWindow)this.parent).scrollPanel.getHeight() / 2;
        float dx = Math.abs(middleX - (midX += min.x));
        float dy = Math.abs(middleY - (midY += min.y) - 200.0f);
        this.graph.translateAll(dx, dy);
    }

    protected void mMoved(MouseEvent e) {
        super.mMoved(e);
        if (this.hover != null && this.hover.type == 7770) {
            this.stripsGraph.bringToForeground((StripsNode)this.hover);
        }
    }

    public void componentResized(ComponentEvent e) {
        this.stripsGraph.repositionNodes();
    }

    protected void popupCanvas(int x, int y) {
        JCheckBoxMenuItem pan;
        JCheckBoxMenuItem zoom;
        this.pop.setBorder(BorderFactory.createTitledBorder("Solve Options"));
        this.pop.removeAll();
        this.step = new JMenuItem("Step");
        this.step.addActionListener(this.window);
        this.pop.add(this.step);
        JMenuItem mItemAuto = this.newJMenuItem("Auto Search", this.window);
        JMenuItem mItemStop = this.newJMenuItem("Stop", this.window);
        if (this.window.autoSolve != null) {
            this.step.setEnabled(false);
            mItemAuto.setEnabled(false);
            mItemStop.setEnabled(true);
        } else {
            this.step.setEnabled(true);
            mItemAuto.setEnabled(true);
            mItemStop.setEnabled(false);
        }
        this.pop.add(mItemAuto);
        this.pop.add(mItemStop);
        this.pop.add(this.newJMenuItem("Reset Graph", this.window));
        this.pop.add(this.newJMenuItem("View Current State", this.window));
        this.pop.add(this.newJMenuItem("View Current Plan", this.window));
        this.pop.add(this.newJMenuItem("Run Plan", this.window));
        this.pop.addSeparator();
        this.pop.add(new JLabel("View Options"));
        this.pop.add(this.newJMenuItem("Autoscale", this.window));
        JMenu zp = new JMenu("Pan/Zoom");
        ButtonGroup zpGroup = new ButtonGroup();
        if (this.getRMode() == 4441) {
            zoom = new JCheckBoxMenuItem("Zoom", true);
            pan = new JCheckBoxMenuItem("Pan", false);
        } else {
            zoom = new JCheckBoxMenuItem("Zoom", false);
            pan = new JCheckBoxMenuItem("Pan", true);
        }
        zoom.setToolTipText("Zoom into certain area of graph");
        zoom.addActionListener(this.window);
        zpGroup.add(zoom);
        zp.add(zoom);
        pan.setToolTipText("Pan the graph to a different area on the canvas");
        pan.addActionListener(this.window);
        zp.add(pan);
        zpGroup.add(pan);
        this.pop.add(zp);
        this.pop.show(this, x, y);
    }

    protected void popupNode(int x, int y) {
        this.pop.setLabel("Node Options");
        this.pop.removeAll();
        this.pop.add(this.newJMenuItem("Inspect Node"));
        this.pop.show(this, x, y);
    }

    protected void popupEdge(int x, int y) {
        this.popupCanvas(x, y);
    }

    public void actionPerformed(ActionEvent e) {
        String arg = e.getActionCommand();
        StripsNode node = (StripsNode)this.entClicked;
        if (arg.equals("Inspect Node")) {
            this.inspect(node);
        } else {
            arg.equals("");
        }
    }

    protected void inspect(StripsNode node) {
        int nodeType = node.getNodeType();
        new NodeInfoDialog((JFrame)this.window, node);
    }

    public Entity mClicked(MouseEvent e, boolean ctrlDown) {
        Entity ent = super.mClicked(e, ctrlDown);
        if (ent != null && ent.type == 7770 && e.getModifiers() != 4) {
            this.pause();
            StripsNode clickedNode = (StripsNode)ent;
            this.inspect(clickedNode);
            this.unpause();
        }
        return ent;
    }

    public void notifyBacktrack() {
        this.window.notifyBacktrack();
    }

    private JMenuItem newJMenuItem(String label) {
        JMenuItem mItem = new JMenuItem(label);
        mItem.addActionListener(this);
        return mItem;
    }

    private JMenuItem newJMenuItem(String label, String actionCommand, ActionListener listener) {
        JMenuItem mItem = new JMenuItem(label);
        mItem.setActionCommand(actionCommand);
        mItem.addActionListener(listener);
        return mItem;
    }

    private JMenuItem newJMenuItem(String label, ActionListener listener) {
        JMenuItem mItem = new JMenuItem(label);
        mItem.setActionCommand(label);
        mItem.addActionListener(listener);
        return mItem;
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.stripsGraph.draw(g, false);
    }
}

