/*
 * Decompiled with CFR 0.152.
 */
package CIspace.planning;

import CIspace.graphToolKit.GraphConsts;
import CIspace.planning.Atom;
import CIspace.planning.World;
import CIspace.planning.WorldListener;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class StateGoalDisplay
implements WorldListener {
    private JPanel statePanel;
    private JPanel goalPanel;
    private ButtonGroup stateGroup;
    private JPanel panel;
    private JPanel sPanel;
    private JScrollPane gScroll;
    private JScrollPane isScroll;
    protected JPanel stateGoalPanel;
    protected World world;
    protected GridBagConstraints gbc;
    protected GridBagLayout gbl;
    protected JTextArea stateText;
    protected JTextArea goalText;

    public StateGoalDisplay(World world) {
        this.world = world;
        this.stateGroup = new ButtonGroup();
        world.addListener(this);
        this.makeStateGoalPanel();
        this.updateDisplay();
    }

    public void update() {
        this.updateDisplay();
    }

    protected void updateDisplay() {
        Atom currItem;
        this.stateText.setText("");
        this.goalText.setText("");
        Vector stateItems = this.world.getInitialState();
        Vector goalItems = this.world.getGoalState();
        int i = 0;
        while (i < stateItems.size()) {
            currItem = (Atom)stateItems.elementAt(i);
            this.stateText.setText(String.valueOf(this.stateText.getText()) + currItem.toString() + "\n");
            ++i;
        }
        i = 0;
        while (i < goalItems.size()) {
            currItem = (Atom)goalItems.elementAt(i);
            this.goalText.setText(String.valueOf(this.goalText.getText()) + currItem.toString() + "\n");
            ++i;
        }
    }

    public void setFontSize(int size) {
        this.stateText.setFont(new Font("arial", 0, size));
        this.goalText.setFont(new Font("arial", 0, size));
    }

    public JPanel getStateGoalPanel() {
        return this.stateGoalPanel;
    }

    protected void makeStateGoalPanel() {
        this.gbl = new GridBagLayout();
        this.gbc = new GridBagConstraints();
        this.gbc.anchor = 18;
        this.gbc.fill = 1;
        this.gbc.insets = new Insets(5, 5, 5, 5);
        JPanel sgPanel = new JPanel();
        sgPanel.setBackground(GraphConsts.bg);
        this.isScroll = new JScrollPane(this.makeStatePanel("Initial State"), 22, 31);
        this.gScroll = new JScrollPane(this.makeGoalPanel("Goals"), 22, 31);
        this.isScroll.setPreferredSize(new Dimension(50, 100));
        this.gScroll.setPreferredSize(new Dimension(50, 100));
        this.addComponent(this.isScroll, sgPanel, 0, 0, 1, 1, 1.0, 1.0);
        this.addComponent(this.gScroll, sgPanel, 0, 1, 1, 1, 1.0, 1.0);
        sgPanel.setLayout(this.gbl);
        this.stateGoalPanel = sgPanel;
    }

    protected JPanel makeStatePanel(String title) {
        this.statePanel = new JPanel(new BorderLayout());
        this.statePanel.add("North", new JLabel(title));
        this.stateText = new JTextArea("", 8, 0);
        this.stateText.setEditable(false);
        this.statePanel.add("Center", this.stateText);
        return this.statePanel;
    }

    protected JPanel makeGoalPanel(String title) {
        this.goalPanel = new JPanel(new BorderLayout());
        this.goalPanel.add("North", new JLabel(title));
        this.goalText = new JTextArea("", 8, 0);
        this.goalText.setEditable(false);
        this.goalPanel.add("Center", this.goalText);
        return this.goalPanel;
    }

    public void setStateGoalPanelVisible(boolean visible) {
        this.stateGoalPanel.setVisible(visible);
    }

    private void addComponent(JComponent c, Container p, int row, int column, int width, int height, double wx, double wy) {
        this.gbc.gridx = column;
        this.gbc.gridy = row;
        this.gbc.gridwidth = width;
        this.gbc.gridheight = height;
        this.gbc.weightx = wx;
        this.gbc.weighty = wy;
        this.gbl.setConstraints(c, this.gbc);
        p.add(c);
    }
}

