/*
 * Decompiled with CFR 0.152.
 */
package CIspace.planning;

import CIspace.planning.DialogAdapter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;

public class ReorderDialog
extends DialogAdapter {
    private DefaultListModel listModel;
    protected Vector listVector;
    protected JList elementList;
    protected String elementName;
    protected JPanel mainPanel;

    public ReorderDialog(JFrame parent, Vector listVector, String elementName) {
        super(parent, "Reorder " + elementName + "s", true);
        this.listVector = listVector;
        this.elementName = elementName;
        this.gbl = new GridBagLayout();
        this.gbc = new GridBagConstraints();
        this.gbc.anchor = 18;
        this.gbc.fill = 1;
        this.constructDialog();
        this.pack();
        ((Component)this).setSize(300, 225);
        this.centerWindow();
    }

    public void open() {
        this.show();
    }

    public JPanel getPanel() {
        return this.mainPanel;
    }

    protected void constructDialog() {
        this.mainPanel = new JPanel();
        this.elementList = new JList();
        this.elementList.setSelectionMode(2);
        this.listModel = new DefaultListModel();
        this.elementList.setModel(this.listModel);
        int i = 0;
        while (i < this.listVector.size()) {
            this.listModel.addElement(this.listVector.elementAt(i).toString());
            ++i;
        }
        JPanel upPanel = new JPanel(new GridLayout(3, 1));
        JPanel emptyPanel = new JPanel(new BorderLayout());
        JButton space = new JButton(" ");
        space.setVisible(false);
        JPanel buttonPanel = new JPanel(new GridLayout(2, 1));
        JButton shiftUp = new JButton("Shift " + this.elementName + " Up    ");
        shiftUp.setActionCommand("shiftUp");
        shiftUp.addActionListener(this);
        upPanel.add(shiftUp);
        JButton shiftDown = new JButton("Shift " + this.elementName + " Down");
        shiftDown.setActionCommand("shiftDown");
        shiftDown.addActionListener(this);
        upPanel.add(shiftDown);
        buttonPanel.add(upPanel);
        buttonPanel.add(emptyPanel);
        this.mainPanel.setLayout(this.gbl);
        this.gbc.anchor = 18;
        this.addComponent(this.elementList, this.mainPanel, 0, 0, 1, 2, 1, 1);
        this.addComponent(buttonPanel, (Container)this.mainPanel, 0, 1, 1, 1, 1.0, 1.0);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add("Center", this.mainPanel);
        this.getContentPane().add("South", this.makeButtonPanel());
    }

    private void addComponent(JList component, JPanel panel, int row, int column, int width, int height, int wx, int wy) {
        this.gbc.gridx = column;
        this.gbc.gridy = row;
        this.gbc.gridwidth = width;
        this.gbc.gridheight = height;
        this.gbc.weightx = wx;
        this.gbc.weighty = wy;
        this.gbl.setConstraints(component, this.gbc);
        panel.add(component);
    }

    protected JPanel makeButtonPanel() {
        JPanel buttonPanel = new JPanel();
        JButton closeButton = new JButton("Close");
        closeButton.addActionListener(this);
        buttonPanel.add(closeButton);
        return buttonPanel;
    }

    protected void shiftGoal(boolean up) {
        int selectedIndex = this.elementList.getSelectedIndex();
        if (selectedIndex == -1) {
            return;
        }
        if (this.listModel.getSize() < 2) {
            return;
        }
        if (up && selectedIndex == 0) {
            return;
        }
        if (!up && selectedIndex == this.listModel.getSize() - 1) {
            return;
        }
        int newIndex = -1;
        newIndex = up ? selectedIndex - 1 : selectedIndex + 1;
        String item = (String)this.listModel.get(selectedIndex);
        this.listModel.removeElementAt(selectedIndex);
        this.listModel.add(newIndex, item);
        this.elementList.setSelectedIndex(newIndex);
        Object moveAtom = this.listVector.elementAt(selectedIndex);
        this.listVector.removeElementAt(selectedIndex);
        this.listVector.insertElementAt(moveAtom, newIndex);
    }

    protected void closeWindow() {
        this.dispose();
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand() == "Close") {
            this.closeWindow();
        } else if (e.getActionCommand() == "shiftUp") {
            this.shiftGoal(true);
        } else if (e.getActionCommand() == "shiftDown") {
            this.shiftGoal(false);
        }
    }

    public void windowClosing(WindowEvent e) {
        this.closeWindow();
    }
}

