/*
 * Decompiled with CFR 0.152.
 */
package CIspace.planning;

import CIspace.planning.Atom;
import CIspace.planning.DialogAdapter;
import CIspace.planning.World;
import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;

public class RemoveGoalsDialog
extends DialogAdapter {
    private DefaultListModel listModel;
    protected World world;
    protected JFrame parent;
    protected JList goalList;
    protected Vector goalsToRemove;

    public RemoveGoalsDialog(JFrame parent, World world) {
        super(parent, "Remove Goals", true);
        this.world = world;
        this.parent = parent;
        this.goalsToRemove = new Vector();
        this.makeList();
        this.constructDialog();
        this.pack();
        this.centerWindow();
        this.show();
    }

    protected void constructDialog() {
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.add("North", new JLabel("Select the goals to remove: "));
        mainPanel.add("Center", this.goalList);
        mainPanel.add("South", this.makeButtonPanel());
        this.getContentPane().add(mainPanel);
    }

    protected void makeList() {
        this.goalList = new JList();
        this.goalList.setSelectionMode(2);
        this.listModel = new DefaultListModel();
        this.goalList.setModel(this.listModel);
        Vector goals = this.world.getGoalState();
        int i = 0;
        while (i < goals.size()) {
            Atom currAtom = (Atom)goals.elementAt(i);
            this.listModel.addElement(currAtom.toString());
            ++i;
        }
    }

    protected JPanel makeButtonPanel() {
        JPanel buttonPanel = new JPanel(new BorderLayout());
        JPanel topRowPanel = new JPanel();
        JPanel bottomRowPanel = new JPanel();
        JButton invertSelection = new JButton("Invert Selection");
        invertSelection.addActionListener(this);
        JButton removeAll = new JButton("Remove All");
        removeAll.addActionListener(this);
        JButton remove = new JButton("Remove Selected");
        remove.addActionListener(this);
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(this);
        JButton okButton = new JButton("Ok");
        okButton.addActionListener(this);
        topRowPanel.add(remove);
        topRowPanel.add(removeAll);
        topRowPanel.add(invertSelection);
        bottomRowPanel.add(okButton);
        bottomRowPanel.add(cancelButton);
        buttonPanel.add("North", topRowPanel);
        buttonPanel.add("South", bottomRowPanel);
        return buttonPanel;
    }

    protected void removeSelected() {
        int i = this.listModel.getSize() - 1;
        while (i >= 0) {
            if (this.goalList.isSelectedIndex(i)) {
                this.goalsToRemove.addElement(this.listModel.get(i));
                this.listModel.removeElementAt(i);
            }
            --i;
        }
    }

    protected void removeAllItems() {
        int i = this.listModel.getSize() - 1;
        while (i >= 0) {
            this.goalsToRemove.addElement(this.listModel.get(i));
            this.listModel.removeElementAt(i);
            --i;
        }
    }

    private void deSelectAll(JList targetList) {
        targetList.clearSelection();
    }

    private void invertSelection(JList targetList) {
        DefaultListModel targetModel = (DefaultListModel)targetList.getModel();
        Vector<Integer> vecInds = new Vector<Integer>();
        int[] selectedinds = targetList.getSelectedIndices();
        int i = 0;
        while (i < targetModel.getSize()) {
            boolean flag = false;
            int j = 0;
            while (j < selectedinds.length) {
                if (selectedinds[j] == i) {
                    flag = true;
                }
                ++j;
            }
            if (!flag) {
                vecInds.addElement(new Integer(i));
            }
            ++i;
        }
        int[] inds = new int[vecInds.size()];
        int j = 0;
        while (j < vecInds.size()) {
            inds[j] = (Integer)vecInds.get(j);
            ++j;
        }
        targetList.setSelectedIndices(inds);
    }

    private void removeGoalsFromWorld() {
        int i = 0;
        while (i < this.goalsToRemove.size()) {
            this.world.removeStateItem((String)this.goalsToRemove.elementAt(i), 201);
            ++i;
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand() == "Ok") {
            this.removeGoalsFromWorld();
            this.dispose();
        }
        if (e.getActionCommand() == "Cancel") {
            this.dispose();
        } else if (e.getActionCommand() == "Remove Selected") {
            this.removeSelected();
        } else if (e.getActionCommand() == "Remove All") {
            this.removeAllItems();
        } else if (e.getActionCommand() == "Invert Selection") {
            this.invertSelection(this.goalList);
        }
    }
}

