/*
 * Decompiled with CFR 0.152.
 */
package CIspace.planning;

import CIspace.graphToolKit.Graph;
import CIspace.graphToolKit.GraphCanvas;
import CIspace.graphToolKit.GraphWindow;
import CIspace.graphToolKit.HelpMenu;
import CIspace.graphToolKit.MessageDialog;
import CIspace.graphToolKit.OpenLocationDialog;
import CIspace.planning.AddGoalDialog;
import CIspace.planning.AutoSolver;
import CIspace.planning.BlockCanvas;
import CIspace.planning.BlockGraph;
import CIspace.planning.CanvasLabelFlasher;
import CIspace.planning.ConfirmContinueDialog;
import CIspace.planning.CurrentStateDisplay;
import CIspace.planning.GoalEntryMethodSelectDialog;
import CIspace.planning.OrderPreconditionsDialog;
import CIspace.planning.PlanDisplay;
import CIspace.planning.PlanVisualizer;
import CIspace.planning.PlannerCanvas;
import CIspace.planning.PlanningEngine;
import CIspace.planning.PlanningFilter;
import CIspace.planning.ProblemDialog;
import CIspace.planning.RemoveGoalsDialog;
import CIspace.planning.ReorderDialog;
import CIspace.planning.StateGoalDisplay;
import CIspace.planning.StripsCanvas;
import CIspace.planning.StripsGraph;
import CIspace.planning.TextFrame;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.URL;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;

public class PlanningWindow
extends GraphWindow {
    private JMenuItem print;
    private JMenu speed;
    private JMenuItem algoOptions;
    private JMenu planner;
    private JMenuItem setDefaultMenu;
    private JMenuItem setActionMenu;
    private JMenu options;
    private JMenuItem createNew;
    private ButtonGroup actionButtonGroup;
    private JButton tempButton;
    private JPanel statePanel;
    private JPanel goalStatePanel;
    private JPanel initialStatePanel;
    JToggleButton goalStateButton;
    private JToggleButton initialStateButton;
    private JToggleButton intialStateButton;
    private ButtonGroup stateGroup;
    private JPanel stateChangePanel;
    private boolean moveToMiddleflag;
    private JCheckBoxMenuItem showBottomPanel;
    private JPanel choicePanel;
    private JPanel goalChoicePanel;
    private JCheckBoxMenuItem createGoalState;
    private JCheckBoxMenuItem createInitialState;
    private PlanningFilter filter;
    private JRadioButton visualGoalEntry = new JRadioButton("Specify goal state graphically", true);
    private JRadioButton atomGoalEntry;
    private JCheckBoxMenuItem xFast;
    private JCheckBoxMenuItem fast;
    private JCheckBoxMenuItem medium;
    private JCheckBoxMenuItem slow;
    private JCheckBoxMenuItem pruneFailedSubtrees;
    private JButton addGoalButton;
    private JButton removeGoalButton;
    private JButton stepButton;
    private JButton autoStepButton;
    private JButton stopButton;
    private JButton viewCurrentStateButton;
    private JButton viewPlanButton;
    private JButton resetGraphButton;
    private JButton runPlanButton;
    private JButton reorderGoalsButton;
    private String extension;
    private String title;
    private String filename;
    private JScrollPane createScroll;
    private Graph graph;
    private BlockCanvas createCanvas;
    private PlannerCanvas plannerCanvas;
    private GraphCanvas canvas;
    private PlanningEngine engine;
    private StateGoalDisplay stateGoalDisplay;
    private CurrentStateDisplay currentStateDisplay;
    private PlanVisualizer planVisualizer;
    private PlanDisplay planDisplay;
    private ReorderDialog reorderGoalsDialog;
    private AddGoalDialog addGoalDialog;
    private OrderPreconditionsDialog orderPreconditionsDialog;
    private CanvasLabelFlasher canvasLabelFlasher;
    boolean isGraphicalGoalMode;
    private boolean goalModeSelected;
    protected AutoSolver autoSolve;
    private int delayTime = 100;
    protected static ImageIcon stepIcon;
    protected static ImageIcon fineStepIcon;
    protected static ImageIcon autoSearchIcon;
    protected static ImageIcon stopIcon;
    protected static ImageIcon resetIcon;
    protected static ImageIcon createNewBlockIcon;
    protected static ImageIcon reorderGoalsIcon;
    protected static ImageIcon addGoalIcon;
    protected static ImageIcon viewCurrentStateIcon;
    protected static ImageIcon viewCurrentPlanIcon;
    protected static ImageIcon runCurrentPlanIcon;
    protected static ImageIcon deleteGoalIcon;
    protected static ImageIcon moveSubtreeIcon;
    private static String aboutText;

    static {
        createNewBlockIcon = GraphWindow.createImageIcon("images/createNewBlock.png");
        reorderGoalsIcon = GraphWindow.createImageIcon("images/reorderGoals.png");
        addGoalIcon = GraphWindow.createImageIcon("images/addGoal.png");
        viewCurrentStateIcon = GraphWindow.createImageIcon("images/viewCurrentState.png");
        viewCurrentPlanIcon = GraphWindow.createImageIcon("images/viewCurrentPlan.png");
        runCurrentPlanIcon = GraphWindow.createImageIcon("images/runPlan.png");
        deleteGoalIcon = GraphWindow.createImageIcon("images/deleteGoal.png");
        moveSubtreeIcon = GraphWindow.createImageIcon("images/movesubtree.png");
        aboutText = "About this applet\n\nPlanning Applet 4.0\nUpdated: Nicole Arksey\nMain Author: Wesley Coehlo\nGraph Drawing Kit & Porting: Shinjiro Sueda\n\nSpecial Thanks to:\nDavid Poole, Alan Mackworth, Holger Hoos,\nPeter Gorniak, Cristina Conati, and Kevin O'Neill";
    }

    public PlanningWindow(JApplet parent) {
        super(parent);
        ((Component)this).setVisible(false);
        ((Component)this).setSize(900, 750);
        this.extension = ".xml";
        this.title = "Planning Applet 4.0";
        this.setTitle(String.valueOf(this.title) + " --- untitled.xml");
        this.filename = "untitled";
        this.solveToolBar();
        this.createToolBarWithText();
        this.createButModes[0].setSelected(true);
        this.moveToMiddleflag = true;
        this.tabandbottom.setResizeWeight(1.0);
        this.tabandbottom.setDividerLocation(0.73);
        this.print.setEnabled(false);
        this.currentStateDisplay = null;
        this.planVisualizer = null;
        this.planDisplay = null;
        this.reorderGoalsDialog = null;
        this.autoSolve = null;
        this.canvasLabelFlasher = null;
        this.canvasPanel.remove(this.scrollPanel);
        this.addComponent(this.createScroll, this.canvasPanel, 1, 0, 1, 1, 1.0, 1.0);
        this.stateGoalDisplay = this.engine.getStateGoalDisplay();
        this.createStateChangePanel();
        this.statePanel = this.stateGoalDisplay.getStateGoalPanel();
        this.createGoalChoicePanel();
        this.bottomPanel.remove(this.algoText);
        this.bottomPanel.add((Component)this.stateChangePanel, "North");
        this.bottomPanel.add((Component)this.statePanel, "Center");
        this.bottomPanel.add((Component)this.choicePanel, "South");
        this.bottomPanel.setMinimumSize(new Dimension(500, 133));
        this.createCanvas.setMode(2220);
        this.goalModeSelected = false;
        this.isGraphicalGoalMode = true;
        this.setControlsInitial(true);
        stepIcon = GraphWindow.createImageIcon("images/step.png");
        fineStepIcon = GraphWindow.createImageIcon("images/finestep.png");
        autoSearchIcon = GraphWindow.createImageIcon("images/gear.png");
        stopIcon = GraphWindow.createImageIcon("images/stop.gif");
        resetIcon = GraphWindow.createImageIcon("images/Reset.gif");
        createNewBlockIcon = GraphWindow.createImageIcon("images/createNewBlock.png");
        reorderGoalsIcon = GraphWindow.createImageIcon("images/reorderGoals.png");
        addGoalIcon = GraphWindow.createImageIcon("images/addGoal.png");
        viewCurrentStateIcon = GraphWindow.createImageIcon("images/viewCurrentState.png");
        viewCurrentPlanIcon = GraphWindow.createImageIcon("images/viewCurrentPlan.png");
        runCurrentPlanIcon = GraphWindow.createImageIcon("images/runPlan.png");
        deleteGoalIcon = GraphWindow.createImageIcon("images/deleteGoal.png");
        this.createButModes[4].setEnabled(false);
        this.createButModes[5].setEnabled(false);
        this.setMenuEnabled(false);
        this.setPromptLabel("Initial State");
        this.centerWindow();
        this.show();
    }

    public void createStateChangePanel() {
        this.stateChangePanel = new JPanel();
        this.stateChangePanel.setLayout(new GridLayout(1, 2));
        this.stateGroup = new ButtonGroup();
        this.initialStateButton = new JToggleButton("Initial State");
        this.initialStateButton.setToolTipText("Create initial state of blocks.");
        this.initialStateButton.addActionListener(this);
        this.stateGroup.add(this.initialStateButton);
        this.goalStateButton = new JToggleButton("Create Goal State");
        this.goalStateButton.setToolTipText("Create and specify goals for the planner to solve.");
        this.goalStateButton.addActionListener(this);
        this.stateGroup.add(this.goalStateButton);
        this.stateChangePanel.add(this.initialStateButton);
        this.stateChangePanel.add(this.goalStateButton);
        this.initialStateButton.setSelected(true);
    }

    private void createGoalChoicePanel() {
        this.choicePanel = new JPanel();
        this.choicePanel.setLayout(new GridLayout(1, 2));
        this.goalChoicePanel = new JPanel(new BorderLayout());
        ButtonGroup choiceGroup = new ButtonGroup();
        this.visualGoalEntry = new JRadioButton("Specify goal state graphically", true);
        this.visualGoalEntry.setToolTipText("Choose to specify goal state graphically by rearranging the initial state ");
        this.visualGoalEntry.addActionListener(this);
        this.visualGoalEntry.setEnabled(false);
        choiceGroup.add(this.visualGoalEntry);
        this.atomGoalEntry = new JRadioButton("Specify goals by entering atoms", false);
        this.atomGoalEntry.addActionListener(this);
        this.atomGoalEntry.setToolTipText("Choose to specify goals by entering atoms");
        this.atomGoalEntry.setEnabled(false);
        choiceGroup.add(this.atomGoalEntry);
        this.goalChoicePanel.add((Component)this.visualGoalEntry, "West");
        this.goalChoicePanel.add((Component)this.atomGoalEntry, "East");
        JLabel tempLabel = new JLabel("             ");
        this.choicePanel.add(tempLabel);
        this.choicePanel.add(this.goalChoicePanel);
    }

    protected void getCanvas() {
        this.engine = new PlanningEngine(this);
        this.createCanvas = this.engine.getCreateCanvas();
        this.plannerCanvas = new StripsCanvas(this, false, this.engine.getWorld());
        this.plannerCanvas.initialize();
        this.plannerCanvas.setPreferredSize(new Dimension(5000, 1500));
        this.canvas = this.createCanvas;
        this.createScroll = new JScrollPane(this.createCanvas, 20, 30);
        this.createScroll.setPreferredSize(new Dimension(425, 300));
        this.scrollPanel = new JScrollPane(this.plannerCanvas, 22, 32);
        this.scrollPanel.setPreferredSize(new Dimension(425, 300));
        this.scrollPanel.getHorizontalScrollBar().setMaximum(5000);
        this.scrollPanel.getHorizontalScrollBar().setValue(2000);
        this.scrollPanel.getVerticalScrollBar().setMaximum(1500);
        this.scrollPanel.getVerticalScrollBar().setValue(550);
    }

    protected GraphCanvas returnCanvas() {
        return this.canvas;
    }

    protected JMenu createFileMenu() {
        JMenu m = new JMenu("File");
        this.createnewgraph = new JMenuItem("Create New Planning Problem");
        this.createnewgraph.setActionCommand(this.createnewgraph.getText());
        this.createnewgraph.addActionListener(this);
        this.createnewgraph.setMnemonic(78);
        m.add(this.createnewgraph);
        JMenuItem mItem = new JMenuItem("Load Sample Problem");
        mItem.setActionCommand(mItem.getText());
        mItem.addActionListener(this);
        mItem.setMnemonic(83);
        m.add(mItem);
        if (this.applet == null) {
            mItem = new JMenuItem("Open File");
            mItem.addActionListener(this);
            mItem.setMnemonic(79);
            m.add(mItem);
            m.addSeparator();
            mItem = new JMenuItem("Save File");
            mItem.addActionListener(this);
            mItem.setMnemonic(83);
            m.add(mItem);
        } else {
            mItem = new JMenuItem("Open Location");
            mItem.setMnemonic(76);
            mItem.setActionCommand(mItem.getText());
            mItem.addActionListener(this);
            m.add(mItem);
            m.addSeparator();
        }
        this.print = new JMenuItem("Print");
        this.print.setActionCommand(this.print.getText());
        this.print.setToolTipText("Print your graph");
        this.print.addActionListener(this);
        this.print.setMnemonic(80);
        m.add(this.print);
        mItem = new JMenuItem("Quit");
        mItem.setActionCommand(mItem.getText());
        mItem.addActionListener(this);
        mItem.setMnemonic(81);
        m.add(mItem);
        return m;
    }

    protected JMenu createOptionsMenu() {
        this.options = new JMenu("Graph Options");
        this.speed = new JMenu("Auto Solve Speed");
        this.xFast = new JCheckBoxMenuItem("Very Fast (0 s)", false);
        this.xFast.addActionListener(this);
        this.speed.add(this.xFast);
        this.fast = new JCheckBoxMenuItem("Fast (0.1 s)", true);
        this.fast.addActionListener(this);
        this.speed.add(this.fast);
        this.medium = new JCheckBoxMenuItem("Medium (0.5 s)", false);
        this.medium.addActionListener(this);
        this.speed.add(this.medium);
        this.slow = new JCheckBoxMenuItem("Slow (1 s)", false);
        this.slow.addActionListener(this);
        this.speed.add(this.slow);
        this.options.add(this.speed);
        this.options.addSeparator();
        this.setActionMenu = new JMenuItem("Set Action Choice Priority");
        this.setActionMenu.addActionListener(this);
        this.options.add(this.setActionMenu);
        this.setDefaultMenu = new JMenuItem("Set Default Precondition Order");
        this.setDefaultMenu.addActionListener(this);
        this.options.add(this.setDefaultMenu);
        this.options.addSeparator();
        this.planner = new JMenu("Planning Algorithm");
        JMenuItem mItem = new JMenuItem("STRIPS");
        mItem.addActionListener(this);
        this.planner.add(mItem);
        mItem = new JMenuItem("Regression");
        mItem.addActionListener(this);
        mItem.setEnabled(false);
        this.planner.add(mItem);
        mItem = new JMenuItem("Partial Order");
        mItem.addActionListener(this);
        mItem.setEnabled(false);
        this.planner.add(mItem);
        this.options.add(this.planner);
        this.algoOptions = new JMenuItem("Algorithm Options");
        this.algoOptions.addActionListener(this);
        this.options.add(this.algoOptions);
        this.options.addSeparator();
        this.pruneFailedSubtrees = new JCheckBoxMenuItem("Prune failed action subtrees", true);
        this.pruneFailedSubtrees.addActionListener(this);
        this.options.add(this.pruneFailedSubtrees);
        return this.options;
    }

    protected JMenu createViewMenu() {
        this.m = super.createViewMenu();
        this.m.remove(5);
        this.showBottomPanel = new JCheckBoxMenuItem("Show Bottom Panel", true);
        this.showBottomPanel.addActionListener(this);
        this.m.add(this.showBottomPanel);
        return this.m;
    }

    protected JMenu createEditMenu() {
        JMenu m = new JMenu("Edit");
        JMenuItem mItem = new JMenuItem("View/Edit Text Representation");
        mItem.addActionListener(this);
        m.add(mItem);
        return m;
    }

    protected JMenuBar createMenuBar() {
        super.createMenuBar();
        JMenu editMenu = this.createEditMenu();
        this.mBar.add((Component)editMenu, 1);
        JMenu optionsMenu = this.createOptionsMenu();
        this.mBar.add((Component)optionsMenu, 3);
        this.setJMenuBar(this.mBar);
        return this.mBar;
    }

    public void createToolBar() {
        this.toolBar.removeAll();
        this.createModeButGroup = new ButtonGroup();
        this.createButModes = new JToggleButton[6];
        this.setCreateButtons(0, createNewBlockIcon, "Create new block");
        this.setCreateButtons(1, this.deleteIcon, "Delete block");
        this.setCreateButtons(2, this.setPropsIcon, "Set block's properties");
        this.setCreateButtons(3, reorderGoalsIcon, "Reorder goals");
        this.setCreateButtons(4, addGoalIcon, "Add goal.");
        this.setCreateButtons(5, deleteGoalIcon, "Delete goal");
        this.actionButtonGroup = new ButtonGroup();
        this.tempButton = new JButton();
        this.tempButton.setVisible(false);
        this.actionButtonGroup.add(this.tempButton);
        int i = 0;
        while (i <= 2) {
            this.createModeButGroup.add(this.createButModes[i]);
            this.toolBar.add(this.createButModes[i]);
            this.createButModes[i].setFont(this.toolFont);
            ++i;
        }
        this.toolBar.addSeparator();
        i = 3;
        while (i <= 5) {
            this.actionButtonGroup.add(this.createButModes[i]);
            this.toolBar.add(this.createButModes[i]);
            this.createButModes[i].setFont(this.toolFont);
            ++i;
        }
        if (this.visualGoalEntry.isSelected()) {
            this.createButModes[4].setEnabled(false);
            this.createButModes[5].setEnabled(false);
        }
    }

    public void createToolBarWithText() {
        this.toolBar.removeAll();
        this.createModeButGroup = new ButtonGroup();
        this.createButModes = new JToggleButton[6];
        this.setCreateButtonsWithText(0, "Create New Block", createNewBlockIcon, "Create new block");
        this.setCreateButtonsWithText(1, "  Delete Block ", this.deleteIcon, "Delete block");
        this.setCreateButtonsWithText(2, "Set Block Properties", this.setPropsIcon, "Set block's properties");
        this.setCreateButtonsWithText(3, "Reorder Goals", reorderGoalsIcon, "Reorder goals");
        this.setCreateButtonsWithText(4, "Add Goal", addGoalIcon, "Add goal.");
        this.setCreateButtonsWithText(5, "Delete Goal", deleteGoalIcon, "Delete goal");
        this.actionButtonGroup = new ButtonGroup();
        this.tempButton = new JButton();
        this.tempButton.setVisible(false);
        this.actionButtonGroup.add(this.tempButton);
        int i = 0;
        while (i <= 2) {
            this.createModeButGroup.add(this.createButModes[i]);
            this.toolBar.add(this.createButModes[i]);
            this.createButModes[i].setFont(this.toolFont);
            ++i;
        }
        this.toolBar.addSeparator();
        i = 3;
        while (i <= 5) {
            this.actionButtonGroup.add(this.createButModes[i]);
            this.toolBar.add(this.createButModes[i]);
            this.createButModes[i].setFont(this.toolFont);
            ++i;
        }
        this.toolBar.addSeparator();
        i = 3;
        while (i <= 5) {
            this.toolBar.add(this.createButModes[i]);
            this.createButModes[i].setFont(this.toolFont);
            ++i;
        }
    }

    public void solveToolBar() {
        super.solveToolBar();
        this.toolBar.removeAll();
        this.solveModeButGroup = new ButtonGroup();
        this.solveButModes = new JToggleButton[8];
        this.setSolveButtons(0, stepIcon, "Step");
        this.setSolveButtons(1, autoSearchIcon, "Auto Solve");
        this.setSolveButtons(2, stopIcon, "Stop Search");
        this.setSolveButtons(3, resetIcon, "Reset Graph");
        this.setSolveButtons(4, viewCurrentStateIcon, "View the current state of the plan");
        this.setSolveButtons(5, viewCurrentPlanIcon, "View the current plan");
        this.setSolveButtons(6, runCurrentPlanIcon, "Run the plan");
        this.tempButton = new JButton();
        this.tempButton.setVisible(false);
        this.createModeButGroup.add(this.tempButton);
        int i = 0;
        while (i < 5) {
            this.solveModeButGroup.add(this.solveButModes[i]);
            this.toolBar.add(this.solveButModes[i]);
            this.solveButModes[i].setFont(this.toolFont);
            ++i;
        }
        this.toolBar.addSeparator();
        i = 5;
        while (i < 7) {
            this.solveModeButGroup.add(this.solveButModes[i]);
            this.toolBar.add(this.solveButModes[i]);
            this.solveButModes[i].setFont(this.toolFont);
            ++i;
        }
        this.repaint();
    }

    public void solveToolBarWithText() {
        this.toolBar.removeAll();
        this.solveModeButGroup = new ButtonGroup();
        this.solveButModes = new JToggleButton[8];
        this.setSolveButtonsWithText(0, "      Step       ", stepIcon, "Step");
        this.setSolveButtonsWithText(1, "Auto Solve", autoSearchIcon, "Auto Solve");
        this.setSolveButtonsWithText(2, " Stop Search", stopIcon, "Stop Search");
        this.setSolveButtonsWithText(3, "Reset Graph", resetIcon, "Reset Graph");
        this.setSolveButtonsWithText(4, " View Current State  ", viewCurrentStateIcon, "View the current state of the plan");
        this.setSolveButtonsWithText(5, "View Current Plan", viewCurrentPlanIcon, "View the current plan");
        this.setSolveButtonsWithText(6, "Run Plan ", runCurrentPlanIcon, "Run the plan");
        int i = 0;
        while (i < 7) {
            this.solveModeButGroup.add(this.solveButModes[i]);
            this.toolBar.add(this.solveButModes[i]);
            this.solveButModes[i].setFont(this.toolFont);
            ++i;
        }
        this.repaint();
    }

    private void setMenuEnabled(boolean bool) {
        this.speed.setEnabled(bool);
        this.setActionMenu.setEnabled(bool);
        this.setDefaultMenu.setEnabled(bool);
        this.planner.setEnabled(bool);
        this.algoOptions.setEnabled(bool);
        this.pruneFailedSubtrees.setEnabled(bool);
    }

    public void newTab(String str) {
        if (str == "Create") {
            this.zp.setEnabled(false);
            this.showBottomPanel.setEnabled(true);
            this.print.setEnabled(false);
            this.setMenuEnabled(false);
            this.bottomPanel.setVisible(true);
            this.createnewgraph.setEnabled(true);
            this.createCanvas.setMode(2220);
            this.setCanvas(this.createCanvas);
            this.stateGoalDisplay.setStateGoalPanelVisible(true);
            this.validate();
            this.engine.getWorld().setUnchanged();
            this.setPromptLabel("Initial State");
            this.validate();
            if (this.buttontext) {
                this.createToolBarWithText();
            } else {
                this.createToolBar();
            }
            this.createCanvas.setBlockCanvasMode(100);
            this.createButModes[0].setSelected(true);
            if (this.visualGoalEntry.isSelected()) {
                this.createButModes[4].setEnabled(false);
                this.createButModes[5].setEnabled(false);
            }
            this.zp.setEnabled(false);
            this.atomGoalEntry.setEnabled(false);
            this.visualGoalEntry.setEnabled(false);
            this.createButModes[4].setEnabled(false);
            this.createButModes[5].setEnabled(false);
            this.initialStateButton.setSelected(true);
        } else if (str == "Solve") {
            this.zp.setEnabled(false);
            this.showBottomPanel.setEnabled(false);
            this.createnewgraph.setEnabled(false);
            this.createCanvas.setMode(2221);
            this.setCanvas(this.plannerCanvas);
            if (this.engine.getWorld().hasChanged) {
                this.plannerCanvas.initialize();
                if (this.currentStateDisplay != null) {
                    this.resetCurrentStateDisplay();
                }
                if (this.planVisualizer != null) {
                    this.resetPlanVisualizer();
                }
                if (this.planDisplay != null) {
                    this.planDisplay.dispose();
                    this.planDisplay = null;
                }
                this.plannerCanvas.moveToTopMiddle();
            }
            this.bottomPanel.setVisible(false);
            this.stateGoalDisplay.setStateGoalPanelVisible(false);
            this.setMenuEnabled(true);
            this.validate();
            this.setPromptLabel("");
            this.zp.setEnabled(true);
            this.print.setEnabled(true);
            this.validate();
            if (this.buttontext) {
                this.solveToolBarWithText();
            } else {
                this.solveToolBar();
            }
            if (this.moveToMiddleflag) {
                this.plannerCanvas.moveToTopMiddle();
            }
            this.moveToMiddleflag = false;
            this.validate();
            this.repaint();
            this.solveButModes[2].setEnabled(false);
        }
        this.setGoalDisplayPanel();
    }

    private void setGoalDisplayPanel() {
        if (this.showBottomPanel.getState()) {
            this.stateGoalDisplay.setStateGoalPanelVisible(true);
            this.tabandbottom.setDividerLocation(0.72);
            this.validate();
            this.tabandbottom.repaint();
        } else {
            this.stateGoalDisplay.setStateGoalPanelVisible(false);
            this.tabandbottom.setDividerLocation(0.95);
            this.validate();
        }
    }

    public void setPromptLabelColorBack(String str) {
        this.messageCanvas.setText(str);
    }

    public void setPromptLabelBackground(Color color) {
        this.messageCanvas.setBackground(color);
    }

    public String getPromptLabel() {
        return this.messageCanvas.getText();
    }

    protected String getAboutText() {
        return aboutText;
    }

    public void windowActivated(WindowEvent e) {
        this.repaint();
    }

    public void windowClosed(WindowEvent e) {
        if (this.applet == null) {
            System.exit(0);
        }
    }

    public void windowClosing(WindowEvent e) {
        if (this.planVisualizer != null) {
            this.planVisualizer.dispose();
        }
        if (this.currentStateDisplay != null) {
            this.currentStateDisplay.dispose();
        }
        if (this.planDisplay != null) {
            this.planDisplay.dispose();
        }
        if (this.reorderGoalsDialog != null) {
            this.reorderGoalsDialog.dispose();
        }
        if (this.addGoalDialog != null) {
            this.addGoalDialog.dispose();
        }
        ((Component)this).setVisible(false);
        this.dispose();
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }

    public void actionPerformed(ActionEvent e) {
        String arg = e.getActionCommand();
        if (arg.equals("Create New Block") || e.getSource().equals(this.createButModes[0])) {
            this.createCanvas.setBlockCanvasMode(100);
            this.setPromptLabel("Click the canvas to place a new block.");
            System.out.println("Create New Block");
            return;
        }
        if (arg.equals("Move Block")) {
            this.createCanvas.setBlockCanvasMode(3332);
            this.setPromptLabel("Click and drag a block to move it around.");
            return;
        }
        if (arg.equals("Delete Block") || e.getSource().equals(this.createButModes[1])) {
            this.createCanvas.setBlockCanvasMode(101);
            this.setPromptLabel("Click on a block to delete.");
            return;
        }
        if (arg.equals("Set Block Properties") || e.getSource().equals(this.createButModes[2])) {
            this.createCanvas.setBlockCanvasMode(102);
            this.setPromptLabel("Click on a block to set its properties.");
            return;
        }
        if (arg.equals("Initial State")) {
            this.goToCreateInitialMode();
            this.atomGoalEntry.setEnabled(false);
            this.visualGoalEntry.setEnabled(false);
            return;
        }
        if (arg.equals("Create Goal State")) {
            this.createButModes[0].setEnabled(false);
            this.createButModes[1].setEnabled(false);
            this.createButModes[2].setEnabled(false);
            this.atomGoalEntry.setEnabled(true);
            this.visualGoalEntry.setEnabled(true);
            this.goToSpecifyGoalsMode();
            return;
        }
        if (arg.equals("Very Fast (0 s)")) {
            this.delayTime = 0;
            this.xFast.setState(true);
            this.fast.setState(false);
            this.medium.setState(false);
            this.slow.setState(false);
            if (this.autoSolve != null) {
                this.autoSolve.setDelayTime(this.delayTime);
            }
            return;
        }
        if (arg.equals("Fast (0.1 s)")) {
            this.delayTime = 100;
            this.xFast.setState(false);
            this.fast.setState(true);
            this.medium.setState(false);
            this.slow.setState(false);
            if (this.autoSolve != null) {
                this.autoSolve.setDelayTime(this.delayTime);
            }
            return;
        }
        if (arg.equals("Medium (0.5 s)")) {
            this.delayTime = 500;
            this.xFast.setState(false);
            this.fast.setState(false);
            this.medium.setState(true);
            this.slow.setState(false);
            if (this.autoSolve != null) {
                this.autoSolve.setDelayTime(this.delayTime);
            }
            return;
        }
        if (arg.equals("Slow (1 s)")) {
            this.delayTime = 1000;
            this.xFast.setState(false);
            this.fast.setState(false);
            this.medium.setState(false);
            this.slow.setState(true);
            if (this.autoSolve != null) {
                this.autoSolve.setDelayTime(this.delayTime);
            }
            return;
        }
        if (arg.equals("Show Bottom Panel") || e.getSource().equals(this.showBottomPanel)) {
            this.setGoalDisplayPanel();
        } else {
            if (arg.equals("Prune failed action subtrees")) {
                ((StripsGraph)((StripsCanvas)this.plannerCanvas).graph).enablePruneFailedSubtrees(this.pruneFailedSubtrees.getState());
                return;
            }
            if (arg.equals("Specify goal state by graphically rearranging the initial state") || e.getSource().equals(this.visualGoalEntry)) {
                this.switchGoalEntryMode(true);
                this.createButModes[4].setEnabled(false);
                this.createButModes[5].setEnabled(false);
                return;
            }
            if (arg.equals("Specify goals by entering atoms") || e.getSource().equals(this.atomGoalEntry)) {
                this.switchGoalEntryMode(false);
                this.createCanvas.showInitialState();
                this.setPromptLabel("Initial State");
                this.createButModes[4].setEnabled(true);
                this.createButModes[5].setEnabled(true);
                return;
            }
            if (arg.equals("Create New Planning Problem")) {
                this.engine.getWorld().resetAllState();
                this.createCanvas.reset();
                this.setTitle(String.valueOf(this.title) + " --- untitled.xml");
                this.goalModeSelected = false;
                this.setControlsInitial(true);
                this.plannerCanvas.initialize();
                if (!this.bottomPanel.isVisible()) {
                    System.out.println("go to create mode");
                    this.tabbedPane.setSelectedIndex(0);
                }
                if (this.planDisplay != null) {
                    this.planDisplay.dispose();
                    this.planDisplay = null;
                }
                if (this.currentStateDisplay != null) {
                    this.currentStateDisplay.dispose();
                    this.currentStateDisplay = null;
                }
                if (this.planVisualizer != null) {
                    this.planVisualizer.dispose();
                    this.planVisualizer = null;
                }
                return;
            }
            if (arg.equals("Set Default Precondition Order")) {
                this.orderPreconditionsDialog = new OrderPreconditionsDialog((JFrame)this, this.engine.getWorld());
                return;
            }
            if (arg.equals("Set Action Choice Priority")) {
                ReorderDialog reorderActionsDialog = new ReorderDialog((JFrame)this, this.engine.getWorld().getActionsVector(), "Action");
                reorderActionsDialog.open();
                return;
            }
            if (arg.equals("Quit")) {
                ((Component)this).setVisible(false);
                this.dispose();
                return;
            }
            if (arg.equals("Delete Goal") || e.getSource().equals(this.createButModes[5])) {
                this.actionButtonGroup.setSelected(this.tempButton.getModel(), true);
                RemoveGoalsDialog rgd = new RemoveGoalsDialog((JFrame)this, this.engine.getWorld());
                return;
            }
            if (arg.equals("Add Goal") || e.getSource().equals(this.createButModes[4])) {
                this.actionButtonGroup.setSelected(this.tempButton.getModel(), true);
                this.addGoalDialog = new AddGoalDialog((JFrame)this, this.engine.getWorld(), this.createCanvas.getInitialBlocks());
                return;
            }
            if (arg.equals("Step") || e.getSource() == this.solveButModes[0]) {
                this.solveModeButGroup.setSelected(this.tempButton.getModel(), true);
                this.plannerCanvas.step();
                return;
            }
            if (arg.equals("Auto Solve") || e.getSource().equals(this.solveButModes[1])) {
                this.autoSearch();
                if (this.plannerCanvas.autoSolveContinue()) {
                    this.autoSolve = new AutoSolver(this, this.plannerCanvas, this.delayTime);
                    this.autoSolve.start();
                    this.autoSolveStart();
                }
                return;
            }
            if (arg.equals("Stop") || e.getSource().equals(this.solveButModes[2])) {
                this.stop();
                if (this.autoSolve != null) {
                    this.autoSolve.quit();
                }
                return;
            }
            if (arg.equals("Reset Graph") || e.getSource().equals(this.solveButModes[3])) {
                this.resetGraph();
                this.plannerCanvas.initialize(this.scrollPanel.getWidth());
                if (this.currentStateDisplay != null) {
                    this.resetCurrentStateDisplay();
                }
                this.plannerCanvas.moveToTopMiddle();
                return;
            }
            if (arg.equals("View Current Plan") || e.getSource().equals(this.solveButModes[5])) {
                if (this.planDisplay != null) {
                    this.planDisplay.dispose();
                }
                this.planDisplay = new PlanDisplay((JFrame)this, this.engine.getWorld());
                return;
            }
            if (arg.equals("Run Plan") || e.getSource() == this.solveButModes[6]) {
                BlockGraph initialGraph = this.createCanvas.getInitialGraph();
                BlockGraph goalGraph = null;
                if (this.isGraphicalGoalMode) {
                    goalGraph = this.createCanvas.getGoalGraph();
                }
                if (this.planVisualizer == null) {
                    this.planVisualizer = new PlanVisualizer(this, this.engine.getWorld(), initialGraph, goalGraph);
                } else {
                    this.planVisualizer.reset(initialGraph, goalGraph);
                    this.planVisualizer.show();
                }
                return;
            }
            if (arg.equals("Reorder Goals") || e.getSource().equals(this.createButModes[3])) {
                this.reorderGoals();
                return;
            }
            if (arg.equals("View Current State") || e.getSource().equals(this.solveButModes[4])) {
                BlockGraph initialGraph = this.createCanvas.getInitialGraph();
                BlockGraph goalGraph = null;
                if (this.isGraphicalGoalMode) {
                    goalGraph = this.createCanvas.getGoalGraph();
                }
                if (this.currentStateDisplay != null) {
                    this.currentStateDisplay.dispose();
                    this.currentStateDisplay = new CurrentStateDisplay(this, this.engine.getWorld(), initialGraph, goalGraph);
                } else {
                    this.currentStateDisplay = new CurrentStateDisplay(this, this.engine.getWorld(), initialGraph, goalGraph);
                }
                return;
            }
            if (arg.equals("Algorithm Options")) {
                this.plannerCanvas.openOptionsDialog();
                return;
            }
            if (arg.equals("Load Sample Problem")) {
                ProblemDialog pDialog = new ProblemDialog(this);
                return;
            }
            if (arg.equals("Open File")) {
                JFileChooser load = new JFileChooser();
                load.setFileSelectionMode(2);
                load.setLocation(0, 0);
                int returnval = load.showOpenDialog(this);
                if (returnval == 0) {
                    File file = load.getSelectedFile();
                    this.filename = file.getName();
                    this.load(file);
                }
                return;
            }
            if (arg.equals("Open Location")) {
                OpenLocationDialog old = new OpenLocationDialog(this);
                String urlString = old.url;
                if (urlString != null) {
                    this.filename = urlString.substring(urlString.lastIndexOf("/") + 1);
                    try {
                        URL url = new URL(urlString);
                        InputStream iStream = url.openStream();
                        this.load(new BufferedReader(new InputStreamReader(iStream)));
                    }
                    catch (Exception exc) {
                        this.showMessage("Error", exc.toString());
                    }
                }
                return;
            }
            if (arg.equals("Save File")) {
                String parentfile = null;
                String filename = this.getTitle();
                JFileChooser save = new JFileChooser();
                save.setFileSelectionMode(2);
                save.setLocation(0, 0);
                int returnval = save.showSaveDialog(this);
                if (returnval == 0) {
                    File file = save.getSelectedFile();
                    parentfile = file.getParentFile().getName();
                    filename = file.getName();
                    File newfile = save.getCurrentDirectory();
                    this.save(file);
                }
                if (filename == null) {
                    return;
                }
                return;
            }
            if (arg.equals("View/Edit Text Representation")) {
                String textRep = this.createCanvas.getXML(this.filename);
                TextFrame tf = new TextFrame(this, textRep);
                return;
            }
            if (arg.equals("Autoscale")) {
                this.plannerCanvas.autoscale();
            } else if (arg.equals("Extra Large (30 pt)")) {
                this.plannerCanvas.changeFont(30);
                this.createCanvas.changeFont(30);
                this.stateGoalDisplay.setFontSize(30);
            } else if (arg.equals("Large (20 pt)")) {
                this.plannerCanvas.changeFont(30);
                this.createCanvas.changeFont(30);
                this.stateGoalDisplay.setFontSize(20);
            } else if (arg.equals("Medium (12 pt)")) {
                this.plannerCanvas.changeFont(30);
                this.createCanvas.changeFont(30);
                this.stateGoalDisplay.setFontSize(12);
            } else if (arg.equals("Small (9 pt)")) {
                this.plannerCanvas.changeFont(30);
                this.createCanvas.changeFont(30);
                this.stateGoalDisplay.setFontSize(9);
            } else if (arg.equals("others...")) {
                this.plannerCanvas.changeFont(-1);
                this.createCanvas.changeFont(-1);
                this.stateGoalDisplay.setFontSize(this.returnCanvas().getFontSize());
            }
        }
        super.actionPerformed(e);
    }

    public void reorderGoals() {
        this.actionButtonGroup.setSelected(this.tempButton.getModel(), true);
        System.out.println("reorder goals");
        this.reorderGoalsDialog = new ReorderDialog((JFrame)this, this.engine.getWorld().getGoalStateVector(), "Goal");
        this.reorderGoalsDialog.open();
        this.engine.getWorld().setChanged();
        this.engine.getWorld().notifyObservers();
    }

    public void autoSearch() {
        this.solveButModes[0].setEnabled(false);
        this.solveButModes[2].setEnabled(true);
        this.solveModeButGroup.setSelected(this.tempButton.getModel(), true);
    }

    public void stop() {
        this.solveButModes[0].setEnabled(true);
        this.solveButModes[2].setEnabled(false);
        this.solveModeButGroup.setSelected(this.tempButton.getModel(), true);
    }

    public void resetGraph() {
        this.setPromptLabel("");
        this.solveButModes[0].setEnabled(true);
        this.solveButModes[2].setEnabled(false);
    }

    public void resetCurrentStateDisplay() {
        BlockGraph initialGraph = this.createCanvas.getInitialGraph();
        BlockGraph goalGraph = null;
        if (this.isGraphicalGoalMode) {
            goalGraph = this.createCanvas.getGoalGraph();
        }
        this.currentStateDisplay.reset(initialGraph, goalGraph);
    }

    public void resetPlanVisualizer() {
        BlockGraph initialGraph = this.createCanvas.getInitialGraph();
        BlockGraph goalGraph = null;
        if (this.isGraphicalGoalMode) {
            goalGraph = this.createCanvas.getGoalGraph();
        }
        this.planVisualizer.reset(initialGraph, goalGraph);
    }

    protected void switchGoalEntryMode(boolean userRequestedGraphical) {
        ConfirmContinueDialog ccd;
        if (this.isGraphicalGoalMode && !userRequestedGraphical && (ccd = new ConfirmContinueDialog(this, "Confirm Goal Input Method Change", "Warning: The visual representation of the goals will no longer be available. Are you sure you want to continue?", 3, 40)).getResult() != 101) {
            this.setGoalEntryMethodCheckboxes(this.isGraphicalGoalMode);
            return;
        }
        if (!this.isGraphicalGoalMode && userRequestedGraphical) {
            ccd = new ConfirmContinueDialog(this, "Confirm Goal Input Method Change", "Warning: The current goals will be reset to the initial state.  Are you sure you want to continue?", 3, 40);
            if (ccd.getResult() == 101) {
                this.createCanvas.setGoalStateValid(false);
                this.engine.getWorld().clearState(201);
            } else {
                this.setGoalEntryMethodCheckboxes(this.isGraphicalGoalMode);
                return;
            }
        }
        this.isGraphicalGoalMode = userRequestedGraphical;
        this.goalModeSelected = true;
        this.setGoalEntryMethodCheckboxes(this.isGraphicalGoalMode);
        if (this.createButModes[0].isEnabled()) {
            this.goToCreateInitialMode();
        } else {
            this.goToSpecifyGoalsMode();
        }
    }

    protected void setGoalEntryMethodCheckboxes(boolean isGraphicalGoalMode) {
        if (isGraphicalGoalMode) {
            this.visualGoalEntry.setSelected(true);
            this.atomGoalEntry.setSelected(false);
        } else {
            this.visualGoalEntry.setSelected(false);
            this.atomGoalEntry.setSelected(true);
        }
    }

    protected JMenu createHelpMenu() {
        return new HelpMenu(this.applet, "planning", this);
    }

    protected void goToCreateInitialMode() {
        if (this.isGraphicalGoalMode) {
            this.createCanvas.enableGoalReset(true);
        } else {
            this.createCanvas.enableGoalReset(false);
        }
        this.initialStateButton.setSelected(true);
        this.setControlsInitial(true);
        this.createCanvas.showInitialState();
        this.createCanvas.setCreateSubMode(200);
        this.setPromptLabel("Initial State");
        this.createButModes[0].setEnabled(true);
        this.createButModes[1].setEnabled(true);
        this.createButModes[2].setEnabled(true);
        this.createButModes[4].setEnabled(false);
        this.createButModes[5].setEnabled(false);
    }

    protected void goToSpecifyGoalsMode() {
        if (!this.goalModeSelected) {
            GoalEntryMethodSelectDialog dialog = new GoalEntryMethodSelectDialog(this, this.isGraphicalGoalMode);
            int response = dialog.getResponse();
            dialog.dispose();
            if (response == 100) {
                this.isGraphicalGoalMode = true;
                this.goalModeSelected = true;
                this.visualGoalEntry.setSelected(true);
                this.createButModes[4].setEnabled(false);
                this.createButModes[5].setEnabled(false);
            } else if (response == 101) {
                this.isGraphicalGoalMode = false;
                this.goalModeSelected = true;
                this.atomGoalEntry.setSelected(false);
                this.createButModes[4].setEnabled(true);
                this.createButModes[5].setEnabled(true);
            } else if (response == 102) {
                this.goalModeSelected = false;
                return;
            }
        }
        this.setControlsInitial(false);
        this.createCanvas.setCreateSubMode(201);
        if (this.isGraphicalGoalMode) {
            this.createCanvas.showGoalState();
            this.setGoalEntryMethodCheckboxes(true);
            this.setPromptLabel("Goal State");
        } else {
            this.setGoalEntryMethodCheckboxes(false);
            this.createButModes[4].setEnabled(true);
            this.createButModes[5].setEnabled(true);
            this.createCanvas.showInitialState();
            this.setPromptLabel("Initial State");
        }
    }

    private void setControlsInitial(boolean isInitialState) {
        if (this.isGraphicalGoalMode) {
            this.validate();
            this.createCanvas.unpause();
        } else {
            this.validate();
            if (!isInitialState) {
                this.createCanvas.pause();
            } else {
                this.createCanvas.unpause();
            }
        }
    }

    protected void enableControlPanel(boolean enable) {
        this.addGoalButton.setEnabled(enable);
        this.removeGoalButton.setEnabled(enable);
    }

    protected void setBlockOptionsEnabled(boolean enable) {
    }

    public void autoSolveEnd() {
        this.autoSolve = null;
        this.solveButModes[2].setEnabled(false);
    }

    public void autoSolveStart() {
    }

    protected void setCanvas(GraphCanvas newCanvas) {
        if (newCanvas instanceof BlockCanvas) {
            this.canvasPanel.remove(this.scrollPanel);
            this.addComponent(this.createScroll, this.canvasPanel, 1, 0, 1, 1, 1.0, 1.0);
            this.tabbedPane.setComponentAt(0, this.emptyPanel1);
            this.tabbedPane.setComponentAt(1, this.emptyPanel2);
            this.tabbedPane.setComponentAt(0, this.canvasPanel);
            this.tabbedPane.setSelectedIndex(0);
        } else {
            this.canvasPanel.remove(this.createScroll);
            this.addComponent(this.scrollPanel, this.canvasPanel, 1, 0, 1, 1, 1.0, 1.0);
            this.tabbedPane.setComponentAt(0, this.emptyPanel1);
            this.tabbedPane.setComponentAt(1, this.emptyPanel2);
            this.tabbedPane.setComponentAt(1, this.canvasPanel);
            this.tabbedPane.setSelectedIndex(1);
        }
        this.canvas = newCanvas;
    }

    public void load(String filename) {
        this.load("CIspace/planning/saves/", filename);
    }

    public void load(String dir, String filename) {
        try {
            this.filename = filename;
            if (this.applet != null) {
                URL url = new URL(this.applet.getCodeBase() + dir + filename);
                InputStream iStream = url.openStream();
                this.load(new BufferedReader(new InputStreamReader(iStream)));
            } else {
                this.load(new BufferedReader(new FileReader(String.valueOf(dir) + filename)));
            }
        }
        catch (Exception e) {
            filename = null;
            this.showMessage("Error", e.toString());
        }
    }

    public void load(BufferedReader in) {
        try {
            String all = "";
            String errMsg = "";
            String line = in.readLine();
            while (line != null) {
                all = String.valueOf(all) + line + "\n";
                line = in.readLine();
            }
            in.close();
            if (this.currentStateDisplay != null) {
                this.currentStateDisplay.dispose();
                this.currentStateDisplay = null;
            }
            if (this.planVisualizer != null) {
                this.planVisualizer.dispose();
                this.planVisualizer = null;
            }
            if (this.planDisplay != null) {
                this.planDisplay.dispose();
                this.planDisplay = null;
            }
            this.engine.loadProblem(all);
            this.plannerCanvas.initialize();
            if (this.createCanvas.getGoalGraph().numNodes() > 0) {
                this.isGraphicalGoalMode = true;
                this.visualGoalEntry.setSelected(true);
            } else {
                this.isGraphicalGoalMode = false;
                this.atomGoalEntry.setSelected(true);
            }
            this.goalModeSelected = true;
            this.setTitle(String.valueOf(this.title) + " --- " + this.filename);
            this.goToCreateInitialMode();
            if (!(this.canvas instanceof BlockCanvas)) {
                this.canvas.moveToTopMiddle();
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            this.showMessage("Error", e.toString());
            return;
        }
    }

    public void load(File file) {
        try {
            if (this.applet != null) {
                URL url = new URL(this.applet.getCodeBase() + file.getPath());
                InputStream iStream = url.openStream();
                this.load(new BufferedReader(new InputStreamReader(iStream)));
            } else {
                this.load(new BufferedReader(new FileReader(file.getPath())));
            }
        }
        catch (Exception e) {
            this.filename = null;
            this.showMessage("Error", e.toString());
        }
    }

    public void save(String dir, String filename) {
        if (!filename.endsWith(this.extension)) {
            filename = String.valueOf(filename) + this.extension;
        }
        try {
            FileOutputStream fos = new FileOutputStream(String.valueOf(dir) + filename);
            PrintWriter out = new PrintWriter(fos);
            out.println(this.createCanvas.getXML(filename));
            out.close();
            this.setTitle(String.valueOf(this.title) + " --- " + filename);
        }
        catch (FileNotFoundException e) {
            System.out.println(e);
        }
    }

    public void save(File file) {
        if (!file.getName().endsWith(".xml")) {
            file = new File(String.valueOf(file.getAbsolutePath()) + ".xml");
        }
        try {
            FileOutputStream fos = new FileOutputStream(file);
            PrintWriter out = new PrintWriter(fos);
            out.println(this.createCanvas.getXML(this.filename));
            out.close();
            if (file.getName() != "undo.xml") {
                this.setTitle("Search Applet Version  --- " + this.filename);
            }
        }
        catch (FileNotFoundException e) {
            System.out.println(e);
        }
    }

    public void notifyBacktrack() {
        if (this.currentStateDisplay != null) {
            this.resetCurrentStateDisplay();
        }
    }

    public void showMessage(String title, String msg) {
        MessageDialog messageDialog = new MessageDialog(this);
        messageDialog.open(title, msg);
    }

    public static void main(String[] args) {
        PlanningWindow window = new PlanningWindow(null);
    }
}

