/*
 * Decompiled with CFR 0.152.
 */
package CIspace.planning;

import CIspace.XMLReader.XMLBlock;
import CIspace.XMLReader.XMLTree;
import CIspace.planning.Action;
import CIspace.planning.Atom;
import CIspace.planning.DefiniteClause;
import CIspace.planning.LogicParser;
import CIspace.planning.Term;
import CIspace.planning.Variable;
import CIspace.planning.World;
import java.util.StringTokenizer;
import java.util.Vector;

public class PlanningProblemParser {
    protected World world;
    protected XMLBlock headBlock;
    protected LogicParser parser;

    public PlanningProblemParser(String xmlFile, World world) {
        this.world = world;
        XMLTree xmlTree = new XMLTree();
        xmlTree.readString(xmlFile);
        this.headBlock = xmlTree.getHead();
        this.parser = new LogicParser(xmlFile);
    }

    public void parse() {
        this.world.clearAllState();
        this.world.clearActions();
        this.parseState("InitialState");
        this.parseState("Goals");
        this.parseActions();
    }

    protected void parseState(String stateType) {
        Vector xmlBlockVector = null;
        XMLBlock xmlBlock = this.headBlock;
        xmlBlockVector = xmlBlock.searchChildTag("Problem");
        if (xmlBlockVector == null) {
            return;
        }
        xmlBlock = (XMLBlock)xmlBlockVector.elementAt(0);
        if ((xmlBlockVector = xmlBlock.searchChildTag(stateType)) == null) {
            return;
        }
        xmlBlock = (XMLBlock)xmlBlockVector.elementAt(0);
        if ((xmlBlockVector = xmlBlock.searchChildTag("LogicProgram")) == null) {
            return;
        }
        xmlBlock = (XMLBlock)xmlBlockVector.elementAt(0);
        String logicProgram = xmlBlock.getText();
        this.parser.setLogicProgram(logicProgram);
        Vector clauses = this.parser.parseLogicProgram();
        int i = 0;
        while (i < clauses.size()) {
            DefiniteClause currClause = (DefiniteClause)clauses.elementAt(i);
            if (stateType.equals("InitialState")) {
                this.world.addStateItem(currClause, 200);
            } else {
                this.world.addStateItem(currClause, 201);
            }
            ++i;
        }
    }

    public void parseActions() {
        Vector xmlBlockVector = null;
        XMLBlock xmlBlock = this.headBlock;
        xmlBlockVector = xmlBlock.searchChildTag("Problem");
        if (xmlBlockVector == null) {
            return;
        }
        xmlBlock = (XMLBlock)xmlBlockVector.elementAt(0);
        Vector actionBlockVector = xmlBlock.searchChildTag("Action");
        if (actionBlockVector == null) {
            return;
        }
        int i = 0;
        while (i < actionBlockVector.size()) {
            String action = "";
            String preconditions = "";
            String addList = "";
            String deleteList = "";
            Vector logicTagVector = null;
            xmlBlock = (XMLBlock)actionBlockVector.elementAt(i);
            xmlBlockVector = xmlBlock.searchChildTag("LogicProgram");
            if (xmlBlockVector != null) {
                XMLBlock preconditionBlock;
                XMLBlock logicBlock = (XMLBlock)xmlBlockVector.elementAt(0);
                action = logicBlock.getText();
                xmlBlockVector = xmlBlock.searchChildTag("Preconditions");
                if (xmlBlockVector != null && (logicTagVector = (preconditionBlock = (XMLBlock)xmlBlockVector.elementAt(0)).searchChildTag("LogicProgram")) != null) {
                    XMLBlock addListBlock;
                    preconditions = ((XMLBlock)logicTagVector.elementAt(0)).getText();
                    xmlBlockVector = xmlBlock.searchChildTag("AddList");
                    if (xmlBlockVector != null && (logicTagVector = (addListBlock = (XMLBlock)xmlBlockVector.elementAt(0)).searchChildTag("LogicProgram")) != null) {
                        Action newAction;
                        XMLBlock deleteListBlock;
                        addList = ((XMLBlock)logicTagVector.elementAt(0)).getText();
                        xmlBlockVector = xmlBlock.searchChildTag("DeleteList");
                        if (xmlBlockVector != null && (logicTagVector = (deleteListBlock = (XMLBlock)xmlBlockVector.elementAt(0)).searchChildTag("LogicProgram")) != null && (newAction = this.parseAction(action, preconditions, addList, deleteList = ((XMLBlock)logicTagVector.elementAt(0)).getText())) != null) {
                            this.world.addAction(newAction);
                        }
                    }
                }
            }
            ++i;
        }
    }

    protected Action parseAction(String action, String preconditions, String addList, String deleteList) {
        Vector<Variable> variables = new Vector<Variable>();
        Vector<Term> terms = new Vector<Term>();
        action = action.trim();
        preconditions = preconditions.trim();
        addList = addList.trim();
        deleteList = deleteList.trim();
        String actionName = action.substring(0, action.indexOf("("));
        action = action.substring(action.indexOf("(") + 1, action.indexOf(")"));
        StringTokenizer termTokenizer = new StringTokenizer(action, " ,", false);
        while (termTokenizer.hasMoreTokens()) {
            String term = termTokenizer.nextToken();
            boolean found = false;
            int i = 0;
            while (i < variables.size()) {
                Variable currVar = (Variable)variables.elementAt(i);
                if (currVar.toString().equals(term)) {
                    terms.addElement(new Term(currVar));
                    found = true;
                }
                ++i;
            }
            if (found) continue;
            Variable newVariable = new Variable(term);
            Term newTerm = new Term(newVariable);
            terms.addElement(newTerm);
            variables.addElement(newVariable);
        }
        Action newAction = new Action(actionName, terms.size());
        int i = 0;
        while (i < terms.size()) {
            newAction.setTerm(i, (Term)terms.elementAt(i));
            ++i;
        }
        LogicParser actionParser = new LogicParser("");
        actionParser.setLogicProgram(preconditions);
        Vector precondVec = actionParser.parseLogicProgram(new Vector(), variables);
        actionParser.setLogicProgram(addList);
        Vector addListVec = actionParser.parseLogicProgram(new Vector(), variables);
        actionParser.setLogicProgram(deleteList);
        Vector deleteListVec = actionParser.parseLogicProgram(new Vector(), variables);
        int i2 = 0;
        while (i2 < precondVec.size()) {
            newAction.addPrecondition((Atom)precondVec.elementAt(i2));
            ++i2;
        }
        i2 = 0;
        while (i2 < addListVec.size()) {
            newAction.addAddListItem((Atom)addListVec.elementAt(i2));
            ++i2;
        }
        i2 = 0;
        while (i2 < deleteListVec.size()) {
            newAction.addDeleteListItem((Atom)deleteListVec.elementAt(i2));
            ++i2;
        }
        return newAction;
    }
}

