/*
 * Decompiled with CFR 0.152.
 */
package CIspace.planning;

import CIspace.planning.Atom;
import CIspace.planning.BlockAnimatorCanvas;
import CIspace.planning.BlockGraph;
import CIspace.planning.DialogAdapter;
import CIspace.planning.PlanningWindow;
import CIspace.planning.World;
import CIspace.planning.WorldListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class PlanVisualizer
extends DialogAdapter
implements WorldListener {
    protected World world;
    protected PlanningWindow window;
    protected JTextArea stateText;
    protected BlockAnimatorCanvas canvas;
    protected JScrollBar vbar;
    protected BlockGraph initialGraph;
    protected BlockGraph goalGraph;
    protected JButton runButton;
    protected JButton stopButton;
    protected JButton resetButton;

    public PlanVisualizer(PlanningWindow parent, World world, BlockGraph initialGraph, BlockGraph goalGraph) {
        super(parent, "Run Current Plan", false);
        this.window = parent;
        this.world = world;
        this.initialGraph = initialGraph;
        this.goalGraph = goalGraph;
        this.canvas = new BlockAnimatorCanvas(parent, false, world, initialGraph, goalGraph, 301);
        this.constructWindow();
        this.pack();
        ((Component)this).setSize(500, 400);
        this.centerWindow();
        this.show();
        this.canvas.repaint();
    }

    protected void constructWindow() {
        JPanel mainPanel = new JPanel(new BorderLayout());
        JScrollPane canvasScroll = new JScrollPane(this.canvas, 22, 31);
        mainPanel.add("Center", canvasScroll);
        mainPanel.add("South", this.makeButtonPanel());
        this.getContentPane().add(mainPanel);
    }

    protected JPanel makeButtonPanel() {
        JPanel buttonPanel = new JPanel();
        JButton closeButton = new JButton("Close");
        closeButton.addActionListener(this);
        this.runButton = new JButton("Run Current Plan");
        this.runButton.addActionListener(this);
        this.stopButton = new JButton("Stop");
        this.stopButton.addActionListener(this);
        this.resetButton = new JButton("Reset");
        this.resetButton.addActionListener(this);
        buttonPanel.add(this.runButton);
        buttonPanel.add(this.stopButton);
        buttonPanel.add(this.resetButton);
        buttonPanel.add(closeButton);
        return buttonPanel;
    }

    public void reset(BlockGraph initialGraph, BlockGraph goalGraph) {
        this.canvas.reset(initialGraph, goalGraph);
        this.canvas.graph.repaint();
        this.repaint();
        this.canvas.repaint();
    }

    public void update() {
        this.updateDisplay();
    }

    protected void updateDisplay() {
        this.stateText.setText("");
        Vector state = this.world.getCurrentState();
        int i = 0;
        while (i < state.size()) {
            String planStep = ((Atom)state.elementAt(i)).toString();
            this.stateText.setText(String.valueOf(this.stateText.getText()) + planStep + "\n");
            ++i;
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand() == "Close") {
            this.closeWindow();
        } else if (e.getActionCommand() == "Run Current Plan") {
            this.canvas.runPlan();
        } else if (e.getActionCommand() == "Stop") {
            this.canvas.stop();
        } else if (e.getActionCommand() == "Reset") {
            this.reset(this.initialGraph, this.goalGraph);
        }
    }

    protected void closeWindow() {
        this.world.removeListener(this);
        this.canvas.finalize();
        this.dispose();
    }

    public void windowClosing(WindowEvent e) {
        this.closeWindow();
    }
}

