/*
 * Decompiled with CFR 0.152.
 */
package CIspace.planning;

import CIspace.planning.Atom;
import CIspace.planning.DialogAdapter;
import CIspace.planning.World;
import CIspace.planning.WorldListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public class PlanDisplay
extends DialogAdapter
implements WorldListener {
    protected World world;
    protected JTextArea planText;

    public PlanDisplay(JFrame parent, World world) {
        super(parent, "Current Plan", false);
        this.world = world;
        world.addListener(this);
        this.constructDialog();
        this.updateDisplay();
        this.pack();
        this.centerWindow();
        this.show();
    }

    protected void constructDialog() {
        JPanel mainPanel = new JPanel(new BorderLayout());
        this.planText = new JTextArea("", 8, 24);
        this.planText.setEditable(false);
        this.planText.setBackground(Color.lightGray);
        mainPanel.add("Center", this.planText);
        mainPanel.add("South", this.makeButtonPanel());
        this.getContentPane().add(mainPanel);
    }

    protected JPanel makeButtonPanel() {
        JButton runPlanButton = new JButton("Run Plan");
        runPlanButton.addActionListener(this);
        JButton closeButton = new JButton("Close");
        closeButton.addActionListener(this);
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(closeButton);
        return buttonPanel;
    }

    public void update() {
        this.updateDisplay();
    }

    protected void updateDisplay() {
        this.planText.setText("");
        Vector plan = this.world.getPlan();
        int i = 0;
        while (i < plan.size()) {
            String planStep = ((Atom)plan.elementAt(i)).toString();
            this.planText.setText(String.valueOf(this.planText.getText()) + planStep + "\n");
            ++i;
        }
        if (this.planText.getText().equals("")) {
            this.planText.setText("<no actions>");
        }
    }

    protected void closeWindow() {
        this.world.removeListener(this);
        this.dispose();
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand() == "Close") {
            this.closeWindow();
        }
    }

    public void windowClosing(WindowEvent e) {
        this.closeWindow();
    }
}

