/*
 * Decompiled with CFR 0.152.
 */
package CIspace.planning;

public class PermutationGenerator {
    private int[] a;
    private long numLeft;
    private long total;

    public PermutationGenerator(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("Min 1");
        }
        this.a = new int[n];
        this.total = PermutationGenerator.getFactorial(n);
        this.reset();
    }

    public void reset() {
        int i = 0;
        while (i < this.a.length) {
            this.a[i] = i;
            ++i;
        }
        this.numLeft = this.total;
    }

    public long getNumLeft() {
        return this.numLeft;
    }

    public long getTotal() {
        return this.total;
    }

    public boolean hasMore() {
        return this.numLeft > 0L;
    }

    private static long getFactorial(int n) {
        long fact = 1L;
        int i = n;
        while (i > 1) {
            fact *= (long)i;
            --i;
        }
        return fact;
    }

    public int[] getNext() {
        if (this.numLeft == this.total) {
            --this.numLeft;
            return this.a;
        }
        int j = this.a.length - 2;
        while (this.a[j] > this.a[j + 1]) {
            --j;
        }
        int k = this.a.length - 1;
        while (this.a[j] > this.a[k]) {
            --k;
        }
        int temp = this.a[k];
        this.a[k] = this.a[j];
        this.a[j] = temp;
        int r = this.a.length - 1;
        int s = j + 1;
        while (r > s) {
            temp = this.a[s];
            this.a[s] = this.a[r];
            this.a[r] = temp;
            --r;
            ++s;
        }
        --this.numLeft;
        return this.a;
    }
}

