/*
 * Decompiled with CFR 0.152.
 */
package CIspace.planning;

import CIspace.planning.Action;
import CIspace.planning.DialogAdapter;
import CIspace.planning.ReorderDialog;
import CIspace.planning.World;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class OrderPreconditionsDialog
extends DialogAdapter
implements ItemListener {
    protected World world;
    protected JComboBox actionChoice;
    protected JPanel shiftPanel;
    protected JFrame window;

    public OrderPreconditionsDialog(JFrame parent, World world) {
        super(parent, "Set Default Precondition Order", true);
        this.world = world;
        this.window = parent;
        this.gbl = new GridBagLayout();
        this.gbc = new GridBagConstraints();
        this.gbc.anchor = 18;
        this.gbc.fill = 1;
        this.fillActionChoice();
        this.constructDialog();
        String actionName = (String)this.actionChoice.getSelectedItem();
        this.showShiftPanel(actionName);
        this.pack();
        this.centerWindow();
        this.show();
    }

    protected void fillActionChoice() {
        this.actionChoice = new JComboBox();
        this.actionChoice.addItemListener(this);
        Vector actions = this.world.getActions();
        int i = 0;
        while (i < actions.size()) {
            Action currAction = (Action)actions.elementAt(i);
            this.actionChoice.addItem(currAction.getName());
            ++i;
        }
    }

    protected void constructDialog() {
        JPanel mainPanel = new JPanel();
        this.shiftPanel = new JPanel();
        this.addComponent(new JLabel("Choose Action: "), mainPanel, 0, 0, 1, 1, 1.0, 1.0);
        this.addComponent(this.actionChoice, mainPanel, 0, 1, 1, 1, 1.0, 1.0);
        this.addComponent(new JLabel(""), mainPanel, 1, 0, 2, 1, 1.0, 1.0);
        this.addComponent(this.shiftPanel, mainPanel, 2, 0, 2, 1, 1.0, 1.0);
        this.addComponent(this.makeButtonPanel(), mainPanel, 3, 0, 2, 1, 1.0, 1.0);
        mainPanel.setLayout(this.gbl);
        this.add(mainPanel);
    }

    protected JPanel makeButtonPanel() {
        JPanel buttonPanel = new JPanel();
        JButton closeButton = new JButton("Close");
        closeButton.addActionListener(this);
        buttonPanel.add(closeButton);
        return buttonPanel;
    }

    protected void showShiftPanel(String actionName) {
        Action action = this.world.getActionByName(actionName);
        Vector preconditions = action.getPreconditions();
        ReorderDialog rDialog = new ReorderDialog(this.window, preconditions, "Precondition");
        this.shiftPanel.removeAll();
        this.shiftPanel.add(rDialog.getPanel());
        this.shiftPanel.validate();
    }

    public void itemStateChanged(ItemEvent e) {
        String actionName = (String)this.actionChoice.getSelectedItem();
        this.showShiftPanel(actionName);
    }

    protected void closeWindow() {
        this.dispose();
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand() == "Close") {
            this.closeWindow();
        }
    }

    public void windowClosing(WindowEvent e) {
        this.closeWindow();
    }
}

