/*
 * Decompiled with CFR 0.152.
 */
package CIspace.planning;

import CIspace.planning.Action;
import CIspace.planning.Atom;
import CIspace.planning.DefiniteClause;
import CIspace.planning.DialogAdapter;
import CIspace.planning.StripsNode;
import CIspace.planning.Substitution;
import CIspace.planning.Term;
import CIspace.planning.Variable;
import java.awt.BorderLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public class NodeInfoDialog
extends DialogAdapter {
    protected StripsNode node;

    public NodeInfoDialog(JFrame parent, StripsNode node) {
        super(parent, "Node Information", true);
        this.node = node;
        if (node.isRoot()) {
            return;
        }
        this.constructWindow();
        this.pack();
        this.centerWindow();
        this.show();
    }

    protected void constructWindow() {
        JPanel mainPanel = new JPanel(new BorderLayout());
        JPanel centerPanel = null;
        centerPanel = this.node.getType() == 102 ? this.makeActionNodeInfoPanel() : this.makeGoalNodeInfoPanel();
        mainPanel.add("Center", centerPanel);
        mainPanel.add("South", this.makeButtonPanel());
        this.getContentPane().add(mainPanel);
    }

    protected JPanel makeActionNodeInfoPanel() {
        JPanel infoPanel = new JPanel(new GridLayout(3, 1));
        String actionLabel = new String("");
        actionLabel = String.valueOf(actionLabel) + "Action: " + this.node.getValue().toString();
        infoPanel.add(new JLabel(actionLabel));
        infoPanel.add(new JLabel("Add List: " + this.makeListString(this.node.getAddList())));
        infoPanel.add(new JLabel("Delete List: " + this.makeListString(this.node.getDeleteList())));
        return infoPanel;
    }

    protected JPanel makeGoalNodeInfoPanel() {
        JPanel infoPanel = new JPanel(new GridLayout(2, 1));
        JPanel topPanel = new JPanel(new BorderLayout());
        JPanel bottomPanel = new JPanel(new BorderLayout());
        topPanel.add("North", new JLabel("Goal: " + this.node.getGoalString()));
        topPanel.add("Center", this.getGoalTruthPanel());
        infoPanel.add(topPanel);
        bottomPanel.add("North", new JLabel("Candidate Actions"));
        bottomPanel.add("Center", this.getActionsAttemptedPanel());
        infoPanel.add(bottomPanel);
        return infoPanel;
    }

    protected JPanel getGoalTruthPanel() {
        JPanel truthPanel = new JPanel();
        if (this.node.isAchieved()) {
            JTextArea truthText = new JTextArea(5, 50);
            truthText.setText(this.makeTruthString());
            truthPanel.add(truthText);
        } else {
            truthPanel.add(new JLabel("This goal has not been achieved"));
        }
        return truthPanel;
    }

    protected String makeTruthString() {
        if (!this.node.potentialClausesStored()) {
            return this.makeNoSubTruthString();
        }
        boolean actionsAttempted = true;
        Vector actions = this.node.getPotentialActions();
        int currentAction = this.node.getNextActionIndex() - 1;
        if (actions == null || actions.size() == 0) {
            actionsAttempted = false;
        }
        Vector appliedClauses = this.node.getAppliedClauses();
        Vector appliedClauseSubs = this.node.getAppliedClauseSubs();
        Vector appliedClauseStatus = this.node.getAppliedClauseStatus();
        String output = "";
        int i = 0;
        while (i < appliedClauses.size()) {
            DefiniteClause currClause = (DefiniteClause)appliedClauses.elementAt(i);
            Substitution sub = (Substitution)appliedClauseSubs.elementAt(i);
            int status = (Integer)appliedClauseStatus.elementAt(i);
            if (status != 202) {
                output = String.valueOf(output) + this.node.getGoalString() + " unifies with " + currClause;
                if (sub.numSubstitutions() > 0) {
                    output = String.valueOf(output) + " with the substitution: {";
                    Vector vars = sub.getSubstitutionClones();
                    int j = 0;
                    while (j < vars.size()) {
                        Variable currVar = (Variable)vars.elementAt(j);
                        output = String.valueOf(output) + currVar.getVarName() + "/" + currVar;
                        if (j != vars.size() - 1) {
                            output = String.valueOf(output) + ", ";
                        }
                        ++j;
                    }
                    output = String.valueOf(output) + "}.";
                } else {
                    output = String.valueOf(output) + " with no substitution";
                }
                if (!actionsAttempted) {
                    output = String.valueOf(output) + " in the current state.";
                }
                output = status == 200 ? String.valueOf(output) + " -- failed" : String.valueOf(output) + " -- currently selected";
            } else {
                output = String.valueOf(output) + currClause + " -- available";
            }
            output = String.valueOf(output) + "\n";
            ++i;
        }
        return output;
    }

    protected String makeNoSubTruthString() {
        boolean actionsAttempted = true;
        Vector actions = this.node.getPotentialActions();
        int currentAction = this.node.getNextActionIndex() - 1;
        if (actions == null || actions.size() == 0) {
            actionsAttempted = false;
        }
        String output = "";
        if (this.node.getClauseUnifiedWith() == null) {
            output = actionsAttempted ? String.valueOf(this.node.getGoalString()) + " unifies with " + this.node.getGoalString() + " with no substitutions." : String.valueOf(this.node.getGoalString()) + " unifies with " + this.node.getGoalString() + " with no substitutions in the current state.";
            return output;
        }
        output = String.valueOf(this.node.getGoalString()) + " unifies with " + this.node.getClauseUnifiedWith();
        Atom goalAtom = this.node.getValue();
        Vector<Variable> boundVariables = new Vector<Variable>();
        boolean[] isBoundInitially = this.node.getIsBoundInitially();
        int i = 0;
        while (i < goalAtom.getNumTerms()) {
            Term currTerm = goalAtom.getTermAt(i);
            if (currTerm.getType() == 101 && currTerm.getVariable().isBound() && !isBoundInitially[i]) {
                boundVariables.addElement(currTerm.getVariable());
            }
            ++i;
        }
        if (boundVariables.size() == 0) {
            output = String.valueOf(output) + " with no substitutions";
        } else {
            output = String.valueOf(output) + " with the substitution: {";
            i = 0;
            while (i < boundVariables.size()) {
                Variable currVar = (Variable)boundVariables.elementAt(i);
                output = String.valueOf(output) + currVar.getVarName() + "/" + currVar;
                if (i != boundVariables.size() - 1) {
                    output = String.valueOf(output) + ", ";
                }
                ++i;
            }
            output = String.valueOf(output) + " }";
        }
        if (!actionsAttempted) {
            output = String.valueOf(output) + " in the current state.";
        }
        return output;
    }

    protected String makeListString(Vector atomVec) {
        String list = "";
        int i = 0;
        while (i < atomVec.size()) {
            Atom currAtom = (Atom)atomVec.elementAt(i);
            list = String.valueOf(list) + currAtom;
            if (i != atomVec.size() - 1) {
                list = String.valueOf(list) + ", ";
            }
            ++i;
        }
        return list;
    }

    protected JPanel getActionsAttemptedPanel() {
        JPanel actionPanel = new JPanel();
        String actionString = "";
        Vector actions = this.node.getPotentialActions();
        int currentAction = this.node.getNextActionIndex() - 1;
        if (actions == null || actions.size() == 0) {
            actionString = "No actions attempted";
        } else {
            int i = 0;
            while (i < actions.size()) {
                Action currAction = (Action)actions.elementAt(i);
                actionString = String.valueOf(actionString) + currAction.getStringRep();
                actionString = i < currentAction ? String.valueOf(actionString) + " -- failed." : (i == currentAction ? String.valueOf(actionString) + " -- currently selected." : String.valueOf(actionString) + " -- unattempted.");
                actionString = String.valueOf(actionString) + "\n";
                ++i;
            }
        }
        JTextArea actionText = new JTextArea(5, 50);
        actionText.setText(actionString);
        actionPanel.add(actionText);
        return actionPanel;
    }

    protected JPanel makeButtonPanel() {
        JButton closeButton = new JButton("Close");
        closeButton.addActionListener(this);
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(closeButton);
        return buttonPanel;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand() == "Close") {
            this.dispose();
        }
    }
}

