/*
 * Decompiled with CFR 0.152.
 */
package CIspace.planning;

import CIspace.planning.Atom;
import CIspace.planning.Predicate;
import CIspace.planning.StringConstant;
import CIspace.planning.Term;
import CIspace.planning.Variable;
import java.util.StringTokenizer;
import java.util.Vector;

public class LogicParser {
    protected String logicProgram;

    public LogicParser(String logicProgram) {
        this.logicProgram = logicProgram;
    }

    public void setLogicProgram(String logicProgram) {
        this.logicProgram = logicProgram;
    }

    public Vector parseLogicProgram() {
        return this.parseLogicProgram(new Vector(), new Vector());
    }

    public Vector parseLogicProgram(Vector constants, Vector variables) {
        Vector<Atom> program = new Vector<Atom>();
        StringTokenizer logicTokenStream = new StringTokenizer(this.logicProgram, "\t\n", false);
        while (logicTokenStream.hasMoreTokens()) {
            Atom newAtom;
            String token = logicTokenStream.nextToken();
            if (token.equals("")) continue;
            int openParen = token.indexOf("(");
            int closeParen = token.indexOf(")");
            int implication = token.indexOf("<-");
            if (implication != -1) {
                System.out.println("Error: Support for rules is not yet implemented");
                continue;
            }
            if (openParen == -1) {
                token = token.substring(0, token.length() - 1);
                newAtom = new Atom(new Predicate(token, 0));
                program.addElement(newAtom);
                continue;
            }
            if (openParen != -1 && closeParen != -1) {
                newAtom = this.parseAtom(token, variables, constants);
                if (newAtom == null) continue;
                program.addElement(newAtom);
                continue;
            }
            System.out.println("Parse error in LogicParser.parseLogicProgram");
        }
        return program;
    }

    protected Atom parseAtom(String token, Vector variables, Vector constants) {
        Vector<Term> terms = new Vector<Term>();
        String predName = token.substring(0, token.indexOf("("));
        token = token.substring(token.indexOf("(") + 1, token.indexOf(")"));
        StringTokenizer termTokenizer = new StringTokenizer(token, " ,", false);
        while (termTokenizer.hasMoreTokens()) {
            boolean found;
            String term = termTokenizer.nextToken();
            String firstChar = term.substring(0, 1);
            if (firstChar.equals(firstChar.toLowerCase())) {
                found = false;
                int i = 0;
                while (i < constants.size()) {
                    Term currTerm = (Term)constants.elementAt(i);
                    if (currTerm.toString().equals(term)) {
                        terms.addElement(currTerm);
                        found = true;
                    }
                    ++i;
                }
                if (found) continue;
                Term newTerm = new Term(new StringConstant(term));
                terms.addElement(newTerm);
                constants.addElement(newTerm);
                continue;
            }
            found = false;
            int i = 0;
            while (i < variables.size()) {
                Variable currVar = (Variable)variables.elementAt(i);
                if (currVar.toString().equals(term)) {
                    terms.addElement(new Term(currVar));
                    found = true;
                }
                ++i;
            }
            if (found) continue;
            Variable newVariable = new Variable(term);
            Term newTerm = new Term(newVariable);
            terms.addElement(newTerm);
            variables.addElement(newVariable);
        }
        Atom newAtom = new Atom(new Predicate(predName, terms.size()));
        int i = 0;
        while (i < terms.size()) {
            newAtom.setTerm(i, terms.elementAt(i));
            ++i;
        }
        return newAtom;
    }
}

