/*
 * Decompiled with CFR 0.152.
 */
package CIspace.planning;

import CIspace.graphToolKit.Point;
import CIspace.planning.AnimatedEntity;
import java.awt.Color;
import java.awt.Graphics;

public class Gripper
implements AnimatedEntity {
    public Point pos;
    protected int width;
    protected int height;
    protected boolean isGripping;
    protected int xAdjust;
    protected int yAdjust;
    protected boolean isAnimating;

    public Gripper(Point pos, int width) {
        this.pos = pos;
        this.height = this.width = width;
        this.isGripping = false;
        this.xAdjust = 0;
        this.yAdjust = 0;
    }

    public void setWidth(int newWidth) {
        this.width = newWidth;
        this.height = (int)((double)this.width * 1.5);
    }

    public void setPosAdjust(int xAdjust, int yAdjust) {
        this.xAdjust = xAdjust;
        this.yAdjust = yAdjust;
    }

    public void setAnimating(boolean isAnimating) {
        this.isAnimating = isAnimating;
    }

    public Point getPos() {
        return this.pos;
    }

    public int getHeight() {
        return this.height / 2;
    }

    protected void draw(Graphics g) {
        int pad = 5;
        g.setColor(Color.gray);
        if (this.pos.y > (float)this.yAdjust) {
            g.fillRect((int)this.pos.x + this.width / 2, this.yAdjust, 3, (int)Math.abs((float)this.yAdjust - this.pos.y) + 4);
        }
        g.fillArc((int)this.pos.x, (int)this.pos.y, this.width, this.height, 0, 180);
    }
}

