/*
 * Decompiled with CFR 0.152.
 */
package CIspace.planning;

import CIspace.planning.DialogAdapter;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class GoalEntryMethodSelectDialog
extends DialogAdapter {
    protected JCheckBoxMenuItem entryMethodGroup;
    protected JCheckBox graphicalCheckbox;
    protected JCheckBox individualCheckbox;
    protected boolean userCancelled = false;
    protected boolean setGraphicalDefault;
    public static final int GRAPHICAL = 100;
    public static final int ENTER_ATOMS = 101;
    public static final int CANCEL = 102;

    public GoalEntryMethodSelectDialog(JFrame parent, boolean setGraphicalDefault) {
        super(parent, "Select Goal Entry Method", true);
        this.setGraphicalDefault = setGraphicalDefault;
        this.gbl = new GridBagLayout();
        this.gbc = new GridBagConstraints();
        this.gbc.anchor = 18;
        this.constructDialog();
        this.pack();
        this.centerWindow();
        this.show();
    }

    protected void constructDialog() {
        JPanel mainPanel = new JPanel();
        this.entryMethodGroup = new JCheckBoxMenuItem();
        JLabel promptLabel = new JLabel("Please select a goal entry method:");
        ButtonGroup group = new ButtonGroup();
        this.graphicalCheckbox = new JCheckBox("Specify goal state by graphically rearranging the initial state", this.setGraphicalDefault);
        group.add(this.graphicalCheckbox);
        this.individualCheckbox = new JCheckBox("Specify goals by entering atoms", !this.setGraphicalDefault);
        group.add(this.individualCheckbox);
        this.gbc.fill = 0;
        this.addComponent(promptLabel, mainPanel, 0, 0, 1, 1, 0.0, 0.0);
        this.addComponent(this.graphicalCheckbox, mainPanel, 1, 0, 1, 1, 0.0, 0.0);
        this.addComponent(this.individualCheckbox, mainPanel, 2, 0, 1, 1, 0.0, 0.0);
        this.gbc.fill = 1;
        this.addComponent(this.makeButtonPanel(), mainPanel, 3, 0, 1, 1, 0.0, 0.0);
        mainPanel.setLayout(this.gbl);
        this.getContentPane().add(mainPanel);
    }

    protected JPanel makeButtonPanel() {
        JPanel buttonPanel = new JPanel();
        JButton okButton = new JButton("Ok");
        okButton.addActionListener(this);
        buttonPanel.add(okButton);
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(this);
        buttonPanel.add(cancelButton);
        return buttonPanel;
    }

    public int getResponse() {
        if (this.userCancelled) {
            return 102;
        }
        if (this.graphicalCheckbox.isSelected()) {
            return 100;
        }
        return 101;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand() == "Ok") {
            ((Component)this).setVisible(false);
        }
        if (e.getActionCommand() == "Cancel") {
            ((Component)this).setVisible(false);
            this.userCancelled = true;
        }
    }

    public void windowClosing(WindowEvent e) {
        ((Component)this).setVisible(false);
        this.userCancelled = true;
    }
}

