/*
 * Decompiled with CFR 0.152.
 */
package CIspace.planning;

import CIspace.planning.Atom;
import CIspace.planning.BlockAnimatorCanvas;
import CIspace.planning.BlockGraph;
import CIspace.planning.DelayThread;
import CIspace.planning.DialogAdapter;
import CIspace.planning.PlanningWindow;
import CIspace.planning.World;
import CIspace.planning.WorldListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class CurrentStateDisplay
extends DialogAdapter
implements WorldListener {
    protected World world;
    protected PlanningWindow window;
    protected JTextArea stateText;
    protected BlockAnimatorCanvas canvas;
    protected JScrollBar vbar;

    public CurrentStateDisplay(PlanningWindow parent, World world, BlockGraph initialGraph, BlockGraph goalGraph) {
        super(parent, "Current State", false);
        this.window = parent;
        this.world = world;
        world.addListener(this);
        this.canvas = new BlockAnimatorCanvas(parent, false, world, initialGraph, goalGraph, 300);
        this.constructWindow();
        this.updateDisplay();
        this.pack();
        ((Component)this).setSize(700, 400);
        this.centerWindow();
        this.show();
        this.canvas.repaint();
        DelayThread delayer = new DelayThread(this.canvas);
        delayer.start();
    }

    protected void constructWindow() {
        JPanel mainPanel = new JPanel(new BorderLayout());
        JScrollPane canvasScroll = new JScrollPane(this.canvas, 22, 32);
        mainPanel.add("West", this.makeTextDisplayPanel());
        mainPanel.add("Center", canvasScroll);
        mainPanel.add("South", this.makeButtonPanel());
        this.getContentPane().add(mainPanel);
    }

    protected JPanel makeTextDisplayPanel() {
        JPanel textDisplayPanel = new JPanel(new BorderLayout());
        this.stateText = new JTextArea("", 10, 18);
        this.stateText.setEditable(false);
        this.stateText.setBackground(Color.lightGray);
        textDisplayPanel.add("Center", this.stateText);
        return textDisplayPanel;
    }

    protected JPanel makeButtonPanel() {
        JPanel buttonPanel = new JPanel();
        JButton closeButton = new JButton("Close");
        JButton stepButton = new JButton("Step");
        stepButton.addActionListener(this.window);
        buttonPanel.add(stepButton);
        closeButton.addActionListener(this);
        buttonPanel.add(closeButton);
        return buttonPanel;
    }

    public void reset(BlockGraph initialGraph, BlockGraph goalGraph) {
        this.canvas.reset(initialGraph, goalGraph);
        this.updateDisplay();
        DelayThread delayer = new DelayThread(this.canvas);
        delayer.start();
    }

    public void update() {
        this.updateDisplay();
    }

    protected void updateDisplay() {
        this.stateText.setText("");
        Vector state = this.world.getCurrentState();
        int i = 0;
        while (i < state.size()) {
            String planStep = ((Atom)state.elementAt(i)).toString();
            this.stateText.setText(String.valueOf(this.stateText.getText()) + planStep + "\n");
            ++i;
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand() == "Close") {
            this.closeWindow();
        }
    }

    protected void closeWindow() {
        this.world.removeListener(this);
        this.canvas.finalize();
        this.dispose();
    }

    public void windowClosing(WindowEvent e) {
        this.closeWindow();
    }
}

