/*
 * Decompiled with CFR 0.152.
 */
package CIspace.planning;

import CIspace.planning.DialogAdapter;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public class ConfirmContinueDialog
extends DialogAdapter {
    protected String prompt;
    protected int result;
    public static final int CANCEL = 100;
    public static final int CONTINUE = 101;
    protected int numRows = 8;
    protected int numColumns = 60;

    public ConfirmContinueDialog(JFrame parent, String title, String prompt, int numRows, int numColumns) {
        super(parent, title, true);
        this.prompt = prompt;
        this.numRows = numRows;
        this.numColumns = numColumns;
        this.result = 100;
        this.constructDialog();
        this.pack();
        this.centerWindow();
        this.show();
    }

    protected void constructDialog() {
        JPanel buttonPanel = new JPanel();
        JButton continueButton = new JButton("Continue");
        continueButton.addActionListener(this);
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(this);
        buttonPanel.add(continueButton);
        buttonPanel.add(cancelButton);
        JTextArea text = new JTextArea(this.prompt, this.numRows, this.numColumns);
        text.setBackground(Color.lightGray);
        text.setEditable(false);
        this.getContentPane().add("North", text);
        this.getContentPane().add("South", buttonPanel);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand() == "Continue") {
            this.result = 101;
            this.hide();
        } else if (e.getActionCommand() == "Cancel") {
            this.result = 100;
            this.hide();
        }
    }

    public int getResult() {
        return this.result;
    }

    public void windowClosing(WindowEvent e) {
        this.result = 100;
        this.hide();
    }
}

