/*
 * Decompiled with CFR 0.152.
 */
package CIspace.planning;

import CIspace.XMLReader.Pair;
import CIspace.XMLReader.XMLBlock;
import CIspace.graphToolKit.Point;
import CIspace.planning.BlockGraph;
import CIspace.planning.BlockNode;
import CIspace.planning.BlockWorldLogicParser;
import CIspace.planning.PlanningProblemParser;
import CIspace.planning.World;
import java.awt.Color;
import java.util.Vector;

public class BlockWorldProblemParser
extends PlanningProblemParser {
    protected BlockGraph initialBlockGraph;
    protected BlockGraph goalBlockGraph;

    public BlockWorldProblemParser(String xmlFile, World world, BlockGraph initialBlockGraph, BlockGraph goalBlockGraph) {
        super(xmlFile, world);
        this.initialBlockGraph = initialBlockGraph;
        this.goalBlockGraph = goalBlockGraph;
        this.parser = new BlockWorldLogicParser("", initialBlockGraph);
    }

    public void parse() {
        this.loadBlockState(this.headBlock, this.initialBlockGraph, "InitialState");
        this.loadBlockState(this.headBlock, this.goalBlockGraph, "Goals");
        this.world.clearAllState();
        this.world.clearActions();
        this.parseState("InitialState");
        this.parseState("Goals");
        this.parseActions();
    }

    protected void loadBlockState(XMLBlock xmlBlock, BlockGraph graph, String state) {
        Vector xmlBlockVector = null;
        xmlBlockVector = xmlBlock.searchChildTag("Problem");
        if (xmlBlockVector == null) {
            return;
        }
        xmlBlock = (XMLBlock)xmlBlockVector.elementAt(0);
        if ((xmlBlockVector = xmlBlock.searchChildTag(state)) == null) {
            return;
        }
        xmlBlock = (XMLBlock)xmlBlockVector.elementAt(0);
        if ((xmlBlockVector = xmlBlock.searchChildTag("BlockWorld")) == null) {
            return;
        }
        xmlBlock = (XMLBlock)xmlBlockVector.elementAt(0);
        Vector blockTags = xmlBlock.searchChildTag("Block");
        if (blockTags == null) {
            return;
        }
        if (blockTags != null && blockTags.size() > 0) {
            int i = 0;
            while (i < blockTags.size()) {
                xmlBlock = (XMLBlock)blockTags.elementAt(i);
                BlockNode newBlock = new BlockNode(this.initialBlockGraph, this.initialBlockGraph.getNewLabel(), new Point(0.0f, 0.0f), Color.red.darker(), 1111);
                Vector properties = xmlBlock.getProperties();
                int j = 0;
                while (j < properties.size()) {
                    Pair currPair = (Pair)properties.elementAt(j);
                    if (currPair.name.equals("name")) {
                        newBlock.setBlockName(currPair.value);
                    } else if (currPair.name.equals("colour")) {
                        newBlock.setColourName(currPair.value);
                        if (newBlock.getColourName().equals("red")) {
                            newBlock.color = Color.red.darker();
                        } else if (newBlock.getColourName().equals("green")) {
                            newBlock.color = Color.green.darker();
                        } else if (newBlock.getColourName().equals("blue")) {
                            newBlock.color = Color.blue;
                        } else if (newBlock.getColourName().equals("cyan")) {
                            newBlock.color = Color.cyan;
                        } else if (newBlock.getColourName().equals("gray")) {
                            newBlock.color = Color.gray;
                        } else if (newBlock.getColourName().equals("orange")) {
                            newBlock.color = Color.orange;
                        } else if (newBlock.getColourName().equals("black")) {
                            newBlock.color = Color.black;
                        }
                    } else if (currPair.name.equals("column")) {
                        newBlock.setColumn(new Integer(currPair.value));
                    } else if (currPair.name.equals("stackHeight")) {
                        newBlock.setStackHeight(new Integer(currPair.value));
                    }
                    ++j;
                }
                graph.loadBlock(newBlock);
                ++i;
            }
        }
    }
}

